/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.events.InitOrResizeScreenEvent;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VanillaButtonDescriptionHandler {
    private static Map<AbstractWidget, String> descriptions = new HashMap<AbstractWidget, String>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new VanillaButtonDescriptionHandler());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInitPre(InitOrResizeScreenEvent.Pre e) {
        descriptions.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(ScreenEvent.Render.Post e) {
        for (Map.Entry<AbstractWidget, String> m : descriptions.entrySet()) {
            if (!m.getKey().m_198029_()) continue;
            VanillaButtonDescriptionHandler.renderDescription(e.getGuiGraphics(), e.getMouseX(), e.getMouseY(), m.getValue());
            break;
        }
    }

    public static void setDescriptionFor(AbstractWidget w, String desc) {
        descriptions.put(w, desc);
    }

    private static void renderDescriptionBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, new Color(26, 26, 26, 250).getRGB());
    }

    private static void renderDescription(GuiGraphics graphics, int mouseX, int mouseY, String desc) {
        if (desc != null) {
            String[] descArray;
            int width = 10;
            int height = 10;
            for (String s : descArray = StringUtils.splitLines((String)desc, (String)"%n%")) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.m_91087_().f_91080_.f_96543_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.m_91087_().f_91080_.f_96544_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((PoseStack)graphics.m_280168_(), (int)600);
            VanillaButtonDescriptionHandler.renderDescriptionBackground(graphics, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : descArray) {
                graphics.m_280488_(Minecraft.m_91087_().f_91062_, s, mouseX + 5, mouseY + i2, Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((PoseStack)graphics.m_280168_());
            RenderSystem.disableBlend();
        }
    }
}

