/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.display.DisplaySpec;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.RecipeIngredientRole;

public class JEIRecipeLookup<R>
implements IRecipeLookup<R> {
    private final CategoryIdentifier<?> categoryIdentifier;
    private final List<IFocus<?>> focui = new ArrayList();
    private boolean includesHidden = false;

    public JEIRecipeLookup(CategoryIdentifier<?> categoryIdentifier) {
        this.categoryIdentifier = categoryIdentifier;
    }

    @Override
    public IRecipeLookup<R> limitFocus(Collection<? extends IFocus<?>> focuses) {
        this.focui.addAll(focuses);
        return this;
    }

    @Override
    public IRecipeLookup<R> includeHidden() {
        this.includesHidden = true;
        return this;
    }

    @Override
    public Stream<R> get() {
        ViewSearchBuilder builder = ViewSearchBuilder.builder().filterCategory(this.categoryIdentifier);
        for (IFocus<?> focus : this.focui) {
            EntryStack<?> stack = JEIPluginDetector.unwrapStack(focus.getTypedValue());
            if (focus.getRole() == RecipeIngredientRole.INPUT || focus.getRole() == RecipeIngredientRole.CATALYST) {
                builder.addUsagesFor(stack);
                continue;
            }
            builder.addRecipesFor(stack);
        }
        if (this.includesHidden) {
            builder.processingVisibilityHandlers(false);
        }
        return builder.streamDisplays().map(DisplaySpec::provideInternalDisplay).map(display -> MoreObjects.firstNonNull((Object)JEIPluginDetector.jeiValue(display), (Object)display));
    }
}

