/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.mcjty_lib;

import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.addon.mcjty_lib.McjtyLibPlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum BaseBlockProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        IThemeHelper t = IThemeHelper.get();
        if (data.m_128441_("Infused")) {
            tooltip.add((Component)Component.m_237110_((String)"jadeaddons.mcjtylib.infused", (Object[])new Object[]{t.info((Object)data.m_128451_("Infused"))}));
        }
        if (data.m_128441_("SecurityChannel")) {
            int channel = data.m_128451_("SecurityChannel");
            String name = data.m_128461_("OwnerName");
            if (channel == -1) {
                tooltip.add((Component)Component.m_237110_((String)"jadeaddons.mcjtylib.ownedBy", (Object[])new Object[]{name}));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"jadeaddons.mcjtylib.ownedBy.withChannel", (Object[])new Object[]{name, channel}));
            }
            if (data.m_128471_("OwnerWarning")) {
                tooltip.add((Component)t.warning((Object)Component.m_237115_((String)"jadeaddons.mcjtylib.ownedBy.warning")));
            }
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        GenericTileEntity generic;
        if (!(accessor.getBlock() instanceof BaseBlock)) {
            return;
        }
        accessor.getBlockEntity().getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> {
            int infused = h.getInfused();
            int pct = infused * 100 / (Integer)GeneralConfig.maxInfuse.get();
            data.m_128405_("Infused", pct);
        });
        if (((Boolean)GeneralConfig.manageOwnership.get()).booleanValue() && (generic = (GenericTileEntity)accessor.getBlockEntity()).getOwnerName() != null && !generic.getOwnerName().isEmpty()) {
            data.m_128405_("SecurityChannel", generic.getSecurityChannel());
            data.m_128359_("OwnerName", generic.getOwnerName());
            if (generic.getOwnerUUID() == null) {
                data.m_128379_("OwnerWarning", true);
            }
        }
    }

    public ResourceLocation getUid() {
        return McjtyLibPlugin.GENERAL;
    }
}

