/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidFallThroughEvent;
import net.blay09.mods.forgivingvoid.mixin.ServerGamePacketListenerImplAccessor;
import net.blay09.mods.forgivingvoid.mixin.ServerPlayerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";

    public static void initialize() {
        ForgivingVoidConfig.initialize();
        Balm.getEvents().onEvent(LivingFallEvent.class, ForgivingVoid::onPlayerFall);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, ForgivingVoid::onPlayerTick);
    }

    public static void onPlayerTick(ServerPlayer player) {
        int triggerAtY = player.m_9236_().m_141937_() - ForgivingVoidConfig.getActive().triggerAtDistanceBelow;
        boolean isInVoid = player.m_20186_() < (double)triggerAtY && player.f_19855_ < (double)triggerAtY;
        boolean isTeleporting = ((ServerGamePacketListenerImplAccessor)player.f_8906_).getAwaitingPositionFromClient() != null;
        CompoundTag persistentData = Balm.getHooks().getPersistentData((Player)player);
        if (ForgivingVoid.isEnabledForDimension((ResourceKey<Level>)player.m_9236_().m_46472_()) && isInVoid && !isTeleporting && ForgivingVoid.fireForgivingVoidEvent((Player)player)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 3));
            if (player.m_20160_()) {
                player.m_20153_();
            }
            player.m_8127_();
            ((ServerPlayerAccessor)player).setIsChangingDimension(true);
            player.m_6021_(player.m_20185_(), (double)ForgivingVoidConfig.getActive().fallingHeight, player.m_20189_());
            persistentData.m_128379_("ForgivingVoidIsFalling", true);
        } else if (persistentData.m_128471_("ForgivingVoidIsFalling")) {
            BlockPos playerPos = player.m_20183_();
            if (player.m_20069_() || player.m_20096_() || player.m_150110_().f_35935_ || player.m_150110_().f_35936_ || player.m_9236_().m_8055_(playerPos).m_60734_() == Blocks.f_50033_) {
                persistentData.m_128379_("ForgivingVoidIsFalling", false);
                ((ServerPlayerAccessor)player).setIsChangingDimension(false);
                return;
            }
            if (ForgivingVoidConfig.getActive().disableVanillaAntiCheatWhileFalling) {
                ((ServerPlayerAccessor)player).setIsChangingDimension(true);
            }
        }
    }

    public static void onPlayerFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CompoundTag persistentData = Balm.getHooks().getPersistentData((Player)player);
            if (persistentData.m_128471_("ForgivingVoidIsFalling")) {
                float damage = ForgivingVoidConfig.getActive().damageOnFall;
                if (ForgivingVoidConfig.getActive().preventDeath && player.m_21223_() - damage <= 0.0f) {
                    damage = player.m_21223_() - 1.0f;
                }
                event.setFallDamageOverride(Float.valueOf(damage));
                ((ServerPlayerAccessor)player).setIsChangingDimension(false);
            }
        }
    }

    private static boolean fireForgivingVoidEvent(Player player) {
        ForgivingVoidFallThroughEvent event = new ForgivingVoidFallThroughEvent(player);
        Balm.getEvents().fireEvent((Object)event);
        return !event.isCanceled();
    }

    private static boolean isEnabledForDimension(ResourceKey<Level> dimensionKey) {
        if (dimensionKey == Level.f_46428_) {
            return ForgivingVoidConfig.getActive().triggerInOverworld;
        }
        if (dimensionKey == Level.f_46430_) {
            return ForgivingVoidConfig.getActive().triggerInEnd;
        }
        if (dimensionKey == Level.f_46429_) {
            return ForgivingVoidConfig.getActive().triggerInNether;
        }
        ResourceLocation dimension = dimensionKey.m_135782_();
        List<String> dimensionAllowList = ForgivingVoidConfig.getActive().dimensionAllowList;
        List<String> dimensionDenyList = ForgivingVoidConfig.getActive().dimensionDenyList;
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension.toString())) {
            return false;
        }
        return !dimensionDenyList.contains(dimension.toString());
    }
}

