/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.volume.AdjustVolumeList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AdjustVolumesScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_volumes.png");
    protected static final Component TITLE = Component.m_237115_((String)"gui.voicechat.adjust_volume.title");
    protected static final Component SEARCH_HINT = Component.m_237115_((String)"message.voicechat.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    protected static final Component EMPTY_SEARCH = Component.m_237115_((String)"message.voicechat.search_empty").m_130940_(ChatFormatting.GRAY);
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 8;
    protected static final int SEARCH_HEIGHT = 16;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected AdjustVolumeList volumeList;
    protected EditBox searchBox;
    protected String lastSearch = "";
    protected int units;

    public AdjustVolumesScreen() {
        super(TITLE, 236, 0);
    }

    public void m_86600_() {
        super.m_86600_();
        this.searchBox.m_94120_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.m_14167_((float)3.1111112f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 8 - this.guiTop * 2 - 16) / 18);
        this.ySize = 16 + this.units * 18 + 8;
        if (this.volumeList != null) {
            this.volumeList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18);
        } else {
            this.volumeList = new AdjustVolumeList(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18, 36, this);
        }
        String string = this.searchBox != null ? this.searchBox.m_94155_() : "";
        this.searchBox = new EditBox(this.f_96547_, this.guiLeft + 28, this.guiTop + 16 + 6, 196, 16, SEARCH_HINT);
        this.searchBox.m_94199_(16);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(string);
        this.searchBox.m_94151_(this::checkSearchStringUpdate);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.volumeList);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 8);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, TITLE, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2, this.guiTop + 5, 0x404040, false);
        if (!this.volumeList.isEmpty()) {
            this.volumeList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else if (!this.searchBox.m_94155_().isEmpty()) {
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280653_(this.f_96547_, EMPTY_SEARCH, n, n2 - 9 / 2, -1);
        }
        if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, SEARCH_HINT, this.searchBox.m_252754_(), this.searchBox.m_252907_(), -1, false);
        } else {
            this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchBox.m_93696_()) {
            this.searchBox.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button) || this.volumeList.m_6375_(mouseX, mouseY, button);
    }

    private void checkSearchStringUpdate(String string) {
        if (!(string = string.toLowerCase(Locale.ROOT)).equals(this.lastSearch)) {
            this.volumeList.setFilter(string);
            this.lastSearch = string;
        }
    }
}

