/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import wayoftime.bloodmagic.altar.ComponentType;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.api.IBloodMagicAPI;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.impl.BloodMagicBlacklist;
import wayoftime.bloodmagic.impl.BloodMagicRecipeRegistrar;
import wayoftime.bloodmagic.impl.BloodMagicValueManager;
import wayoftime.bloodmagic.incense.EnumTranquilityType;
import wayoftime.bloodmagic.incense.IncenseTranquilityRegistry;
import wayoftime.bloodmagic.incense.TranquilityStack;
import wayoftime.bloodmagic.util.BMLog;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class BloodMagicAPI
implements IBloodMagicAPI {
    public static final BloodMagicAPI INSTANCE = new BloodMagicAPI();
    private final BloodMagicBlacklist blacklist = new BloodMagicBlacklist();
    private final BloodMagicRecipeRegistrar recipeRegistrar = new BloodMagicRecipeRegistrar();
    private final BloodMagicValueManager valueManager = new BloodMagicValueManager();
    private final Multimap<ComponentType, BlockState> altarComponents = ArrayListMultimap.create();
    private final Map<String, Function<Player, NonNullList<ItemStack>>> inventoryProvider = new HashMap<String, Function<Player, NonNullList<ItemStack>>>();
    private final List<String> activeInventories = new ArrayList<String>();
    @Nonnull
    private static final Lazy<ResourceKey<? extends Registry<Anointment>>> ANOINTMENT_REGISTRY_NAME = BloodMagicAPI.registryKey(Anointment.class, "anointment");
    @Nonnull
    private static final Lazy<ResourceKey<? extends Registry<BloodOrb>>> BLOOD_ORB_REGISTRY_NAME = BloodMagicAPI.registryKey(BloodOrb.class, "bloodorbs");
    @Nonnull
    private static final Lazy<ResourceKey<? extends Registry<LivingUpgrade>>> LIVING_UPGRADE_REGISTRY_NAME = BloodMagicAPI.registryKey(LivingUpgrade.class, "upgrades");

    @Nonnull
    private static <T> Lazy<ResourceKey<? extends Registry<T>>> registryKey(@Nonnull Class<T> compileTimeTypeValidator, @Nonnull String path) {
        return Lazy.of(() -> ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("bloodmagic", path)));
    }

    @Nonnull
    public static ResourceKey<? extends Registry<Anointment>> anointmentRegistryName() {
        return (ResourceKey)ANOINTMENT_REGISTRY_NAME.get();
    }

    @Nonnull
    public static ResourceKey<? extends Registry<BloodOrb>> bloodOrbRegistryName() {
        return (ResourceKey)BLOOD_ORB_REGISTRY_NAME.get();
    }

    @Nonnull
    public static ResourceKey<? extends Registry<LivingUpgrade>> LivingUpgradeRegistryName() {
        return (ResourceKey)LIVING_UPGRADE_REGISTRY_NAME.get();
    }

    @Override
    @Nonnull
    public BloodMagicBlacklist getBlacklist() {
        return this.blacklist;
    }

    @Nonnull
    public BloodMagicRecipeRegistrar getRecipeRegistrar() {
        return this.recipeRegistrar;
    }

    @Override
    @Nonnull
    public BloodMagicValueManager getValueManager() {
        return this.valueManager;
    }

    @Nonnull
    public Map<String, Function<Player, NonNullList<ItemStack>>> getInventoryProvider() {
        return this.inventoryProvider;
    }

    public Map<String, Function<Player, NonNullList<ItemStack>>> getActiveInventoryProvider() {
        HashMap<String, Function<Player, NonNullList<ItemStack>>> activeInventoryProvider = new HashMap<String, Function<Player, NonNullList<ItemStack>>>();
        this.activeInventories.forEach(key -> activeInventoryProvider.put((String)key, this.inventoryProvider.get(key)));
        return activeInventoryProvider;
    }

    @Override
    public void registerActiveInventoryProvider(String inventoryIdentifier) {
        this.activeInventories.add(inventoryIdentifier);
    }

    @Override
    public void registerAltarComponent(@Nonnull BlockState state, @Nonnull String componentType) {
        ComponentType component = ComponentType.getType(componentType);
        if (component != null) {
            BMLog.API_VERBOSE.info("Registered {} as a {} altar component.", state, componentType);
            this.altarComponents.put((Object)component, (Object)state);
        } else {
            BMLog.API.warn("Invalid Altar component type: {}.", componentType);
        }
    }

    @Override
    public void unregisterAltarComponent(@Nonnull BlockState state, @Nonnull String componentType) {
        ComponentType component = ComponentType.getType(componentType);
        if (component != null) {
            BMLog.API_VERBOSE.info("Unregistered {} from being a {} altar component.", state, componentType);
            this.altarComponents.remove((Object)component, (Object)state);
        } else {
            BMLog.API.warn("Invalid Altar component type: {}.", componentType);
        }
    }

    @Override
    public void registerTranquilityHandler(@Nonnull Predicate<BlockState> blockState, @Nonnull String tranquilityType, double value) {
        EnumTranquilityType type = EnumTranquilityType.getType(tranquilityType);
        if (type != null) {
            IncenseTranquilityRegistry.registerTranquilityHandler((world, pos, block, state) -> blockState.test(state) ? new TranquilityStack(type, value) : null);
        } else {
            BMLog.API.warn("Invalid Tranquility type: {}.", tranquilityType);
        }
    }

    @Override
    public void registerInventoryProvider(String inventoryIdentifier, Function<Player, NonNullList<ItemStack>> provider) {
        this.inventoryProvider.put(inventoryIdentifier, provider);
    }

    @Override
    public double getTotalDemonWill(String willType, Player player) {
        return PlayerDemonWillHandler.getTotalDemonWill(EnumDemonWillType.getType(willType), player);
    }

    @Nonnull
    public List<BlockState> getComponentStates(ComponentType component) {
        return (List)this.altarComponents.get((Object)component);
    }
}

