/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile.routing;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import wayoftime.bloodmagic.common.tile.routing.TileRoutingNode;

public class TileFilteredRoutingNode
extends TileRoutingNode
implements WorldlyContainer {
    private int currentActiveSlot = -1;
    public int[] priorities = new int[6];

    public TileFilteredRoutingNode(BlockEntityType<?> type, int size, String name, BlockPos pos, BlockState state) {
        super(type, size, name, pos, state);
    }

    public ItemStack getFilterStack(Direction side) {
        int index = side.m_122411_();
        return this.m_8020_(index);
    }

    public int getCurrentActiveSlot() {
        if (this.currentActiveSlot == -1) {
            this.currentActiveSlot = 0;
            for (Direction dir : Direction.values()) {
                LazyOptional opt;
                BlockPos offsetPos = this.getCurrentBlockPos().m_121945_(dir);
                BlockEntity tile = this.f_58857_.m_7702_(offsetPos);
                if (tile == null || (opt = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_())) == null || !opt.isPresent()) continue;
                this.currentActiveSlot = dir.ordinal();
                break;
            }
        }
        return this.currentActiveSlot;
    }

    public void setCurrentActiveSlot(int slot) {
        this.currentActiveSlot = slot;
    }

    @Override
    public boolean isInventoryConnectedToSide(Direction side) {
        return true;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.currentActiveSlot = tag.m_128451_("currentSlot");
        this.priorities = tag.m_128465_("prioritiesPeople");
        if (this.priorities.length != 6) {
            this.priorities = new int[6];
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        tag.m_128405_("currentSlot", this.currentActiveSlot);
        tag.m_128385_("prioritiesPeople", this.priorities);
        tag.m_128379_("updated", true);
        return tag;
    }

    public void swapFilters(int requestedSlot) {
        this.currentActiveSlot = requestedSlot;
        this.m_6596_();
    }

    public int[] m_7071_(Direction side) {
        return new int[0];
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Override
    public int getPriority(Direction side) {
        return this.priorities[side.m_122411_()];
    }

    public void incrementCurrentPriotiryToMaximum(int max) {
        this.priorities[this.currentActiveSlot] = Math.min(this.priorities[this.currentActiveSlot] + 1, max);
        BlockState state = this.m_58904_().m_8055_(this.f_58858_);
        this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
    }

    public void decrementCurrentPriority() {
        this.priorities[this.currentActiveSlot] = Math.max(this.priorities[this.currentActiveSlot] - 1, 0);
        BlockState state = this.m_58904_().m_8055_(this.f_58858_);
        this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
    }
}

