/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.altar;

import com.google.common.base.Enums;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.altar.AltarUpgrade;
import wayoftime.bloodmagic.altar.AltarUtil;
import wayoftime.bloodmagic.api.event.BloodMagicCraftedEvent;
import wayoftime.bloodmagic.block.enums.BloodRuneType;
import wayoftime.bloodmagic.common.fluid.BloodMagicFluids;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.common.tile.TileAltar;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class BloodAltar {
    public boolean isActive;
    protected FluidStack fluidOutput = new FluidStack((Fluid)BloodMagicFluids.LIFE_ESSENCE_FLUID.get(), 0);
    protected FluidStack fluidInput = new FluidStack((Fluid)BloodMagicFluids.LIFE_ESSENCE_FLUID.get(), 0);
    protected FluidTank tank = new FluidTank(1000);
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private TileAltar tileAltar;
    private int internalCounter = 0;
    private AltarTier altarTier = AltarTier.ONE;
    private AltarUpgrade upgrade;
    private int capacity = 10000;
    private FluidStack fluid = new FluidStack((Fluid)BloodMagicFluids.LIFE_ESSENCE_FLUID.get(), 0);
    private int liquidRequired;
    private boolean canBeFilled;
    private int consumptionRate;
    private int drainRate;
    private float consumptionMultiplier;
    private float efficiencyMultiplier;
    private float sacrificeEfficiencyMultiplier;
    private float selfSacrificeEfficiencyMultiplier;
    private float capacityMultiplier = 1.0f;
    private float orbCapacityMultiplier;
    private float dislocationMultiplier;
    private int accelerationUpgrades;
    private boolean isUpgraded;
    private boolean isResultBlock;
    private int bufferCapacity = 1000;
    private int progress;
    private int lockdownDuration;
    private int demonBloodDuration;
    private int totalCharge = 0;
    private int chargingRate = 0;
    private int chargingFrequency = 0;
    private int maxCharge = 0;
    private int cooldownAfterCrafting = 60;
    private RecipeBloodAltar recipe;
    private AltarTier currentTierDisplayed = AltarTier.ONE;

    public BloodAltar(TileAltar tileAltar) {
        this.tileAltar = tileAltar;
    }

    public void readFromNBT(CompoundTag tagCompound) {
        if (!tagCompound.m_128441_("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound);
            if (fluid != null) {
                this.setMainFluid(new FluidStack((Fluid)BloodMagicFluids.LIFE_ESSENCE_FLUID.get(), fluid.getAmount()));
            }
            FluidStack fluidOut = new FluidStack((Fluid)BloodMagicFluids.LIFE_ESSENCE_FLUID.get(), tagCompound.m_128451_("outputAmount"));
            this.setOutputFluid(fluidOut);
            FluidStack fluidIn = new FluidStack((Fluid)BloodMagicFluids.LIFE_ESSENCE_FLUID.get(), tagCompound.m_128451_("inputAmount"));
            this.setInputFluid(fluidIn);
        }
        this.internalCounter = tagCompound.m_128451_("internalCounter");
        this.altarTier = (AltarTier)((Object)Enums.getIfPresent(AltarTier.class, (String)tagCompound.m_128461_("upgradeLevel")).or((Object)AltarTier.ONE));
        this.isActive = tagCompound.m_128471_("isActive");
        this.liquidRequired = tagCompound.m_128451_("liquidRequired");
        this.canBeFilled = tagCompound.m_128471_("fillable");
        this.isUpgraded = tagCompound.m_128471_("isUpgraded");
        this.consumptionRate = tagCompound.m_128451_("consumptionRate");
        this.drainRate = tagCompound.m_128451_("drainRate");
        this.consumptionMultiplier = tagCompound.m_128457_("consumptionMultiplier");
        this.efficiencyMultiplier = tagCompound.m_128457_("efficiencyMultiplier");
        this.selfSacrificeEfficiencyMultiplier = tagCompound.m_128457_("selfSacrificeMultiplier");
        this.sacrificeEfficiencyMultiplier = tagCompound.m_128457_("sacrificeMultiplier");
        this.capacityMultiplier = tagCompound.m_128457_("capacityMultiplier");
        this.orbCapacityMultiplier = tagCompound.m_128457_("orbCapacityMultiplier");
        this.dislocationMultiplier = tagCompound.m_128457_("dislocationMultiplier");
        this.capacity = tagCompound.m_128451_("capacity");
        this.bufferCapacity = tagCompound.m_128451_("bufferCapacity");
        this.progress = tagCompound.m_128451_("progress");
        this.isResultBlock = tagCompound.m_128471_("isResultBlock");
        this.lockdownDuration = tagCompound.m_128451_("lockdownDuration");
        this.accelerationUpgrades = tagCompound.m_128451_("accelerationUpgrades");
        this.demonBloodDuration = tagCompound.m_128451_("demonBloodDuration");
        this.cooldownAfterCrafting = tagCompound.m_128451_("cooldownAfterCrafting");
        this.chargingRate = tagCompound.m_128451_("chargeRate");
        this.chargingFrequency = tagCompound.m_128451_("chargeFrequency");
        this.totalCharge = tagCompound.m_128451_("totalCharge");
        this.maxCharge = tagCompound.m_128451_("maxCharge");
        this.currentTierDisplayed = (AltarTier)((Object)Enums.getIfPresent(AltarTier.class, (String)tagCompound.m_128461_("currentTierDisplayed")).or((Object)AltarTier.ONE));
    }

    public void writeToNBT(CompoundTag tagCompound) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(tagCompound);
        } else {
            tagCompound.m_128359_("Empty", "");
        }
        if (this.fluidOutput != null) {
            tagCompound.m_128405_("outputAmount", this.fluidOutput.getAmount());
        }
        if (this.fluidInput != null) {
            tagCompound.m_128405_("inputAmount", this.fluidInput.getAmount());
        }
        tagCompound.m_128405_("internalCounter", this.internalCounter);
        tagCompound.m_128359_("upgradeLevel", this.altarTier.name());
        tagCompound.m_128379_("isActive", this.isActive);
        tagCompound.m_128405_("liquidRequired", this.liquidRequired);
        tagCompound.m_128379_("fillable", this.canBeFilled);
        tagCompound.m_128379_("isUpgraded", this.isUpgraded);
        tagCompound.m_128405_("consumptionRate", this.consumptionRate);
        tagCompound.m_128405_("drainRate", this.drainRate);
        tagCompound.m_128350_("consumptionMultiplier", this.consumptionMultiplier);
        tagCompound.m_128350_("efficiencyMultiplier", this.efficiencyMultiplier);
        tagCompound.m_128350_("sacrificeMultiplier", this.sacrificeEfficiencyMultiplier);
        tagCompound.m_128350_("selfSacrificeMultiplier", this.selfSacrificeEfficiencyMultiplier);
        tagCompound.m_128379_("isResultBlock", this.isResultBlock);
        tagCompound.m_128350_("capacityMultiplier", this.capacityMultiplier);
        tagCompound.m_128350_("orbCapacityMultiplier", this.orbCapacityMultiplier);
        tagCompound.m_128350_("dislocationMultiplier", this.dislocationMultiplier);
        tagCompound.m_128405_("capacity", this.capacity);
        tagCompound.m_128405_("progress", this.progress);
        tagCompound.m_128405_("bufferCapacity", this.bufferCapacity);
        tagCompound.m_128405_("lockdownDuration", this.lockdownDuration);
        tagCompound.m_128405_("accelerationUpgrades", this.accelerationUpgrades);
        tagCompound.m_128405_("demonBloodDuration", this.demonBloodDuration);
        tagCompound.m_128405_("cooldownAfterCrafting", this.cooldownAfterCrafting);
        tagCompound.m_128405_("chargeRate", this.chargingRate);
        tagCompound.m_128405_("chargeFrequency", this.chargingFrequency);
        tagCompound.m_128405_("totalCharge", this.totalCharge);
        tagCompound.m_128405_("maxCharge", this.maxCharge);
        tagCompound.m_128359_("currentTierDisplayed", this.currentTierDisplayed.name());
    }

    public void startCycle() {
        ItemStack input;
        if (this.tileAltar.m_58904_() != null) {
            this.tileAltar.m_58904_().m_7260_(this.tileAltar.m_58899_(), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), 3);
        }
        this.checkTier();
        if ((this.fluid == null || this.fluid.getAmount() <= 0) && this.totalCharge <= 0) {
            return;
        }
        if (!this.isActive) {
            this.progress = 0;
        }
        if (!(input = this.tileAltar.m_8020_(0)).m_41619_()) {
            RecipeBloodAltar recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getBloodAltar(this.tileAltar.m_58904_(), input);
            if (recipe != null) {
                if (recipe.getMinimumTier() <= this.altarTier.ordinal()) {
                    this.isActive = true;
                    this.recipe = recipe;
                    this.liquidRequired = recipe.getSyphon();
                    this.consumptionRate = recipe.getConsumeRate();
                    this.drainRate = recipe.getDrainRate();
                    this.canBeFilled = false;
                    return;
                }
            } else if (input.m_41720_() instanceof IBloodOrb) {
                this.isActive = true;
                this.canBeFilled = true;
                return;
            }
        }
        this.isActive = false;
    }

    public void update() {
        Level world = this.tileAltar.m_58904_();
        BlockPos pos = this.tileAltar.m_58899_();
        if (world.f_46443_) {
            return;
        }
        ++this.internalCounter;
        if (this.lockdownDuration > 0) {
            --this.lockdownDuration;
        }
        if (this.internalCounter % 20 == 0) {
            for (Direction facing : Direction.values()) {
                BlockPos newPos = pos.m_121945_(facing);
                BlockState block = world.m_8055_(newPos);
                block.m_60734_().onNeighborChange(block, (LevelReader)world, newPos, pos);
            }
        }
        if (this.internalCounter % Math.max(20 - this.accelerationUpgrades, 1) == 0) {
            int syphonMax = (int)(20.0f * this.dislocationMultiplier);
            int fluidInputted = Math.min(syphonMax, -this.fluid.getAmount() + this.capacity);
            fluidInputted = Math.min(this.fluidInput.getAmount(), fluidInputted);
            this.fluid.setAmount(this.fluid.getAmount() + fluidInputted);
            this.fluidInput.setAmount(this.fluidInput.getAmount() - fluidInputted);
            int fluidOutputted = Math.min(syphonMax, this.bufferCapacity - this.fluidOutput.getAmount());
            fluidOutputted = Math.min(this.fluid.getAmount(), fluidOutputted);
            this.fluidOutput.setAmount(this.fluidOutput.getAmount() + fluidOutputted);
            this.fluid.setAmount(this.fluid.getAmount() - fluidOutputted);
            this.tileAltar.m_58904_().m_7260_(this.tileAltar.m_58899_(), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), 3);
        }
        if (this.internalCounter % this.getChargingFrequency() == 0 && !this.isActive) {
            int chargeInputted = Math.min(this.chargingRate, this.fluid.getAmount());
            chargeInputted = Math.min(chargeInputted, this.maxCharge - this.totalCharge);
            this.totalCharge += chargeInputted;
            this.fluid.setAmount(this.fluid.getAmount() - chargeInputted);
            this.tileAltar.m_58904_().m_7260_(this.tileAltar.m_58899_(), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), 3);
        }
        if (this.internalCounter % 100 == 0 && (this.isActive || this.cooldownAfterCrafting <= 0)) {
            this.startCycle();
        }
        this.updateAltar();
    }

    private void updateAltar() {
        if (this.tileAltar.getOutputState()) {
            this.tileAltar.setOutputState(false);
        }
        if (!this.isActive) {
            if (this.cooldownAfterCrafting > 0) {
                --this.cooldownAfterCrafting;
                if (this.cooldownAfterCrafting <= 0) {
                    this.startCycle();
                }
            }
            return;
        }
        if (!this.canBeFilled && this.recipe == null) {
            this.startCycle();
            return;
        }
        ItemStack input = this.tileAltar.m_8020_(0);
        if (input.m_41619_()) {
            return;
        }
        Level world = this.tileAltar.m_58904_();
        BlockPos pos = this.tileAltar.m_58899_();
        if (world.f_46443_) {
            return;
        }
        if (!this.canBeFilled) {
            boolean hasOperated = false;
            int stackSize = input.m_41613_();
            if (this.totalCharge > 0) {
                int chargeDrained = Math.min(this.liquidRequired * stackSize - this.progress, this.totalCharge);
                this.totalCharge -= chargeDrained;
                this.progress += chargeDrained;
                hasOperated = true;
            }
            if (this.fluid != null && this.fluid.getAmount() >= 1) {
                int liquidDrained = Math.min((int)((float)this.consumptionRate * (1.0f + this.consumptionMultiplier)), this.fluid.getAmount());
                if (liquidDrained > this.liquidRequired * stackSize - this.progress) {
                    liquidDrained = this.liquidRequired * stackSize - this.progress;
                }
                this.fluid.setAmount(this.fluid.getAmount() - liquidDrained);
                this.progress += liquidDrained;
                hasOperated = true;
                if (this.internalCounter % 4 == 0 && world instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)world;
                    server.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
                }
            } else if (!hasOperated && this.progress > 0) {
                this.progress -= (int)(this.efficiencyMultiplier * (float)this.drainRate);
                if (this.progress < 0) {
                    this.progress = 0;
                }
                if (this.internalCounter % 2 == 0 && world instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)world;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 1, 0.1, 0.0, 0.1, 0.0);
                }
            }
            if (hasOperated && this.progress >= this.liquidRequired * stackSize) {
                ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)this.recipe.getOutput(), (int)stackSize);
                BloodMagicCraftedEvent.Altar event = new BloodMagicCraftedEvent.Altar(result, input.m_41777_());
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.tileAltar.m_6836_(0, event.getOutput());
                if (this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_().m_7495_()).m_60734_() instanceof RedstoneLampBlock) {
                    this.tileAltar.setOutputState(true);
                }
                this.progress = 0;
                if (world instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)world;
                    server.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 40, 0.3, 0.0, 0.3, 0.0);
                }
                this.cooldownAfterCrafting = 30;
                this.isActive = false;
            }
        } else {
            ItemStack contained = this.tileAltar.m_8020_(0);
            if (contained.m_41619_() || !(contained.m_41720_() instanceof IBloodOrb) || !(contained.m_41720_() instanceof IBindable)) {
                return;
            }
            BloodOrb orb = ((IBloodOrb)contained.m_41720_()).getOrb(contained);
            Binding binding = ((IBindable)contained.m_41720_()).getBinding(contained);
            if (binding == null || orb == null) {
                return;
            }
            if (this.fluid != null && this.fluid.getAmount() >= 1) {
                int liquidDrained = Math.min((int)((float)orb.getFillRate() * (1.0f + this.consumptionMultiplier)), this.fluid.getAmount());
                int drain = NetworkHelper.getSoulNetwork(binding).add(liquidDrained, (int)((float)orb.getCapacity() * this.orbCapacityMultiplier));
                this.fluid.setAmount(this.fluid.getAmount() - drain);
                if (drain > 0 && this.internalCounter % 4 == 0 && world instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)world;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.001);
                }
            }
        }
        this.tileAltar.m_58904_().m_7260_(this.tileAltar.m_58899_(), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), 3);
    }

    public void checkTier() {
        AltarTier tier;
        this.altarTier = tier = AltarUtil.getTier(this.tileAltar.m_58904_(), this.tileAltar.m_58899_());
        this.upgrade = AltarUtil.getUpgrades(this.tileAltar.m_58904_(), this.tileAltar.m_58899_(), tier);
        if (tier.equals((Object)this.currentTierDisplayed)) {
            this.currentTierDisplayed = AltarTier.ONE;
        }
        if (tier.equals((Object)AltarTier.ONE)) {
            this.upgrade = null;
            this.isUpgraded = false;
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.accelerationUpgrades = 0;
            this.chargingFrequency = 20;
            this.chargingRate = 0;
            this.maxCharge = 0;
            this.totalCharge = 0;
            return;
        }
        if (!tier.equals((Object)AltarTier.ONE)) {
            this.isUpgraded = true;
            this.accelerationUpgrades = this.upgrade.getLevel(BloodRuneType.ACCELERATION);
            this.consumptionMultiplier = (float)(0.2 * (double)this.upgrade.getLevel(BloodRuneType.SPEED));
            this.efficiencyMultiplier = (float)Math.pow(0.85, this.upgrade.getLevel(BloodRuneType.EFFICIENCY));
            this.sacrificeEfficiencyMultiplier = (float)(0.1 * (double)this.upgrade.getLevel(BloodRuneType.SACRIFICE));
            this.selfSacrificeEfficiencyMultiplier = (float)(0.1 * (double)this.upgrade.getLevel(BloodRuneType.SELF_SACRIFICE));
            int cap = this.upgrade.getLevel(BloodRuneType.CAPACITY);
            int cap_aug = this.upgrade.getLevel(BloodRuneType.AUGMENTED_CAPACITY);
            this.capacityMultiplier = (float)((1.0 + 0.2 * (double)cap) * Math.pow(1.075, cap_aug));
            this.dislocationMultiplier = (float)Math.pow(1.2, this.upgrade.getLevel(BloodRuneType.DISPLACEMENT));
            this.orbCapacityMultiplier = (float)(1.0 + 0.02 * (double)this.upgrade.getLevel(BloodRuneType.ORB));
            this.chargingFrequency = Math.max(20 - this.accelerationUpgrades, 1);
            this.chargingRate = (int)((float)(10 * this.upgrade.getLevel(BloodRuneType.CHARGING)) * (1.0f + this.consumptionMultiplier / 2.0f));
            this.maxCharge = (int)(1000.0 * Math.max(0.5 * (double)this.capacityMultiplier, 1.0) * (double)this.upgrade.getLevel(BloodRuneType.CHARGING));
        }
        this.capacity = (int)(10000.0f * this.capacityMultiplier);
        this.bufferCapacity = (int)(1000.0f * this.capacityMultiplier);
        if (this.fluid.getAmount() > this.capacity) {
            this.fluid.setAmount(this.capacity);
        }
        if (this.fluidOutput.getAmount() > this.bufferCapacity) {
            this.fluidOutput.setAmount(this.bufferCapacity);
        }
        if (this.fluidInput.getAmount() > this.bufferCapacity) {
            this.fluidInput.setAmount(this.bufferCapacity);
        }
        if (this.totalCharge > this.maxCharge) {
            this.totalCharge = this.maxCharge;
        }
        this.tileAltar.m_58904_().m_7260_(this.tileAltar.m_58899_(), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), this.tileAltar.m_58904_().m_8055_(this.tileAltar.m_58899_()), 3);
    }

    public int fillMainTank(int amount) {
        int filledAmount = Math.min(this.capacity - this.fluid.getAmount(), amount);
        this.fluid.setAmount(this.fluid.getAmount() + filledAmount);
        return filledAmount;
    }

    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        if (this.lockdownDuration > 0) {
            int amt = (int)Math.min((float)(this.bufferCapacity - this.fluidInput.getAmount()), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount);
            this.fluidInput.setAmount(this.fluidInput.getAmount() + amt);
        } else {
            this.fluid.setAmount((int)((float)this.fluid.getAmount() + Math.min((float)(this.capacity - this.fluid.getAmount()), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount)));
        }
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setOutputFluid(FluidStack fluid) {
        this.fluidOutput = fluid;
    }

    public void setInputFluid(FluidStack fluid) {
        this.fluidInput = fluid;
    }

    public AltarUpgrade getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(AltarUpgrade upgrade) {
        this.upgrade = upgrade;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }

    public int getCurrentBlood() {
        return this.getFluidAmount();
    }

    public AltarTier getTier() {
        return this.altarTier;
    }

    public void setTier(AltarTier tier) {
        this.altarTier = tier;
    }

    public int getProgress() {
        return this.progress;
    }

    public float getSacrificeMultiplier() {
        return this.sacrificeEfficiencyMultiplier;
    }

    public float getSelfSacrificeMultiplier() {
        return this.selfSacrificeEfficiencyMultiplier;
    }

    public float getOrbMultiplier() {
        return this.orbCapacityMultiplier;
    }

    public float getDislocationMultiplier() {
        return this.dislocationMultiplier;
    }

    public float getConsumptionMultiplier() {
        return this.consumptionMultiplier;
    }

    public float getConsumptionRate() {
        return this.consumptionRate;
    }

    public int getLiquidRequired() {
        return this.liquidRequired;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public boolean setCurrentTierDisplayed(AltarTier altarTier) {
        if (this.currentTierDisplayed == altarTier) {
            return false;
        }
        this.currentTierDisplayed = altarTier;
        return true;
    }

    public void addToDemonBloodDuration(int dur) {
        this.demonBloodDuration += dur;
    }

    public boolean hasDemonBlood() {
        return this.demonBloodDuration > 0;
    }

    public void decrementDemonBlood() {
        this.demonBloodDuration = Math.max(0, this.demonBloodDuration - 1);
    }

    public void setActive() {
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void requestPauseAfterCrafting(int amount) {
        if (this.isActive) {
            this.cooldownAfterCrafting = amount;
        }
    }

    public int getChargingRate() {
        return this.chargingRate;
    }

    public int getTotalCharge() {
        return this.totalCharge;
    }

    public int getChargingFrequency() {
        return this.chargingFrequency == 0 ? 1 : this.chargingFrequency;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != BloodMagicFluids.LIFE_ESSENCE_FLUID.get()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidInput == null || this.fluidInput.isEmpty()) {
                return Math.min(this.bufferCapacity, resource.getAmount());
            }
            if (!this.fluidInput.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.bufferCapacity - this.fluidInput.getAmount(), resource.getAmount());
        }
        if (this.fluidInput == null || this.fluidInput.isEmpty()) {
            this.fluidInput = new FluidStack(resource, Math.min(this.bufferCapacity, resource.getAmount()));
            return this.fluidInput.getAmount();
        }
        if (!this.fluidInput.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.bufferCapacity - this.fluidInput.getAmount();
        if (resource.getAmount() < filled) {
            this.fluidInput.setAmount(this.fluidInput.getAmount() + resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluidInput.setAmount(this.bufferCapacity);
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.fluidOutput)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidOutput == null) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluidOutput.getAmount() < drained) {
            drained = this.fluidOutput.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluidOutput, drained);
        if (doDrain) {
            this.fluidOutput.setAmount(this.fluidOutput.getAmount() - drained);
        }
        return stack;
    }

    public AltarTier getCurrentTierDisplayed() {
        return this.currentTierDisplayed;
    }

    public int getAnalogSignalStrength(int redstoneMode) {
        switch (redstoneMode) {
            case 0: {
                return this.getCurrentBlood() * 15 / this.getCapacity();
            }
            case 1: {
                ItemStack contained = this.tileAltar.m_8020_(0);
                if (contained.m_41619_() || !(contained.m_41720_() instanceof IBloodOrb) || !(contained.m_41720_() instanceof IBindable)) {
                    return 0;
                }
                BloodOrb orb = ((IBloodOrb)contained.m_41720_()).getOrb(contained);
                Binding binding = ((IBindable)contained.m_41720_()).getBinding(contained);
                if (binding == null || orb == null) {
                    return 0;
                }
                return NetworkHelper.getSoulNetwork(binding).getCurrentEssence() * 15 / orb.getCapacity();
            }
        }
        return 0;
    }

    public static class VariableSizeFluidHandler
    implements IFluidHandler {
        BloodAltar altar;

        public VariableSizeFluidHandler(BloodAltar altar) {
            this.altar = altar;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.altar.fluid;
        }

        public int getTankCapacity(int tank) {
            return this.altar.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return stack.getFluid() == BloodMagicFluids.LIFE_ESSENCE_FLUID.get();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.altar.fill(resource, action == IFluidHandler.FluidAction.EXECUTE);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.altar.drain(resource, action == IFluidHandler.FluidAction.EXECUTE);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.altar.drain(maxDrain, action == IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

