/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.workarounds.context_creation;

import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.util.workarounds.PostLaunchChecks;
import me.jellysquid.mods.sodium.client.util.workarounds.Workarounds;
import me.jellysquid.mods.sodium.client.util.workarounds.driver.nvidia.NvidiaWorkarounds;
import me.jellysquid.mods.sodium.client.util.workarounds.platform.windows.WindowsModuleChecks;
import net.minecraft.Util;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.WGL;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Window.class})
public class WindowMixin {
    @Shadow
    @Final
    private static Logger f_85345_;
    @Unique
    private long wglPrevContext = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/loading/ImmediateWindowHandler;setupMinecraftWindow(Ljava/util/function/IntSupplier;Ljava/util/function/IntSupplier;Ljava/util/function/Supplier;Ljava/util/function/LongSupplier;)J"))
    private long wrapGlfwCreateWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
        if (Workarounds.isWorkaroundEnabled(Workarounds.Reference.NVIDIA_THREADED_OPTIMIZATIONS)) {
            NvidiaWorkarounds.install();
        }
        if (SodiumClientMod.options().performance.useNoErrorGLContext && !Workarounds.isWorkaroundEnabled(Workarounds.Reference.NO_ERROR_CONTEXT_UNSUPPORTED)) {
            GLFW.glfwWindowHint((int)139274, (int)1);
        }
        try {
            long l = ImmediateWindowHandler.setupMinecraftWindow((IntSupplier)width, (IntSupplier)height, title, (LongSupplier)monitor);
            return l;
        }
        finally {
            if (Workarounds.isWorkaroundEnabled(Workarounds.Reference.NVIDIA_THREADED_OPTIMIZATIONS)) {
                NvidiaWorkarounds.uninstall();
            }
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postWindowCreated(WindowEventHandler eventHandler, ScreenManager monitorTracker, DisplayData settings, String videoMode, String title, CallbackInfo ci) {
        this.wglPrevContext = Util.m_137581_() == Util.OS.WINDOWS ? WGL.wglGetCurrentContext() : 0L;
        PostLaunchChecks.checkContext();
    }

    @Inject(method={"swapBuffers"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;flipFrame(J)V", shift=At.Shift.AFTER)})
    private void preSwapBuffers(CallbackInfo ci) {
        if (this.wglPrevContext == 0L) {
            return;
        }
        long context = WGL.wglGetCurrentContext();
        if (this.wglPrevContext == context) {
            return;
        }
        f_85345_.warn("The OpenGL context appears to have been suddenly replaced! Something has likely just injected into the game process.");
        WindowsModuleChecks.checkModules();
        this.wglPrevContext = context;
    }
}

