/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.model.ModelCuboidAccessor;
import me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid;
import me.jellysquid.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public class ModelPartMixin {
    @Shadow
    public float f_104200_;
    @Shadow
    public float f_104201_;
    @Shadow
    public float f_104202_;
    @Shadow
    public float f_104204_;
    @Shadow
    public float f_104203_;
    @Shadow
    public float f_104205_;
    @Shadow
    public float f_233553_;
    @Shadow
    public float f_233554_;
    @Shadow
    public float f_233555_;
    @Unique
    private ModelCuboid[] sodium$cuboids;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children, CallbackInfo ci) {
        ModelCuboid[] copies = new ModelCuboid[cuboids.size()];
        for (int i = 0; i < cuboids.size(); ++i) {
            ModelCuboidAccessor accessor = (ModelCuboidAccessor)cuboids.get(i);
            copies[i] = accessor.sodium$copy();
        }
        this.sodium$cuboids = copies;
    }

    @Inject(method={"renderCuboids"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderCuboidsFast(PoseStack.Pose matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        int color = ColorABGR.pack(red, green, blue, alpha);
        for (ModelCuboid cuboid : this.sodium$cuboids) {
            cuboid.updateVertices(matrices.m_252922_());
            try (MemoryStack stack = MemoryStack.stackPush();){
                long buffer;
                long ptr = buffer = stack.nmalloc(864);
                int count = 0;
                for (ModelCuboid.Quad quad : cuboid.quads) {
                    if (quad == null) continue;
                    int normal = quad.getNormal(matrices.m_252943_());
                    for (int i = 0; i < 4; ++i) {
                        Vector3f pos = quad.positions[i];
                        Vector2f tex = quad.textures[i];
                        ModelVertex.write(ptr, pos.x, pos.y, pos.z, color, tex.x, tex.y, overlay, light, normal);
                        ptr += 36L;
                    }
                    count += 4;
                }
                writer.push(stack, buffer, count, ModelVertex.FORMAT);
            }
        }
    }

    @Overwrite
    public void m_104299_(PoseStack matrices) {
        matrices.m_252880_(this.f_104200_ * 0.0625f, this.f_104201_ * 0.0625f, this.f_104202_ * 0.0625f);
        if (this.f_104203_ != 0.0f || this.f_104204_ != 0.0f || this.f_104205_ != 0.0f) {
            MatrixHelper.rotateZYX(matrices.m_85850_(), this.f_104205_, this.f_104204_, this.f_104203_);
        }
        if (this.f_233553_ != 1.0f || this.f_233554_ != 1.0f || this.f_233555_ != 1.0f) {
            matrices.m_85841_(this.f_233553_, this.f_233554_, this.f_233555_);
        }
    }
}

