/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.util.color.BoxBlur;
import me.jellysquid.mods.sodium.client.world.biome.BiomeSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;

public class ColorResolverCache {
    private static final int BORDER = 1;
    private final Biome[][] biomes;
    private final Map<ColorResolver, int[][]> colors;
    private final BiomeSlice biomeData;
    private final int sizeHorizontal;
    private final int sizeVertical;
    private final int blurHorizontal;
    private int baseX;
    private int baseY;
    private int baseZ;
    private final int[] tmpColorData;
    private final int radius;
    private boolean dirty = false;

    public ColorResolverCache(BiomeSlice biomeData, int radius) {
        this.biomeData = biomeData;
        this.radius = radius;
        int borderXZ = radius + 1;
        int borderY = 1;
        this.sizeHorizontal = 16 + borderXZ * 2;
        this.sizeVertical = 16 + borderY * 2;
        this.blurHorizontal = radius;
        this.tmpColorData = new int[this.sizeHorizontal * this.sizeHorizontal];
        this.colors = new Reference2ReferenceOpenHashMap();
        this.biomes = new Biome[this.sizeVertical][];
    }

    public void update(ChunkRenderContext context) {
        SectionPos pos = context.getOrigin();
        int borderXZ = this.radius + 1;
        int borderY = 1;
        this.baseX = pos.m_123229_() - borderXZ;
        this.baseY = pos.m_123234_() - borderY;
        this.baseZ = pos.m_123239_() - borderXZ;
        if (this.dirty) {
            this.colors.clear();
            for (int i = 0; i < this.sizeVertical; ++i) {
                this.biomes[i] = null;
            }
            this.dirty = false;
        }
    }

    public int getColor(ColorResolver resolver, int posX, int posY, int posZ) {
        int[] layer;
        int x = Mth.m_14045_((int)(posX - this.baseX), (int)0, (int)this.sizeHorizontal);
        int y = Mth.m_14045_((int)(posY - this.baseY), (int)0, (int)this.sizeVertical);
        int z = Mth.m_14045_((int)(posZ - this.baseZ), (int)0, (int)this.sizeHorizontal);
        Object colors = this.colors.get(resolver);
        if (colors == null) {
            this.dirty = true;
            int[][] nArrayArray = new int[this.sizeVertical][];
            colors = nArrayArray;
            this.colors.put(resolver, nArrayArray);
        }
        if ((layer = colors[y]) == null) {
            this.dirty = true;
            layer = this.gatherColorsXZ(resolver, y);
            colors[y] = layer;
        }
        return layer[this.indexXZ(x, z)];
    }

    private Biome[] gatherBiomes(int level) {
        BiomeSlice biomeAccess = this.biomeData;
        Biome[] biomeData = new Biome[this.sizeHorizontal * this.sizeHorizontal];
        for (int x = 0; x < this.sizeHorizontal; ++x) {
            for (int z = 0; z < this.sizeHorizontal; ++z) {
                biomeData[this.indexXZ((int)x, (int)z)] = (Biome)biomeAccess.getBiome(x + this.baseX, level + this.baseY, z + this.baseZ).m_203334_();
            }
        }
        return biomeData;
    }

    private int[] gatherColorsXZ(ColorResolver resolver, int y) {
        Biome[] biomeData = this.getBiomeData(y);
        int[] colorData = new int[this.sizeHorizontal * this.sizeHorizontal];
        for (int x = 0; x < this.sizeHorizontal; ++x) {
            for (int z = 0; z < this.sizeHorizontal; ++z) {
                int index = this.indexXZ(x, z);
                colorData[index] = resolver.m_130045_(biomeData[index], (double)(x + this.baseX), (double)(z + this.baseZ));
            }
        }
        BoxBlur.blur(colorData, this.tmpColorData, this.sizeHorizontal, this.sizeHorizontal, this.blurHorizontal);
        return colorData;
    }

    private Biome[] getBiomeData(int y) {
        Biome[] biomes = this.biomes[y];
        if (biomes == null) {
            biomes = this.gatherBiomes(y);
            this.biomes[y] = biomes;
        }
        return biomes;
    }

    private int indexXZ(int x, int z) {
        return x * this.sizeHorizontal + z;
    }
}

