/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import me.jellysquid.mods.sodium.client.util.workarounds.probe.GraphicsAdapterInfo;
import me.jellysquid.mods.sodium.client.util.workarounds.probe.GraphicsAdapterProbe;
import me.jellysquid.mods.sodium.client.util.workarounds.probe.GraphicsAdapterVendor;
import net.minecraft.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workarounds {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Embeddium-Workarounds");
    private static final AtomicReference<Set<Reference>> ACTIVE_WORKAROUNDS = new AtomicReference<EnumSet<Reference>>(EnumSet.noneOf(Reference.class));

    public static void init() {
        Set<Reference> workarounds = Workarounds.findNecessaryWorkarounds();
        if (!workarounds.isEmpty()) {
            LOGGER.warn("Sodium has applied one or more workarounds to prevent crashes or other issues on your system: [{}]", (Object)workarounds.stream().map(Enum::name).collect(Collectors.joining(", ")));
            LOGGER.warn("This is not necessarily an issue, but it may result in certain features or optimizations being disabled. You can sometimes fix these issues by upgrading your graphics driver.");
        }
        ACTIVE_WORKAROUNDS.set(workarounds);
    }

    private static Set<Reference> findNecessaryWorkarounds() {
        EnumSet<Reference> workarounds = EnumSet.noneOf(Reference.class);
        Util.OS operatingSystem = Util.m_137581_();
        Collection<GraphicsAdapterInfo> graphicsAdapters = GraphicsAdapterProbe.getAdapters();
        if ((operatingSystem == Util.OS.WINDOWS || operatingSystem == Util.OS.LINUX) && graphicsAdapters.stream().anyMatch(adapter -> adapter.vendor() == GraphicsAdapterVendor.NVIDIA)) {
            workarounds.add(Reference.NVIDIA_THREADED_OPTIMIZATIONS);
        }
        if (operatingSystem == Util.OS.LINUX) {
            String session = System.getenv("XDG_SESSION_TYPE");
            if (session == null) {
                LOGGER.warn("Unable to determine desktop session type because the environment variable XDG_SESSION_TYPE is not set! Your user session may not be configured correctly.");
            }
            if (Objects.equals(session, "wayland")) {
                workarounds.add(Reference.NO_ERROR_CONTEXT_UNSUPPORTED);
            }
        }
        return Collections.unmodifiableSet(workarounds);
    }

    public static boolean isWorkaroundEnabled(Reference id) {
        return ACTIVE_WORKAROUNDS.get().contains((Object)id);
    }

    public static Set<Reference> getEnabledWorkarounds() {
        return ACTIVE_WORKAROUNDS.get();
    }

    public static enum Reference {
        NVIDIA_THREADED_OPTIMIZATIONS,
        NO_ERROR_CONTEXT_UNSUPPORTED;

    }
}

