/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.compat.jei.AnimatedDieselEngineElement;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineJeiRecipeType;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class DieselEngineCategory
implements IRecipeCategory<DieselEngineJeiRecipeType> {
    IGuiHelper guiHelper;
    AnimatedDieselEngineElement engine = new AnimatedDieselEngineElement();

    public DieselEngineCategory(IGuiHelper helper) {
        this.guiHelper = helper;
    }

    public RecipeType<DieselEngineJeiRecipeType> getRecipeType() {
        return DieselEngineJeiRecipeType.DIESEL_COMBUSTION;
    }

    public Component getTitle() {
        return Components.translatable((String)"createdieselgenerators.recipe.diesel_combustion");
    }

    public IDrawable getBackground() {
        return new EmptyBackground(177, 70);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)BlockRegistry.DIESEL_ENGINE.asStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DieselEngineJeiRecipeType recipe, IFocusGroup iFocusGroup) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 10).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)CreateRecipeCategory.withImprovedVisibility((FluidStack)new FluidStack(recipe.fluid, 1000)))).addTooltipCallback(CreateRecipeCategory.addFluidTooltip((int)recipe.burnRate));
    }

    public void draw(DieselEngineJeiRecipeType recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 40, 15);
        AllGuiTextures.JEI_ARROW.render(graphics, 82, 40);
        AllGuiTextures.JEI_SHADOW.render(graphics, 28, 52);
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Lang.number((double)recipe.burnRate).component().m_7220_((Component)Component.m_237115_((String)"createdieselgenerators.generic.unit.mbps")), 5, 40, 0x888888);
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Lang.number((double)(recipe.stress / recipe.speed)).component().m_130946_("x").m_7220_((Component)Component.m_237115_((String)"create.generic.unit.rpm")), 125, 41, 0x888888);
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Lang.number((double)recipe.speed).component().m_7220_((Component)Component.m_237115_((String)"create.generic.unit.rpm")), 85, 33, 0x888888);
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Lang.number((double)recipe.stress).component().m_7220_((Component)Component.m_237115_((String)"create.generic.unit.stress")), 81, 50, 0x888888);
        this.engine.draw(graphics, 47, 62);
    }
}

