/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.blocks.entity.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PoweredEngineShaftBlockEntity;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HugeDieselEngineRenderer
extends SafeBlockEntityRenderer<HugeDieselEngineBlockEntity> {
    public HugeDieselEngineRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(HugeDieselEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        float shaftR;
        boolean roll90;
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        Float angle = be.getTargetAngle();
        VertexConsumer vb = bufferSource.m_6299_(RenderType.m_110451_());
        BlockState state = be.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING);
        Direction.Axis facingAxis = facing.m_122434_();
        if (angle == null) {
            this.transformed(PartialModels.ENGINE_PISTON, state, facing, false).translate(0.0, 0.53475, 0.0).light(light).renderInto(ms, vb);
            return;
        }
        PoweredEngineShaftBlockEntity shaft = be.getShaft();
        if (shaft == null) {
            this.transformed(PartialModels.ENGINE_PISTON, state, facing, false).translate(0.0, 0.53475, 0.0).light(light).renderInto(ms, vb);
            return;
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        boolean bl = roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float f = facing == Direction.DOWN ? -90.0f : (facing == Direction.UP ? 90.0f : (facing == Direction.WEST ? -90.0f : (shaftR = facing == Direction.EAST ? 90.0f : 0.0f)));
        if (roll90) {
            shaftR = facing == Direction.NORTH ? 180.0f : (facing == Direction.SOUTH ? 0.0f : (facing == Direction.EAST ? -90.0f : (facing == Direction.WEST ? 90.0f : 0.0f)));
        }
        angle = Float.valueOf(angle.floatValue() + (float)((double)shaftR * Math.PI / 180.0));
        float sine = Mth.m_14031_((float)angle.floatValue()) * (float)(((Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_() == Direction.Axis.Y ? -1 : 1);
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f)) * (float)(((Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_() == Direction.Axis.Y ? -1 : 1);
        float piston = (1.0f - sine) / 4.0f + 0.4375f;
        this.transformed(PartialModels.ENGINE_PISTON, state, facing, roll90).translate(0.0, (double)piston, 0.0).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(PartialModels.ENGINE_PISTON_LINKAGE, state, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, (double)piston, 0.0).translate(0.0, 0.25, 0.5).rotateX((double)(sine2 * 23.0f))).translate(0.0, -0.25, -0.5).light(light).renderInto(ms, vb);
        if (shaft.isEngineForConnectorDisplay(be.m_58899_())) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(PartialModels.ENGINE_PISTON_CONNECTOR, state, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians((double)(-angle.floatValue() + 1.5707964f))).unCentre()).light(light).renderInto(ms, vb);
        }
    }

    private SuperByteBuffer transformed(PartialModel model, BlockState blockState, Direction facing, boolean roll90) {
        return (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)model, (BlockState)blockState).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX((double)(AngleHelper.verticalAngle((Direction)facing) + 90.0f))).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public int m_142163_() {
        return 128;
    }
}

