/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.LargeDieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.LargeDieselGeneratorValueBox;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jesz.createdieselgenerators.sounds.SoundRegistry;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LargeDieselGeneratorBlockEntity
extends GeneratingKineticBlockEntity {
    BlockState state;
    public boolean validFuel;
    public int stacked;
    public boolean powered = false;
    boolean end = true;
    public WeakReference<LargeDieselGeneratorBlockEntity> forw = new WeakReference<Object>(null);
    public WeakReference<LargeDieselGeneratorBlockEntity> back = new WeakReference<Object>(null);
    public SmartFluidTankBehaviour tank;
    int partialSecond;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public AbstractComputerBehaviour computerBehaviour;
    public LargeDieselGeneratorBlockEntity FrontEngine;
    int t = 0;
    int totalSize = 0;

    public LargeDieselGeneratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.state = state;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        if (((Boolean)this.state.m_61143_((Property)LargeDieselGeneratorBlock.PIPE)).booleanValue() && cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.UP) {
            if (this.FrontEngine != null) {
                return this.FrontEngine.tank.getCapability().cast();
            }
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("PartialSecond", this.partialSecond);
        this.tank.write(compound, false);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.partialSecond = compound.m_128451_("PartialSecond");
        this.tank.read(compound, false);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new LargeDieselGeneratorValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged(true));
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged(boolean first) {
        if (first && this.getEngineFor() != null) {
            this.FrontEngine.movementDirection.setValue(this.movementDirection.getValue());
            this.FrontEngine.onDirectionChanged(false);
            return;
        }
        this.movementDirection.setValue(this.FrontEngine.movementDirection.getValue());
        if (this.getEngineBack() != null) {
            this.getEngineBack().onDirectionChanged(false);
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float calculateAddedStressCapacity() {
        if (this.getGeneratedSpeed() == 0.0f || !this.end) {
            return 0.0f;
        }
        return FuelTypeManager.getGeneratedStress((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) / Math.abs(this.getGeneratedSpeed()) * (float)this.stacked;
    }

    public float getGeneratedSpeed() {
        if (!this.end) {
            return 0.0f;
        }
        return LargeDieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * FuelTypeManager.getGeneratedSpeed((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid())), (Direction)((Direction)this.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.FACING)));
    }

    public void UpdateStacked() {
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        if (engineBack == null) {
            this.totalSize = 1;
            this.stacked = 1;
        } else {
            this.stacked = engineBack.stacked + 1;
        }
        if (engineForward == null) {
            this.totalSize = this.stacked;
            this.SetEveryEnginesFront();
        } else {
            engineForward.UpdateStacked();
        }
    }

    public void SetEveryEnginesFront() {
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        if (engineForward == null) {
            this.FrontEngine = this;
        } else {
            this.FrontEngine = engineForward.FrontEngine;
            this.totalSize = engineForward.totalSize;
        }
        if (engineBack != null) {
            engineBack.SetEveryEnginesFront();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled() || this.FrontEngine == null) {
            return added;
        }
        float stressBase = this.FrontEngine.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return added;
        }
        if (this.FrontEngine != this) {
            Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float stressTotal = Math.abs(this.FrontEngine.getGeneratedSpeed() * stressBase);
            Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        if (this.FrontEngine != null) {
            return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.FrontEngine.tank.getCapability().cast());
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
    }

    public void tick() {
        super.tick();
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        this.state = this.m_58900_();
        this.end = engineForward == null;
        this.updateGeneratedRotation();
        if (this.reActivateSource) {
            this.reActivateSource = false;
        }
        if (engineBack == null) {
            this.UpdateStacked();
        }
        if (!this.tank.isEmpty() && engineForward != null && this.FrontEngine != null) {
            this.FrontEngine.tank.getPrimaryHandler().fill(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.tank.getPrimaryHandler().drain(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE);
        }
        boolean bl = this.validFuel = FuelTypeManager.getGeneratedSpeed((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) != 0.0f;
        if (this.FrontEngine != null && this.t > FuelTypeManager.getSoundSpeed(this.FrontEngine.tank.getPrimaryHandler().getFluid().getFluid()) && this.FrontEngine.validFuel && !((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.SILENCED)).booleanValue() && (this.stacked % 6 == 0 || this.end)) {
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (SoundEvent)SoundRegistry.DIESEL_ENGINE_SOUND.get(), SoundSource.BLOCKS, 3.0f, 1.08f, false);
            this.t = 0;
        } else {
            ++this.t;
        }
        ++this.partialSecond;
        if (this.partialSecond >= 20) {
            this.partialSecond = 0;
            if (this.validFuel) {
                if (this.tank.getPrimaryHandler().getFluid().getAmount() >= FuelTypeManager.getBurnRate((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * this.stacked) {
                    this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (int)(this.tank.getPrimaryHandler().getFluid().getAmount() - FuelTypeManager.getBurnRate((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * this.stacked)));
                } else {
                    this.tank.getPrimaryHandler().setFluid(FluidStack.EMPTY);
                }
            }
        }
    }

    private void changeBlockState(BlockState state) {
        KineticBlockEntity.switchToBlockState((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (BlockState)state);
    }

    private LargeDieselGeneratorBlockEntity getEngineFor() {
        LargeDieselGeneratorBlockEntity engine = (LargeDieselGeneratorBlockEntity)((Object)this.forw.get());
        if (engine == null || engine.m_58901_() || engine.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING) == this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)) {
            Direction facing;
            BlockEntity be;
            if (engine != null) {
                this.forw = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_((facing = (Direction)this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() == Direction.Axis.Z ? Direction.SOUTH : Direction.EAST))) instanceof LargeDieselGeneratorBlockEntity) {
                LargeDieselGeneratorBlockEntity engineBE;
                engine = engineBE = (LargeDieselGeneratorBlockEntity)be;
                this.forw = new WeakReference<LargeDieselGeneratorBlockEntity>(engine);
            }
        }
        if (engine != null && ((Direction)engine.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() != ((Direction)this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_()) {
            this.forw = new WeakReference<Object>(null);
            return null;
        }
        return engine;
    }

    private LargeDieselGeneratorBlockEntity getEngineBack() {
        LargeDieselGeneratorBlockEntity engine = (LargeDieselGeneratorBlockEntity)((Object)this.back.get());
        if (engine == null || engine.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (engine != null) {
                this.back = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_((facing = (Direction)this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() == Direction.Axis.Z ? Direction.NORTH : Direction.WEST))) instanceof LargeDieselGeneratorBlockEntity) {
                LargeDieselGeneratorBlockEntity engineBE;
                engine = engineBE = (LargeDieselGeneratorBlockEntity)be;
                this.back = new WeakReference<LargeDieselGeneratorBlockEntity>(engine);
            }
        }
        if (engine != null && ((Direction)engine.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() != ((Direction)this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_()) {
            this.back = new WeakReference<Object>(null);
            return null;
        }
        return engine;
    }
}

