/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.Collections;
import java.util.HashSet;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeWrapper;

public class TankUpgradeItem
extends UpgradeItemBase<TankUpgradeWrapper> {
    public static final UpgradeType<TankUpgradeWrapper> TYPE = new UpgradeType<TankUpgradeWrapper>(TankUpgradeWrapper::new);
    private final TankUpgradeConfig tankUpgradeConfig;

    public TankUpgradeItem(TankUpgradeConfig tankUpgradeConfig) {
        this.tankUpgradeConfig = tankUpgradeConfig;
    }

    public int getBaseCapacity(IStorageWrapper storageWrapper) {
        return (Integer)this.tankUpgradeConfig.capacityPerSlotRow.get() * storageWrapper.getNumberOfSlotRows();
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.tankUpgradeConfig.stackMultiplierRatio.get() * (double)(storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1));
    }

    public int getTankCapacity(IStorageWrapper storageWrapper) {
        int baseCapacity;
        int stackMultiplier = this.getAdjustedStackMultiplier(storageWrapper);
        return Integer.MAX_VALUE / stackMultiplier < (baseCapacity = this.getBaseCapacity(storageWrapper)) ? Integer.MAX_VALUE : baseCapacity * stackMultiplier;
    }

    public TankUpgradeConfig getTankUpgradeConfig() {
        return this.tankUpgradeConfig;
    }

    @Override
    public UpgradeType<TankUpgradeWrapper> getType() {
        return TYPE;
    }

    @Override
    public UpgradeSlotChangeResult canAddUpgradeTo(IStorageWrapper storageWrapper, ItemStack upgradeStack, boolean firstLevelStorage, boolean isClientSide) {
        HashSet<Integer> errorUpgradeSlots = new HashSet<Integer>();
        storageWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof TankUpgradeWrapper) {
                errorUpgradeSlots.add((Integer)slot);
            }
        });
        if (errorUpgradeSlots.size() >= 2) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.two_tank_upgrades_present", new Object[0]), errorUpgradeSlots, Collections.emptySet(), Collections.emptySet());
        }
        int multiplierRequired = (int)Math.ceil((float)TankUpgradeWrapper.getContents(upgradeStack).getAmount() / (float)this.getTankCapacity(storageWrapper));
        if (multiplierRequired > 1) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.tank_capacity_high", multiplierRequired), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    @Override
    public int getInventoryColumnsTaken() {
        return 2;
    }
}

