/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.HashSet;
import java.util.Set;
import java.util.function.LongSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import org.jetbrains.annotations.NotNull;

public class CachedFailedInsertInventoryHandler
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable wrapped;
    private final LongSupplier timeSupplier;
    private long currentCacheTime = 0L;
    private final Set<Integer> failedInsertStackHashes = new HashSet<Integer>();

    public CachedFailedInsertInventoryHandler(IItemHandlerModifiable wrapped, LongSupplier timeSupplier) {
        this.wrapped = wrapped;
        this.timeSupplier = timeSupplier;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.wrapped.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.wrapped.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.wrapped.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack result;
        if (this.currentCacheTime != this.timeSupplier.getAsLong()) {
            this.failedInsertStackHashes.clear();
            this.currentCacheTime = this.timeSupplier.getAsLong();
        }
        boolean hashCalculated = false;
        int stackHash = 0;
        if (!this.failedInsertStackHashes.isEmpty()) {
            stackHash = ItemStackKey.getHashCode(stack);
            hashCalculated = true;
            if (this.failedInsertStackHashes.contains(stackHash)) {
                return stack;
            }
        }
        if ((result = this.wrapped.insertItem(slot, stack, simulate)) == stack) {
            if (!hashCalculated) {
                stackHash = ItemStackKey.getHashCode(stack);
            }
            this.failedInsertStackHashes.add(stackHash);
        }
        return result;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.wrapped.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.wrapped.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.wrapped.isItemValid(slot, stack);
    }
}

