/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import io.netty.buffer.ByteBuf;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class PacketSettingsProfile {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_settings_profile");
    private final SettingsProfile profile;

    public PacketSettingsProfile() {
        this.profile = new SettingsProfile();
    }

    public PacketSettingsProfile(SettingsProfile profile) {
        this.profile = profile;
    }

    public static PacketSettingsProfile decode(FriendlyByteBuf buf) {
        PacketSettingsProfile packet = new PacketSettingsProfile();
        packet.profile.fromBytes((ByteBuf)buf);
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        this.profile.toBytes((ByteBuf)buf);
    }

    public static void handle(PacketContext<PacketSettingsProfile> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketSettingsProfile message = (PacketSettingsProfile)ctx.message();
            SettingsProfile currentProfile = MapFrontiersClient.getSettingsProfile();
            if (currentProfile == null || !currentProfile.equals(message.profile)) {
                ClientEventHandler.postUpdatedSettingsProfileEvent(message.profile);
            }
        }
    }
}

