/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class PacketFrontierDeleted {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_frontier_deleted");
    private ResourceKey<Level> dimension = Level.f_46428_;
    private UUID frontierID;
    private boolean personal;
    private int playerID = -1;

    public PacketFrontierDeleted() {
    }

    public PacketFrontierDeleted(ResourceKey<Level> dimension, UUID frontierID, boolean personal, int playerID) {
        this.dimension = dimension;
        this.frontierID = frontierID;
        this.personal = personal;
        this.playerID = playerID;
    }

    public static PacketFrontierDeleted decode(FriendlyByteBuf buf) {
        PacketFrontierDeleted packet = new PacketFrontierDeleted();
        packet.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        packet.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
        packet.personal = buf.readBoolean();
        packet.playerID = buf.readInt();
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
        buf.writeBoolean(this.personal);
        buf.writeInt(this.playerID);
    }

    public static void handle(PacketContext<PacketFrontierDeleted> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketFrontierDeleted message = (PacketFrontierDeleted)ctx.message();
            boolean deleted = MapFrontiersClient.getFrontiersOverlayManager(message.personal).deleteFrontier(message.dimension, message.frontierID);
            if (deleted) {
                ClientEventHandler.postDeletedFrontierEvent(message.frontierID);
            }
        }
    }
}

