/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierDeleted;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class PacketDeleteFrontier {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_delete_frontier");
    private final UUID frontierID;

    public PacketDeleteFrontier(UUID frontierID) {
        this.frontierID = frontierID;
    }

    public static PacketDeleteFrontier decode(FriendlyByteBuf buf) {
        return new PacketDeleteFrontier(UUIDHelper.fromBytes((ByteBuf)buf));
    }

    public void encode(FriendlyByteBuf buf) {
        UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
    }

    public static void handle(PacketContext<PacketDeleteFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketDeleteFrontier message = (PacketDeleteFrontier)ctx.message();
            ServerPlayer player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.f_8924_;
            SettingsUser playerUser = new SettingsUser((Player)player);
            FrontierData frontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (frontier != null) {
                if (frontier.getPersonal()) {
                    if (frontier.getOwner().equals(playerUser)) {
                        boolean deleted = FrontiersManager.instance.deletePersonalFrontier(frontier.getOwner(), frontier.getDimension(), frontier.getId());
                        if (deleted) {
                            if (frontier.getUsersShared() != null) {
                                for (SettingsUserShared userShared : frontier.getUsersShared()) {
                                    FrontiersManager.instance.deletePersonalFrontier(userShared.getUser(), frontier.getDimension(), frontier.getId());
                                }
                            }
                            PacketHandler.sendToUsersWithAccess(new PacketFrontierDeleted(frontier.getDimension(), frontier.getId(), frontier.getPersonal(), player.m_19879_()), frontier, server);
                        }
                    } else {
                        frontier.removeUserShared(playerUser);
                        FrontiersManager.instance.deletePersonalFrontier(playerUser, frontier.getDimension(), frontier.getId());
                        PacketHandler.sendTo(new PacketFrontierDeleted(frontier.getDimension(), frontier.getId(), frontier.getPersonal(), player.m_19879_()), player);
                        PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(frontier, player.m_19879_()), frontier, server);
                        frontier.removeChange(FrontierData.Change.Shared);
                    }
                    return;
                }
                if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.DeleteGlobalFrontier, playerUser, MapFrontiers.isOPorHost(player), frontier.getOwner())) {
                    boolean deleted = FrontiersManager.instance.deleteGlobalFrontier(frontier.getDimension(), frontier.getId());
                    if (deleted) {
                        PacketHandler.sendToAll(new PacketFrontierDeleted(frontier.getDimension(), frontier.getId(), frontier.getPersonal(), player.m_19879_()), server);
                    }
                    return;
                }
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        }
    }
}

