/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class FrontierData {
    protected UUID id;
    protected final List<BlockPos> vertices = new ArrayList<BlockPos>();
    protected final Set<ChunkPos> chunks = new HashSet<ChunkPos>();
    protected Mode mode = Mode.Vertex;
    protected String name1 = "New";
    protected String name2 = "Frontier";
    protected boolean visible = true;
    protected boolean fullscreenVisible = true;
    protected boolean fullscreenNameVisible = true;
    protected boolean fullscreenOwnerVisible = false;
    protected boolean minimapVisible = true;
    protected boolean minimapNameVisible = true;
    protected boolean minimapOwnerVisible = false;
    protected boolean announceInChat = false;
    protected boolean announceInTitle = false;
    protected int color = -1;
    protected ResourceKey<Level> dimension;
    protected SettingsUser owner = new SettingsUser();
    protected BannerData banner;
    protected boolean personal = false;
    protected List<SettingsUserShared> usersShared;
    protected Date created;
    protected Date modified;
    protected Set<Change> changes = EnumSet.noneOf(Change.class);

    public FrontierData() {
        this.id = new UUID(0L, 0L);
    }

    public FrontierData(FrontierData other) {
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        this.visible = other.visible;
        this.fullscreenVisible = other.fullscreenVisible;
        this.fullscreenNameVisible = other.fullscreenNameVisible;
        this.fullscreenOwnerVisible = other.fullscreenOwnerVisible;
        this.minimapVisible = other.minimapVisible;
        this.minimapNameVisible = other.minimapNameVisible;
        this.minimapOwnerVisible = other.minimapOwnerVisible;
        this.announceInChat = other.announceInChat;
        this.announceInTitle = other.announceInTitle;
        this.color = other.color;
        this.name1 = other.name1;
        this.name2 = other.name2;
        this.banner = other.banner;
        this.usersShared = other.usersShared;
        this.vertices.clear();
        this.vertices.addAll(other.vertices);
        this.chunks.clear();
        this.chunks.addAll(other.chunks);
        this.mode = other.mode;
        this.created = other.created;
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void updateFromData(FrontierData other) {
        if (other == this) {
            this.changes = EnumSet.noneOf(Change.class);
            return;
        }
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        if (other.changes.contains((Object)Change.Other)) {
            this.visible = other.visible;
            this.fullscreenVisible = other.fullscreenVisible;
            this.fullscreenNameVisible = other.fullscreenNameVisible;
            this.fullscreenOwnerVisible = other.fullscreenOwnerVisible;
            this.minimapVisible = other.minimapVisible;
            this.minimapNameVisible = other.minimapNameVisible;
            this.minimapOwnerVisible = other.minimapOwnerVisible;
            this.announceInChat = other.announceInChat;
            this.announceInTitle = other.announceInTitle;
            this.color = other.color;
        }
        if (other.changes.contains((Object)Change.Name)) {
            this.name1 = other.name1;
            this.name2 = other.name2;
        }
        if (other.changes.contains((Object)Change.Banner)) {
            this.banner = other.banner;
        }
        if (other.changes.contains((Object)Change.Shared)) {
            this.usersShared = other.usersShared;
        }
        if (other.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            this.vertices.addAll(other.vertices);
            this.chunks.clear();
            this.chunks.addAll(other.chunks);
            this.mode = other.mode;
        }
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void setOwner(SettingsUser owner) {
        this.owner = owner;
    }

    public void ensureOwner(MinecraftServer server) {
        if (this.owner.isEmpty()) {
            List playerList;
            if (!server.m_6982_() && !(playerList = server.m_6846_().m_11314_()).isEmpty()) {
                this.owner = new SettingsUser((Player)playerList.get(0));
            }
        } else {
            this.owner.fillMissingInfo(false, server);
        }
    }

    public SettingsUser getOwner() {
        return this.owner;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVertex(BlockPos pos, int index) {
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.vertices.add(index, pos.m_175288_(70));
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVertex(BlockPos pos) {
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.addVertex(pos, this.vertices.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVertex(int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.vertices.remove(index);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveVertex(BlockPos pos, int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.vertices.set(index, pos);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleChunk(ChunkPos chunk) {
        boolean added = false;
        Set<ChunkPos> set = this.chunks;
        synchronized (set) {
            if (!this.chunks.remove(chunk)) {
                this.chunks.add(chunk);
                added = true;
            }
        }
        this.changes.add(Change.Vertices);
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChunk(ChunkPos chunk) {
        Set<ChunkPos> set = this.chunks;
        synchronized (set) {
            if (this.chunks.add(chunk)) {
                this.changes.add(Change.Vertices);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChunk(ChunkPos chunk) {
        Set<ChunkPos> set = this.chunks;
        synchronized (set) {
            if (this.chunks.remove(chunk)) {
                this.changes.remove((Object)Change.Vertices);
                return true;
            }
        }
        return false;
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.changes.add(Change.Vertices);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setName1(String name) {
        this.name1 = name;
        this.changes.add(Change.Name);
    }

    public String getName1() {
        return this.name1;
    }

    public void setName2(String name) {
        this.name2 = name;
        this.changes.add(Change.Name);
    }

    public String getName2() {
        return this.name2;
    }

    public boolean isNamed() {
        return !StringUtils.isBlank((CharSequence)this.name1) || !StringUtils.isBlank((CharSequence)this.name2);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.changes.add(Change.Other);
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setFullscreenVisible(boolean visible) {
        this.fullscreenVisible = visible;
        this.changes.add(Change.Other);
    }

    public boolean getFullscreenVisible() {
        return this.fullscreenVisible;
    }

    public void setMinimapVisible(boolean visible) {
        this.minimapVisible = visible;
        this.changes.add(Change.Other);
    }

    public boolean getMinimapVisible() {
        return this.minimapVisible;
    }

    public void setFullscreenNameVisible(boolean nameVisible) {
        this.fullscreenNameVisible = nameVisible;
        this.changes.add(Change.Other);
    }

    public boolean getFullscreenNameVisible() {
        return this.fullscreenNameVisible;
    }

    public void setFullscreenOwnerVisible(boolean ownerVisible) {
        this.fullscreenOwnerVisible = ownerVisible;
        this.changes.add(Change.Other);
    }

    public boolean getFullscreenOwnerVisible() {
        return this.fullscreenOwnerVisible;
    }

    public void setMinimapNameVisible(boolean nameVisible) {
        this.minimapNameVisible = nameVisible;
        this.changes.add(Change.Other);
    }

    public boolean getMinimapNameVisible() {
        return this.minimapNameVisible;
    }

    public void setMinimapOwnerVisible(boolean ownerVisible) {
        this.minimapOwnerVisible = ownerVisible;
        this.changes.add(Change.Other);
    }

    public boolean getMinimapOwnerVisible() {
        return this.minimapOwnerVisible;
    }

    public void setAnnounceInChat(boolean announceInChat) {
        this.announceInChat = announceInChat;
        this.changes.add(Change.Other);
    }

    public boolean getAnnounceInChat() {
        return this.announceInChat;
    }

    public void setAnnounceInTitle(boolean announceInTitle) {
        this.announceInTitle = announceInTitle;
        this.changes.add(Change.Other);
    }

    public boolean getAnnounceInTitle() {
        return this.announceInTitle;
    }

    public void setColor(int color) {
        this.color = color;
        this.changes.add(Change.Other);
    }

    public int getColor() {
        return this.color;
    }

    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public void setBanner(@Nullable ItemStack itemBanner) {
        this.changes.add(Change.Banner);
        this.banner = itemBanner == null ? null : new BannerData(itemBanner);
    }

    public boolean hasBanner() {
        return this.banner != null;
    }

    public void setBannerData(@Nullable BannerData bannerData) {
        this.banner = bannerData;
    }

    public BannerData getbannerData() {
        return this.banner;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public boolean getPersonal() {
        return this.personal;
    }

    public void addUserShared(SettingsUserShared userShared) {
        if (this.usersShared == null) {
            this.usersShared = new ArrayList<SettingsUserShared>();
        }
        this.usersShared.add(userShared);
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(int index) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.remove(index);
        if (this.usersShared.isEmpty()) {
            this.usersShared = null;
        }
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(x -> x.getUser().equals(user));
        this.changes.add(Change.Shared);
    }

    public void removeAllUserShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared = null;
        this.changes.add(Change.Shared);
    }

    public void setUsersShared(List<SettingsUserShared> usersShared) {
        this.usersShared = usersShared;
        this.changes.add(Change.Shared);
    }

    public void removePendingUsersShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(SettingsUserShared::isPending);
        this.changes.add(Change.Shared);
    }

    public List<SettingsUserShared> getUsersShared() {
        return this.usersShared;
    }

    public SettingsUserShared getUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return null;
        }
        for (SettingsUserShared u : this.usersShared) {
            if (!u.getUser().equals(user)) continue;
            return u;
        }
        return null;
    }

    public boolean hasUserShared(SettingsUser user) {
        return this.getUserShared(user) != null;
    }

    public boolean checkActionUserShared(SettingsUser user, SettingsUserShared.Action action) {
        if (user.equals(this.owner)) {
            return true;
        }
        if (this.usersShared == null) {
            return false;
        }
        SettingsUserShared userShared = this.getUserShared(user);
        if (userShared == null) {
            return false;
        }
        return userShared.hasAction(action);
    }

    public void setCreated(Date created) {
        this.created = created;
        this.modified = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getModified() {
        return this.modified;
    }

    public void addChange(Change change) {
        this.changes.add(change);
    }

    public void removeChange(Change change) {
        this.changes.remove((Object)change);
    }

    public void removeChanges() {
        this.changes.clear();
    }

    public boolean hasChange(Change change) {
        return this.changes.contains((Object)change);
    }

    public void readFromNBT(CompoundTag nbt, int version) {
        int i;
        ListTag usersSharedTagList;
        boolean splitVisibility = version >= 10;
        this.id = UUID.fromString(nbt.m_128461_("id"));
        this.color = nbt.m_128451_("color");
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
        this.name1 = nbt.m_128461_("name1");
        this.name2 = nbt.m_128461_("name2");
        this.visible = nbt.m_128471_("visible");
        if (splitVisibility) {
            this.fullscreenVisible = nbt.m_128471_("fullscreenVisible");
            this.fullscreenNameVisible = nbt.m_128471_("fullscreenNameVisible");
            this.fullscreenOwnerVisible = nbt.m_128471_("fullscreenOwnerVisible");
            this.minimapVisible = nbt.m_128471_("minimapVisible");
            this.minimapNameVisible = nbt.m_128471_("minimapNameVisible");
            this.minimapOwnerVisible = nbt.m_128471_("minimapOwnerVisible");
        } else {
            this.fullscreenVisible = nbt.m_128471_("visible");
            this.minimapVisible = nbt.m_128471_("visible");
            this.fullscreenNameVisible = nbt.m_128471_("nameVisible");
            this.minimapNameVisible = nbt.m_128471_("nameVisible");
            this.fullscreenOwnerVisible = nbt.m_128471_("ownerVisible");
            this.minimapOwnerVisible = nbt.m_128471_("ownerVisible");
        }
        if (nbt.m_128441_("announceInChat")) {
            this.announceInChat = nbt.m_128471_("announceInChat");
        }
        if (nbt.m_128441_("announceInTitle")) {
            this.announceInTitle = nbt.m_128471_("announceInTitle");
        }
        this.personal = nbt.m_128471_("personal");
        this.owner = new SettingsUser();
        this.owner.readFromNBT(nbt.m_128469_("owner"));
        if (nbt.m_128441_("banner")) {
            this.banner = new BannerData();
            this.banner.readFromNBT(nbt.m_128469_("banner"));
        }
        if (this.personal && !(usersSharedTagList = nbt.m_128437_("usersShared", 10)).isEmpty()) {
            this.usersShared = new ArrayList<SettingsUserShared>();
            for (i = 0; i < usersSharedTagList.size(); ++i) {
                SettingsUserShared userShared = new SettingsUserShared();
                userShared.readFromNBT(usersSharedTagList.m_128728_(i));
                this.usersShared.add(userShared);
            }
        }
        ListTag verticesTagList = nbt.m_128437_("vertices", 10);
        for (i = 0; i < verticesTagList.size(); ++i) {
            this.vertices.add(NbtUtils.m_129239_((CompoundTag)verticesTagList.m_128728_(i)));
        }
        ListTag chunksTagList = nbt.m_128437_("chunks", 10);
        for (int i2 = 0; i2 < chunksTagList.size(); ++i2) {
            this.chunks.add(new ChunkPos(chunksTagList.m_128728_(i2).m_128451_("X"), chunksTagList.m_128728_(i2).m_128451_("Z")));
        }
        String modeTag = nbt.m_128461_("mode");
        if (modeTag.isEmpty()) {
            this.mode = Mode.Vertex;
        } else {
            try {
                this.mode = Mode.valueOf(modeTag);
            }
            catch (IllegalArgumentException e) {
                this.mode = this.chunks.size() > 0 ? Mode.Chunk : Mode.Vertex;
                String availableModes = StringHelper.enumValuesToString(Arrays.asList(Mode.values()));
                MapFrontiers.LOGGER.warn(String.format("Unknown mode in frontier %1$s. Found: \"%2$s\". Expected: %3$s", this.id, modeTag, availableModes));
            }
        }
        if (nbt.m_128441_("created")) {
            this.created = new Date(nbt.m_128454_("created"));
        }
        if (nbt.m_128441_("modified")) {
            this.modified = new Date(nbt.m_128454_("modified"));
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128359_("id", this.id.toString());
        nbt.m_128405_("color", this.color);
        nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
        nbt.m_128359_("name1", this.name1);
        nbt.m_128359_("name2", this.name2);
        nbt.m_128379_("visible", this.visible);
        nbt.m_128379_("fullscreenVisible", this.fullscreenVisible);
        nbt.m_128379_("fullscreenNameVisible", this.fullscreenNameVisible);
        nbt.m_128379_("fullscreenOwnerVisible", this.fullscreenOwnerVisible);
        nbt.m_128379_("minimapVisible", this.minimapVisible);
        nbt.m_128379_("minimapNameVisible", this.minimapNameVisible);
        nbt.m_128379_("minimapOwnerVisible", this.minimapOwnerVisible);
        nbt.m_128379_("announceInChat", this.announceInChat);
        nbt.m_128379_("announceInTitle", this.announceInTitle);
        nbt.m_128379_("personal", this.personal);
        CompoundTag nbtOwner = new CompoundTag();
        this.owner.writeToNBT(nbtOwner);
        nbt.m_128365_("owner", (Tag)nbtOwner);
        if (this.banner != null) {
            CompoundTag nbtBanner = new CompoundTag();
            this.banner.writeToNBT(nbtBanner);
            nbt.m_128365_("banner", (Tag)nbtBanner);
        }
        if (this.personal && this.usersShared != null) {
            ListTag usersSharedTagList = new ListTag();
            for (SettingsUserShared userShared : this.usersShared) {
                CompoundTag nbtUserShared = new CompoundTag();
                userShared.writeToNBT(nbtUserShared);
                usersSharedTagList.add((Object)nbtUserShared);
            }
            nbt.m_128365_("usersShared", (Tag)usersSharedTagList);
        }
        ListTag verticesTagList = new ListTag();
        for (BlockPos pos : this.vertices) {
            verticesTagList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        nbt.m_128365_("vertices", (Tag)verticesTagList);
        ListTag chunksTagList = new ListTag();
        for (ChunkPos pos : this.chunks) {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128405_("X", pos.f_45578_);
            compoundtag.m_128405_("Z", pos.f_45579_);
            chunksTagList.add((Object)compoundtag);
        }
        nbt.m_128365_("chunks", (Tag)chunksTagList);
        nbt.m_128359_("mode", this.mode.name());
        if (this.created != null) {
            nbt.m_128356_("created", this.created.getTime());
        }
        if (this.modified != null) {
            nbt.m_128356_("modified", this.modified.getTime());
        }
    }

    public void fromBytes(FriendlyByteBuf buf) {
        int i;
        this.changes.clear();
        for (Change change : Change.valuesArray) {
            if (!buf.readBoolean()) continue;
            this.changes.add(change);
        }
        this.id = UUIDHelper.fromBytes((ByteBuf)buf);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        this.personal = buf.readBoolean();
        this.owner = new SettingsUser();
        this.owner.fromBytes(buf);
        if (this.changes.contains((Object)Change.Other)) {
            this.color = buf.readInt();
            this.visible = buf.readBoolean();
            this.fullscreenVisible = buf.readBoolean();
            this.fullscreenNameVisible = buf.readBoolean();
            this.fullscreenOwnerVisible = buf.readBoolean();
            this.minimapVisible = buf.readBoolean();
            this.minimapNameVisible = buf.readBoolean();
            this.minimapOwnerVisible = buf.readBoolean();
            this.announceInChat = buf.readBoolean();
            this.announceInTitle = buf.readBoolean();
        }
        if (this.changes.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            this.name1 = buf.m_130136_(maxBytes);
            this.name2 = buf.m_130136_(maxBytes);
            if (this.name1.length() > maxCharacters) {
                this.name1 = this.name1.substring(0, maxCharacters);
            }
            if (this.name2.length() > maxCharacters) {
                this.name2 = this.name2.substring(0, maxCharacters);
            }
        }
        if (this.changes.contains((Object)Change.Banner)) {
            if (buf.readBoolean()) {
                this.banner = new BannerData();
                this.banner.fromBytes(buf);
            } else {
                this.banner = null;
            }
        }
        if (this.changes.contains((Object)Change.Shared)) {
            if (buf.readBoolean()) {
                this.usersShared = new ArrayList<SettingsUserShared>();
                int usersCount = buf.readInt();
                for (i = 0; i < usersCount; ++i) {
                    SettingsUserShared userShared = new SettingsUserShared();
                    userShared.fromBytes(buf);
                    this.usersShared.add(userShared);
                }
            } else {
                this.usersShared = null;
            }
        }
        if (this.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            int vertexCount = buf.readInt();
            for (i = 0; i < vertexCount; ++i) {
                BlockPos vertex = BlockPos.m_122022_((long)buf.readLong());
                this.vertices.add(vertex);
            }
            this.chunks.clear();
            int chunkCount = buf.readInt();
            for (int i2 = 0; i2 < chunkCount; ++i2) {
                ChunkPos chunk = new ChunkPos(buf.readLong());
                this.chunks.add(chunk);
            }
            this.mode = Mode.values()[buf.readInt()];
        }
        this.created = buf.readBoolean() ? new Date(buf.readLong()) : null;
        this.modified = buf.readBoolean() ? new Date(buf.readLong()) : null;
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.toBytes(buf, true);
    }

    public void toBytes(FriendlyByteBuf buf, boolean onlyChanges) {
        for (Change change : Change.valuesArray) {
            if (onlyChanges) {
                buf.writeBoolean(this.changes.contains((Object)change));
                continue;
            }
            buf.writeBoolean(true);
        }
        UUIDHelper.toBytes((ByteBuf)buf, this.id);
        buf.m_130085_(this.dimension.m_135782_());
        buf.writeBoolean(this.personal);
        this.owner.toBytes(buf);
        if (!onlyChanges || this.changes.contains((Object)Change.Other)) {
            buf.writeInt(this.color);
            buf.writeBoolean(this.visible);
            buf.writeBoolean(this.fullscreenVisible);
            buf.writeBoolean(this.fullscreenNameVisible);
            buf.writeBoolean(this.fullscreenOwnerVisible);
            buf.writeBoolean(this.minimapVisible);
            buf.writeBoolean(this.minimapNameVisible);
            buf.writeBoolean(this.minimapOwnerVisible);
            buf.writeBoolean(this.announceInChat);
            buf.writeBoolean(this.announceInTitle);
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            buf.m_130072_(this.name1, maxBytes);
            buf.m_130072_(this.name2, maxBytes);
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Banner)) {
            if (this.banner == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                this.banner.toBytes(buf);
            }
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Shared)) {
            if (this.personal && this.usersShared != null) {
                buf.writeBoolean(true);
                buf.writeInt(this.usersShared.size());
                for (SettingsUserShared userShared : this.usersShared) {
                    userShared.toBytes(buf);
                }
            } else {
                buf.writeBoolean(false);
            }
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Vertices)) {
            buf.writeInt(this.vertices.size());
            for (BlockPos pos : this.vertices) {
                buf.writeLong(pos.m_121878_());
            }
            buf.writeInt(this.chunks.size());
            for (ChunkPos pos : this.chunks) {
                buf.writeLong(pos.m_45588_());
            }
            buf.writeInt(this.mode.ordinal());
        }
        if (this.created == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(this.created.getTime());
        }
        if (this.modified == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(this.modified.getTime());
        }
    }

    public static enum Mode {
        Vertex,
        Chunk;

    }

    public static enum Change {
        Name,
        Vertices,
        Banner,
        Shared,
        Other;

        public static final Change[] valuesArray;

        static {
            valuesArray = Change.values();
        }
    }

    public static class BannerData {
        public DyeColor baseColor;
        public ListTag patterns;

        public BannerData() {
            this.baseColor = DyeColor.WHITE;
        }

        public BannerData(ItemStack itemBanner) {
            CompoundTag blockEntityTag = itemBanner.m_41737_("BlockEntityTag");
            if (blockEntityTag != null && blockEntityTag.m_128425_("Patterns", 9)) {
                this.patterns = blockEntityTag.m_128437_("Patterns", 10);
            }
            if (itemBanner.m_41720_() instanceof BannerItem) {
                this.baseColor = ((BannerItem)itemBanner.m_41720_()).m_40545_();
            }
        }

        public void readFromNBT(CompoundTag nbt) {
            this.baseColor = DyeColor.m_41053_((int)nbt.m_128451_("Base"));
            this.patterns = nbt.m_128437_("Patterns", 10);
        }

        public void writeToNBT(CompoundTag nbt) {
            nbt.m_128405_("Base", this.baseColor.m_41060_());
            if (this.patterns != null) {
                nbt.m_128365_("Patterns", (Tag)this.patterns);
            }
        }

        public void fromBytes(FriendlyByteBuf buf) {
            this.baseColor = DyeColor.m_41053_((int)buf.readInt());
            CompoundTag nbt = buf.m_130260_();
            if (nbt != null) {
                this.patterns = nbt.m_128437_("Patterns", 10);
            }
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.writeInt(this.baseColor.m_41060_());
            if (this.patterns == null) {
                buf.m_130079_(null);
            } else {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("Patterns", (Tag)this.patterns);
                buf.m_130079_(nbt);
            }
        }
    }
}

