/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import com.mojang.blaze3d.platform.Window;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUDWidget;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ModSettings;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class HUDSettings
extends Screen {
    private final Screen previousScreen;
    private final boolean showKeyHint;
    private HUDWidget HUDWidget;
    private OptionButton buttonSlot1;
    private OptionButton buttonSlot2;
    private OptionButton buttonSlot3;
    private TextBoxInt textBannerSize;
    private OptionButton buttonAnchor;
    private TextBoxInt textPositionX;
    private TextBoxInt textPositionY;
    private OptionButton buttonAutoAdjustAnchor;
    private OptionButton buttonSnapToBorder;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels;
    private final Map<SimpleLabel, List<Component>> labelTooltips;
    private final HUD hud;
    private int anchorLineColor = -2236963;
    private int anchorLineColorTick = 0;

    public HUDSettings(@Nullable Screen previousScreen, boolean showKeyHint) {
        super((Component)Component.m_237119_());
        this.previousScreen = previousScreen;
        this.showKeyHint = showKeyHint;
        this.labels = new ArrayList<SimpleLabel>();
        this.labelTooltips = new HashMap<SimpleLabel, List<Component>>();
        this.hud = HUD.asPreview();
    }

    public void m_7856_() {
        ClientEventHandler.postUpdatedConfigEvent();
        this.HUDWidget = new HUDWidget(this.hud, Services.JOURNEYMAP.isMinimapEnabled(), widget -> this.HUDUpdated());
        this.buttonSlot1 = new OptionButton(this.f_96547_, this.f_96543_ / 2 - 104, this.f_96544_ / 2 - 32, 64, this::buttonPressed);
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot1.setSelected(Config.hudSlot1.ordinal());
        this.buttonSlot2 = new OptionButton(this.f_96547_, this.f_96543_ / 2 - 104, this.f_96544_ / 2 - 16, 64, this::buttonPressed);
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot2.setSelected(Config.hudSlot2.ordinal());
        this.buttonSlot3 = new OptionButton(this.f_96547_, this.f_96543_ / 2 - 104, this.f_96544_ / 2, 64, this::buttonPressed);
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot3.setSelected(Config.hudSlot3.ordinal());
        this.textBannerSize = new TextBoxInt(3, 1, 8, this.f_96547_, this.f_96543_ / 2 - 104, this.f_96544_ / 2 + 16, 64);
        this.textBannerSize.m_94144_(String.valueOf(Config.hudBannerSize));
        this.textBannerSize.m_94199_(1);
        this.textBannerSize.setValueChangedCallback(value -> {
            Config.hudBannerSize = value;
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        this.buttonAnchor = new OptionButton(this.f_96547_, this.f_96543_ / 2 + 96, this.f_96544_ / 2 - 32, 134, this::buttonPressed);
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTop));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottom));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.Minimap));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapHorizontal));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapVertical));
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        this.textPositionX = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.f_96547_, this.f_96543_ / 2 + 96, this.f_96544_ / 2 - 16, 61);
        this.textPositionX.m_94144_(String.valueOf(Config.hudXPosition));
        this.textPositionX.m_94199_(5);
        this.textPositionX.setValueChangedCallback(value -> {
            Config.hudXPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.textPositionY = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.f_96547_, this.f_96543_ / 2 + 168, this.f_96544_ / 2 - 16, 62);
        this.textPositionY.m_94144_(String.valueOf(Config.hudYPosition));
        this.textPositionY.m_94199_(5);
        this.textPositionY.setValueChangedCallback(value -> {
            Config.hudYPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.buttonAutoAdjustAnchor = new OptionButton(this.f_96547_, this.f_96543_ / 2 + 96, this.f_96544_ / 2, 134, this::buttonPressed);
        this.buttonAutoAdjustAnchor.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonAutoAdjustAnchor.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonAutoAdjustAnchor.setSelected(Config.hudAutoAdjustAnchor ? 0 : 1);
        this.buttonSnapToBorder = new OptionButton(this.f_96547_, this.f_96543_ / 2 + 96, this.f_96544_ / 2 + 16, 134, this::buttonPressed);
        this.buttonSnapToBorder.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonSnapToBorder.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonSnapToBorder.setSelected(Config.hudSnapToBorder ? 0 : 1);
        this.buttonDone = new SimpleButton(this.f_96547_, this.f_96543_ / 2 - 50, this.f_96544_ / 2 + 36, 100, (Component)Component.m_237115_((String)"mapfrontiers.done"), this::buttonPressed);
        this.m_142416_((GuiEventListener)this.HUDWidget);
        this.m_142416_((GuiEventListener)this.buttonSlot1);
        this.m_142416_((GuiEventListener)this.buttonSlot2);
        this.m_142416_((GuiEventListener)this.buttonSlot3);
        this.m_142416_((GuiEventListener)this.textBannerSize);
        this.m_142416_((GuiEventListener)this.buttonAnchor);
        this.m_142416_((GuiEventListener)this.textPositionX);
        this.m_142416_((GuiEventListener)this.textPositionY);
        this.m_142416_((GuiEventListener)this.buttonAutoAdjustAnchor);
        this.m_142416_((GuiEventListener)this.buttonSnapToBorder);
        this.m_142416_((GuiEventListener)this.buttonDone);
        this.resetLabels();
        this.updatePosition();
    }

    public void m_86600_() {
        ++this.anchorLineColorTick;
        if (this.anchorLineColorTick >= 3) {
            this.anchorLineColorTick = 0;
            this.anchorLineColor = this.anchorLineColor == -2236963 ? -14540254 : -2236963;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (Services.JOURNEYMAP.isMinimapEnabled()) {
            Services.JOURNEYMAP.drawMinimapPreview(graphics);
        }
        this.drawAnchor(graphics, this.f_96541_.m_91268_());
        graphics.m_280509_(this.f_96543_ / 2 - 238, this.f_96544_ / 2 - 40, this.f_96543_ / 2 + 238, this.f_96544_ / 2 + 60, -955248624);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_) continue;
            label.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_ || !label.m_274382_()) continue;
            List<Component> tooltip = this.labelTooltips.get((Object)label);
            if (tooltip == null) break;
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
            break;
        }
    }

    public boolean m_7933_(int key, int value, int modifier) {
        if (key == 69 && !(this.m_7222_() instanceof EditBox)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(key, value, modifier);
    }

    private void drawAnchor(GuiGraphics graphics, Window mainWindow) {
        float factor = (float)mainWindow.m_85449_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(1.0f / factor, 1.0f / factor, 1.0f);
        int directionX = 0;
        int directionY = 0;
        int length = 25;
        Config.Point anchor = Config.getHUDAnchor(Config.hudAnchor);
        int displayWidth = mainWindow.m_85441_();
        int displayHeight = mainWindow.m_85442_();
        if (anchor.x < displayWidth / 2) {
            directionX = 1;
        } else if (anchor.x > displayWidth / 2) {
            directionX = -1;
            --anchor.x;
        }
        if (anchor.y < displayHeight / 2) {
            directionY = 1;
        } else if (anchor.y > displayHeight / 2) {
            directionY = -1;
            --anchor.y;
        }
        if (Config.hudAnchor == Config.HUDAnchor.Minimap) {
            directionX = -directionX;
            directionY = -directionY;
            if (directionX == 1) {
                ++anchor.x;
            }
            if (directionY == 1) {
                ++anchor.y;
            }
        }
        if (directionX == 0) {
            graphics.m_280656_(anchor.x - length, anchor.x + length, anchor.y, this.anchorLineColor);
        } else {
            graphics.m_280656_(anchor.x, anchor.x + length * directionX, anchor.y, this.anchorLineColor);
        }
        if (directionY == 0) {
            graphics.m_280315_(anchor.x, anchor.y - length, anchor.y + length, this.anchorLineColor);
        } else {
            graphics.m_280315_(anchor.x, anchor.y, anchor.y + length * directionY, this.anchorLineColor);
        }
        graphics.m_280168_().m_85849_();
    }

    protected void buttonPressed(Button button) {
        if (button == this.buttonSlot1) {
            this.updateSlots();
        } else if (button == this.buttonSlot2) {
            this.updateSlots();
        } else if (button == this.buttonSlot3) {
            this.updateSlots();
        } else if (button == this.buttonAnchor) {
            Config.hudAnchor = Config.HUDAnchor.values()[this.buttonAnchor.getSelected()];
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        } else if (button == this.buttonAutoAdjustAnchor) {
            Config.hudAutoAdjustAnchor = this.buttonAutoAdjustAnchor.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonSnapToBorder) {
            Config.hudSnapToBorder = this.buttonSnapToBorder.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonDone) {
            this.m_7379_();
        }
    }

    private void updateSlots() {
        this.updateSlotsValidity();
        boolean updated = false;
        if (this.buttonSlot1.getColor() == -2236963 || this.buttonSlot1.getColor() == -1) {
            Config.hudSlot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
            updated = true;
        }
        if (this.buttonSlot2.getColor() == -2236963 || this.buttonSlot2.getColor() == -1) {
            Config.hudSlot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
            updated = true;
        }
        if (this.buttonSlot3.getColor() == -2236963 || this.buttonSlot3.getColor() == -1) {
            Config.hudSlot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
            updated = true;
        }
        if (updated) {
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        }
    }

    private void updateSlotsValidity() {
        Config.HUDSlot slot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
        Config.HUDSlot slot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
        Config.HUDSlot slot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
        this.buttonSlot1.setColor(-2236963, -1);
        this.buttonSlot2.setColor(-2236963, -1);
        this.buttonSlot3.setColor(-2236963, -1);
        if (slot1 != Config.HUDSlot.None && slot1 == slot2) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot2.setColor(-2289391, -48060);
        }
        if (slot1 != Config.HUDSlot.None && slot1 == slot3) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
        if (slot2 != Config.HUDSlot.None && slot2 == slot3) {
            this.buttonSlot2.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
    }

    public void m_7861_() {
        ClientEventHandler.postUpdatedConfigEvent();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_((Screen)new ModSettings(this.previousScreen, this.showKeyHint));
    }

    private void resetLabels() {
        this.labels.clear();
        this.labelTooltips.clear();
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 230, this.f_96544_ / 2 - 30, SimpleLabel.Align.Left, Config.getTranslatedName("hud.slot1"), -2236963), Config.getTooltip("hud.slot1"));
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 230, this.f_96544_ / 2 - 14, SimpleLabel.Align.Left, Config.getTranslatedName("hud.slot2"), -2236963), Config.getTooltip("hud.slot2"));
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 230, this.f_96544_ / 2 + 2, SimpleLabel.Align.Left, Config.getTranslatedName("hud.slot3"), -2236963), Config.getTooltip("hud.slot3"));
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 230, this.f_96544_ / 2 + 18, SimpleLabel.Align.Left, Config.getTranslatedName("hud.bannerSize"), -2236963), Config.getTooltip("hud.bannerSize"));
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 30, this.f_96544_ / 2 - 30, SimpleLabel.Align.Left, Config.getTranslatedName("hud.anchor"), -2236963), Config.getTooltip("hud.anchor"));
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 30, this.f_96544_ / 2 - 14, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.config.hud.position"), -2236963), Collections.singletonList(Component.m_237113_((String)"HUD position relative to anchor.")));
        this.labels.add(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 + 162, this.f_96544_ / 2 - 14, SimpleLabel.Align.Center, (Component)Component.m_237113_((String)"x"), -8947849));
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 30, this.f_96544_ / 2 + 2, SimpleLabel.Align.Left, Config.getTranslatedName("hud.autoAdjustAnchor"), -2236963), Config.getTooltip("hud.autoAdjustAnchor"));
        this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.f_96543_ / 2 - 30, this.f_96544_ / 2 + 18, SimpleLabel.Align.Left, Config.getTranslatedName("hud.snapToBorder"), -2236963), Config.getTooltip("hud.snapToBorder"));
    }

    private void addLabelWithTooltip(SimpleLabel label, List<Component> tooltip) {
        this.labels.add(label);
        this.labelTooltips.put(label, tooltip);
    }

    private void updatePosition() {
        Config.Point anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
        Config.Point positionPoint = new Config.Point();
        positionPoint.x = Config.hudXPosition + anchorPoint.x - originPoint.x;
        positionPoint.y = Config.hudYPosition + anchorPoint.y - originPoint.y;
        this.HUDWidget.setPositionHUD(positionPoint);
    }

    private void HUDUpdated() {
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        this.textPositionX.m_94144_(String.valueOf(Config.hudXPosition));
        this.textPositionY.m_94144_(String.valueOf(Config.hudYPosition));
    }
}

