/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.ColorConstants;
import games.alejandrocoria.mapfrontiers.client.gui.component.ColorPicker;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ShareSettings;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.ColorHelper;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Context;
import journeymap.client.api.util.UIState;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class FrontierInfo
extends Screen {
    static final DateFormat dateFormat = new SimpleDateFormat();
    private final IClientAPI jmAPI;
    private final Runnable afterClose;
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private final FrontiersOverlayManager frontiersOverlayManager;
    private final FrontierOverlay frontier;
    private TextBox textName1;
    private TextBox textName2;
    private OptionButton buttonVisible;
    private OptionButton buttonFullscreenVisible;
    private OptionButton buttonFullscreenNameVisible;
    private OptionButton buttonFullscreenOwnerVisible;
    private OptionButton buttonMinimapVisible;
    private OptionButton buttonMinimapNameVisible;
    private OptionButton buttonMinimapOwnerVisible;
    private OptionButton buttonAnnounceInChat;
    private OptionButton buttonAnnounceInTitle;
    private TextBoxInt textRed;
    private TextBoxInt textGreen;
    private TextBoxInt textBlue;
    private SimpleButton buttonRandomColor;
    private ColorPicker colorPicker;
    private IconButton buttonCopy;
    private IconButton buttonPaste;
    private IconButton buttonOpenPasteOptions;
    private IconButton buttonClosePasteOptions;
    private OptionButton buttonPasteName;
    private OptionButton buttonPasteVisibility;
    private OptionButton buttonPasteColor;
    private OptionButton buttonPasteBanner;
    private SimpleLabel labelPasteName;
    private SimpleLabel labelPasteVisibility;
    private SimpleLabel labelPasteColor;
    private SimpleLabel labelPasteBanner;
    private IconButton buttonUndo;
    private IconButton buttonRedo;
    private SimpleButton buttonSelect;
    private SimpleButton buttonShareSettings;
    private SimpleButton buttonDelete;
    private SimpleButton buttonDone;
    private SimpleButton buttonBanner;
    private final List<SimpleLabel> labels;
    private SimpleLabel modifiedLabel;
    private final Stack<FrontierData> undoStack = new Stack();
    private final Stack<FrontierData> redoStack = new Stack();

    public FrontierInfo(IClientAPI jmAPI, FrontierOverlay frontier) {
        this(jmAPI, frontier, null);
    }

    public FrontierInfo(IClientAPI jmAPI, FrontierOverlay frontier, @Nullable Runnable afterClose) {
        super((Component)Component.m_237115_((String)"mapfrontiers.title_info"));
        this.jmAPI = jmAPI;
        this.afterClose = afterClose;
        this.frontiersOverlayManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
        this.frontier = frontier;
        this.labels = new ArrayList<SimpleLabel>();
        this.undoStack.push(new FrontierData(frontier));
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontier.getId().equals(frontierID)) {
                this.m_7379_();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (this.f_96541_.f_91074_ != null && frontier.getId().equals(frontierOverlay.getId())) {
                this.addToUndo(new FrontierData((FrontierData)frontierOverlay));
                if (playerID.intValue() != this.f_96541_.f_91074_.m_19879_()) {
                    this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                } else if (frontier.getModified() != null) {
                    MutableComponent modified = Component.m_237110_((String)"mapfrontiers.modified", (Object[])new Object[]{dateFormat.format(frontier.getModified())});
                    this.modifiedLabel.setText((Component)modified);
                }
            }
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            this.updateButtons();
            this.updateBannerButton();
        });
    }

    public void m_7856_() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.f_96541_, this, 627, 336);
        this.actualWidth = (int)((float)this.f_96543_ * this.scaleFactor);
        this.actualHeight = (int)((float)this.f_96544_ * this.scaleFactor);
        int leftSide = this.actualWidth / 2 - 154;
        int rightSide = this.actualWidth / 2 + 10;
        int top = this.actualHeight / 2 - 142;
        this.labels.clear();
        this.labels.add(new SimpleLabel(this.f_96547_, leftSide, top, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.name"), -16711681));
        this.textName1 = new TextBox(this.f_96547_, leftSide, top + 12, 144);
        this.textName1.m_94199_(17);
        this.textName1.setHeight(20);
        this.textName1.m_94144_(this.frontier.getName1());
        this.textName1.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName1.setValueChangedCallback(value -> {
            if (!this.frontier.getName1().equals(value)) {
                this.frontier.setName1((String)value);
            }
        });
        this.textName2 = new TextBox(this.f_96547_, leftSide, top + 40, 144);
        this.textName2.m_94199_(17);
        this.textName2.setHeight(20);
        this.textName2.m_94144_(this.frontier.getName2());
        this.textName2.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName2.setValueChangedCallback(value -> {
            if (!this.frontier.getName2().equals(value)) {
                this.frontier.setName2((String)value);
            }
        });
        this.labels.add(new SimpleLabel(this.f_96547_, leftSide, top + 70, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.show_frontier"), -2236963));
        this.buttonVisible = new OptionButton(this.f_96547_, leftSide + 116, top + 68, 28, this::buttonPressed);
        this.buttonVisible.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonVisible.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonVisible.setSelected(this.frontier.getVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top + 70, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.show_fullscreen"), -2236963));
        this.buttonFullscreenVisible = new OptionButton(this.f_96547_, rightSide + 116, top + 68, 28, this::buttonPressed);
        this.buttonFullscreenVisible.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonFullscreenVisible.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonFullscreenVisible.setSelected(this.frontier.getFullscreenVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top + 86, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.show_name"), -2236963));
        this.buttonFullscreenNameVisible = new OptionButton(this.f_96547_, rightSide + 116, top + 84, 28, this::buttonPressed);
        this.buttonFullscreenNameVisible.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonFullscreenNameVisible.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonFullscreenNameVisible.setSelected(this.frontier.getFullscreenNameVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top + 102, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.show_owner"), -2236963));
        this.buttonFullscreenOwnerVisible = new OptionButton(this.f_96547_, rightSide + 116, top + 100, 28, this::buttonPressed);
        this.buttonFullscreenOwnerVisible.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonFullscreenOwnerVisible.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonFullscreenOwnerVisible.setSelected(this.frontier.getFullscreenOwnerVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide + 154, top + 70, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.show_minimap"), -2236963));
        this.buttonMinimapVisible = new OptionButton(this.f_96547_, rightSide + 154 + 116, top + 68, 28, this::buttonPressed);
        this.buttonMinimapVisible.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonMinimapVisible.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonMinimapVisible.setSelected(this.frontier.getMinimapVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide + 154, top + 86, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.show_name"), -2236963));
        this.buttonMinimapNameVisible = new OptionButton(this.f_96547_, rightSide + 154 + 116, top + 84, 28, this::buttonPressed);
        this.buttonMinimapNameVisible.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonMinimapNameVisible.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonMinimapNameVisible.setSelected(this.frontier.getMinimapNameVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide + 154, top + 102, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.show_owner"), -2236963));
        this.buttonMinimapOwnerVisible = new OptionButton(this.f_96547_, rightSide + 154 + 116, top + 100, 28, this::buttonPressed);
        this.buttonMinimapOwnerVisible.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonMinimapOwnerVisible.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonMinimapOwnerVisible.setSelected(this.frontier.getMinimapOwnerVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, leftSide, top + 86, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.announce_in_chat"), -2236963));
        this.buttonAnnounceInChat = new OptionButton(this.f_96547_, leftSide + 116, top + 84, 28, this::buttonPressed);
        this.buttonAnnounceInChat.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonAnnounceInChat.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonAnnounceInChat.setSelected(this.frontier.getAnnounceInChat() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, leftSide, top + 102, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.announce_in_title"), -2236963));
        this.buttonAnnounceInTitle = new OptionButton(this.f_96547_, leftSide + 116, top + 100, 28, this::buttonPressed);
        this.buttonAnnounceInTitle.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonAnnounceInTitle.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonAnnounceInTitle.setSelected(this.frontier.getAnnounceInTitle() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top + 152, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.color"), -16711681));
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide - 11, top + 170, SimpleLabel.Align.Left, (Component)Component.m_237113_((String)"R"), -16711681));
        this.textRed = new TextBoxInt(0, 0, 255, this.f_96547_, rightSide, top + 164, 29);
        this.textRed.setHeight(20);
        this.textRed.m_93674_(34);
        this.textRed.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFF00FFFF | value << 16;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide + 44, top + 170, SimpleLabel.Align.Left, (Component)Component.m_237113_((String)"G"), -16711681));
        this.textGreen = new TextBoxInt(0, 0, 255, this.f_96547_, rightSide + 55, top + 164, 29);
        this.textGreen.setHeight(20);
        this.textGreen.m_93674_(34);
        this.textGreen.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFF00FF | value << 8;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide + 99, top + 170, SimpleLabel.Align.Left, (Component)Component.m_237113_((String)"B"), -16711681));
        this.textBlue = new TextBoxInt(0, 0, 255, this.f_96547_, rightSide + 110, top + 164, 29);
        this.textBlue.setHeight(20);
        this.textBlue.m_93674_(34);
        this.textBlue.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFFFF00 | value;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        this.buttonRandomColor = new SimpleButton(this.f_96547_, rightSide, top + 190, 145, (Component)Component.m_237115_((String)"mapfrontiers.random_color"), this::buttonPressed);
        this.colorPicker = new ColorPicker(leftSide + 2, top + 156, this.frontier.getColor(), (picker, dragging) -> this.colorPickerUpdated((boolean)dragging));
        this.buttonCopy = new IconButton(rightSide + 154, top + 263, IconButton.Type.Copy, this::buttonPressed);
        this.buttonPaste = new IconButton(rightSide + 174, top + 263, IconButton.Type.Paste, this::buttonPressed);
        this.buttonOpenPasteOptions = new IconButton(rightSide + 191, top + 263, IconButton.Type.ArrowUp, this::buttonPressed);
        this.buttonClosePasteOptions = new IconButton(rightSide + 191, top + 263, IconButton.Type.ArrowDown, this::buttonPressed);
        this.labelPasteName = new SimpleLabel(this.f_96547_, rightSide + 154, top + 200, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.paste_name"), -2236963);
        this.labels.add(this.labelPasteName);
        this.buttonPasteName = new OptionButton(this.f_96547_, rightSide + 154 + 116, top + 198, 28, this::buttonPressed);
        this.buttonPasteName.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonPasteName.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonPasteName.setSelected(Config.pasteName ? 0 : 1);
        this.labelPasteVisibility = new SimpleLabel(this.f_96547_, rightSide + 154, top + 216, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.paste_visibility"), -2236963);
        this.labels.add(this.labelPasteVisibility);
        this.buttonPasteVisibility = new OptionButton(this.f_96547_, rightSide + 154 + 116, top + 214, 28, this::buttonPressed);
        this.buttonPasteVisibility.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonPasteVisibility.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonPasteVisibility.setSelected(Config.pasteVisibility ? 0 : 1);
        this.labelPasteColor = new SimpleLabel(this.f_96547_, rightSide + 154, top + 232, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.paste_color"), -2236963);
        this.labels.add(this.labelPasteColor);
        this.buttonPasteColor = new OptionButton(this.f_96547_, rightSide + 154 + 116, top + 230, 28, this::buttonPressed);
        this.buttonPasteColor.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonPasteColor.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonPasteColor.setSelected(Config.pasteColor ? 0 : 1);
        this.labelPasteBanner = new SimpleLabel(this.f_96547_, rightSide + 154, top + 248, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.paste_banner"), -2236963);
        this.labels.add(this.labelPasteBanner);
        this.buttonPasteBanner = new OptionButton(this.f_96547_, rightSide + 154 + 116, top + 246, 28, this::buttonPressed);
        this.buttonPasteBanner.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonPasteBanner.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonPasteBanner.setSelected(Config.pasteBanner ? 0 : 1);
        this.buttonUndo = new IconButton(rightSide + 202, top + 263, IconButton.Type.Undo, this::buttonPressed);
        this.buttonRedo = new IconButton(rightSide + 222, top + 263, IconButton.Type.Redo, this::buttonPressed);
        int offset1 = StringHelper.getMaxWidth(this.f_96547_, I18n.m_118938_((String)"mapfrontiers.type", (Object[])new Object[]{I18n.m_118938_((String)"mapfrontiers.config.Personal", (Object[])new Object[0])}), I18n.m_118938_((String)"mapfrontiers.type", (Object[])new Object[]{I18n.m_118938_((String)"mapfrontiers.config.Global", (Object[])new Object[0])})) + 10;
        int offset2 = StringHelper.getMaxWidth(this.f_96547_, I18n.m_118938_((String)"mapfrontiers.vertices", (Object[])new Object[]{9999}), I18n.m_118938_((String)"mapfrontiers.chunks", (Object[])new Object[]{9999})) + 10;
        MutableComponent type = Component.m_237110_((String)"mapfrontiers.type", (Object[])new Object[]{Component.m_237115_((String)(this.frontier.getPersonal() ? "mapfrontiers.config.Personal" : "mapfrontiers.config.Global"))});
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top, SimpleLabel.Align.Left, (Component)type, -1));
        if (this.frontier.getMode() == FrontierData.Mode.Vertex) {
            MutableComponent vertices = Component.m_237110_((String)"mapfrontiers.vertices", (Object[])new Object[]{this.frontier.getVertexCount()});
            this.labels.add(new SimpleLabel(this.f_96547_, rightSide + offset1, top, SimpleLabel.Align.Left, (Component)vertices, -1));
        } else {
            MutableComponent chunks = Component.m_237110_((String)"mapfrontiers.chunks", (Object[])new Object[]{this.frontier.getChunkCount()});
            this.labels.add(new SimpleLabel(this.f_96547_, rightSide + offset1, top, SimpleLabel.Align.Left, (Component)chunks, -1));
        }
        MutableComponent owner = Component.m_237110_((String)"mapfrontiers.owner", (Object[])new Object[]{this.frontier.getOwner()});
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide + offset1 + offset2, top, SimpleLabel.Align.Left, (Component)owner, -1));
        MutableComponent dimension = Component.m_237110_((String)"mapfrontiers.dimension", (Object[])new Object[]{this.frontier.getDimension().m_135782_().toString()});
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top + 10, SimpleLabel.Align.Left, (Component)dimension, -6710887));
        MutableComponent area = Component.m_237110_((String)"mapfrontiers.area", (Object[])new Object[]{Float.valueOf(this.frontier.area)});
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top + 32, SimpleLabel.Align.Left, (Component)area, -1));
        MutableComponent perimeter = Component.m_237110_((String)"mapfrontiers.perimeter", (Object[])new Object[]{Float.valueOf(this.frontier.perimeter)});
        this.labels.add(new SimpleLabel(this.f_96547_, rightSide, top + 42, SimpleLabel.Align.Left, (Component)perimeter, -1));
        if (this.frontier.getCreated() != null) {
            MutableComponent created = Component.m_237110_((String)"mapfrontiers.created", (Object[])new Object[]{dateFormat.format(this.frontier.getCreated())});
            this.labels.add(new SimpleLabel(this.f_96547_, rightSide + 154, top + 32, SimpleLabel.Align.Left, (Component)created, -1));
        }
        if (this.frontier.getModified() != null) {
            MutableComponent modified = Component.m_237110_((String)"mapfrontiers.modified", (Object[])new Object[]{dateFormat.format(this.frontier.getModified())});
            this.modifiedLabel = new SimpleLabel(this.f_96547_, rightSide + 154, top + 42, SimpleLabel.Align.Left, (Component)modified, -1);
            this.labels.add(this.modifiedLabel);
        }
        this.buttonSelect = new SimpleButton(this.f_96547_, leftSide - 154, top + 290, 144, (Component)Component.m_237115_((String)"mapfrontiers.select_in_map"), this::buttonPressed);
        this.buttonShareSettings = new SimpleButton(this.f_96547_, leftSide, top + 290, 144, (Component)Component.m_237115_((String)"mapfrontiers.share_settings"), this::buttonPressed);
        this.buttonDelete = new SimpleButton(this.f_96547_, rightSide, top + 290, 144, (Component)Component.m_237115_((String)"mapfrontiers.delete"), this::buttonPressed);
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonDone = new SimpleButton(this.f_96547_, rightSide + 154, top + 290, 144, (Component)Component.m_237115_((String)"gui.done"), this::buttonPressed);
        this.buttonBanner = new SimpleButton(this.f_96547_, leftSide - 152, top, 144, (Component)Component.m_237115_((String)"mapfrontiers.assign_banner"), this::buttonPressed);
        this.m_142416_((GuiEventListener)this.textName1);
        this.m_142416_((GuiEventListener)this.textName2);
        this.m_142416_((GuiEventListener)this.buttonVisible);
        this.m_142416_((GuiEventListener)this.buttonFullscreenVisible);
        this.m_142416_((GuiEventListener)this.buttonFullscreenNameVisible);
        this.m_142416_((GuiEventListener)this.buttonFullscreenOwnerVisible);
        this.m_142416_((GuiEventListener)this.buttonMinimapVisible);
        this.m_142416_((GuiEventListener)this.buttonMinimapNameVisible);
        this.m_142416_((GuiEventListener)this.buttonMinimapOwnerVisible);
        this.m_142416_((GuiEventListener)this.buttonAnnounceInChat);
        this.m_142416_((GuiEventListener)this.buttonAnnounceInTitle);
        this.m_142416_((GuiEventListener)this.textRed);
        this.m_142416_((GuiEventListener)this.textGreen);
        this.m_142416_((GuiEventListener)this.textBlue);
        this.m_142416_((GuiEventListener)this.buttonRandomColor);
        this.m_142416_((GuiEventListener)this.colorPicker);
        this.m_142416_((GuiEventListener)this.buttonCopy);
        this.m_142416_((GuiEventListener)this.buttonPaste);
        this.m_142416_((GuiEventListener)this.buttonOpenPasteOptions);
        this.m_142416_((GuiEventListener)this.buttonClosePasteOptions);
        this.m_142416_((GuiEventListener)this.buttonPasteName);
        this.m_142416_((GuiEventListener)this.buttonPasteVisibility);
        this.m_142416_((GuiEventListener)this.buttonPasteColor);
        this.m_142416_((GuiEventListener)this.buttonPasteBanner);
        this.m_142416_((GuiEventListener)this.buttonUndo);
        this.m_142416_((GuiEventListener)this.buttonRedo);
        this.m_142416_((GuiEventListener)this.buttonSelect);
        this.m_142416_((GuiEventListener)this.buttonShareSettings);
        this.m_142416_((GuiEventListener)this.buttonDelete);
        this.m_142416_((GuiEventListener)this.buttonDone);
        this.m_142416_((GuiEventListener)this.buttonBanner);
        this.updateBannerButton();
        this.updateButtons();
        this.updatePasteOptionsVisibility();
        this.updateUndoRedoVisibility();
    }

    public void m_86600_() {
        this.textName1.m_94120_();
        this.textName2.m_94120_();
        this.textRed.m_94120_();
        this.textGreen.m_94120_();
        this.textBlue.m_94120_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.actualWidth / 2, 8, -1);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.frontier.hasBanner()) {
            this.frontier.renderBanner(this.f_96541_, graphics, this.actualWidth / 2 - 276, this.actualHeight / 2 - 122, 4);
        }
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_) continue;
            label.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.buttonBanner.f_93624_ && this.buttonBanner.m_274382_()) {
            if (!this.frontier.hasBanner() && FrontierInfo.getHeldBanner(this.f_96541_) == null) {
                MutableComponent prefix = Component.m_237113_((String)(ColorConstants.WARNING + "! " + ChatFormatting.RESET));
                graphics.m_280557_(this.f_96547_, (Component)prefix.m_7220_((Component)Component.m_237115_((String)"mapfrontiers.assign_banner_warn")), mouseX, mouseY);
            }
        } else if (this.buttonCopy.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.copy"), mouseX, mouseY);
        } else if (this.buttonPaste.f_93624_ && this.buttonPaste.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.paste"), mouseX, mouseY);
        } else if (this.buttonOpenPasteOptions.f_93624_ && this.buttonOpenPasteOptions.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.open_paste_options"), mouseX, mouseY);
        } else if (this.buttonClosePasteOptions.f_93624_ && this.buttonClosePasteOptions.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.close_paste_options"), mouseX, mouseY);
        } else if (this.buttonUndo.f_93624_ && this.buttonUndo.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.undo"), mouseX, mouseY);
        } else if (this.buttonRedo.f_93624_ && this.buttonRedo.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.redo"), mouseX, mouseY);
        }
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        if (mouseButton == 0) {
            this.textName1.m_6375_(mouseX, mouseY, mouseButton);
            this.textName2.m_6375_(mouseX, mouseY, mouseButton);
            this.textRed.m_6375_(mouseX, mouseY, mouseButton);
            this.textGreen.m_6375_(mouseX, mouseY, mouseButton);
            this.textBlue.m_6375_(mouseX, mouseY, mouseButton);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        for (GuiEventListener w : this.m_6702_()) {
            if (!(w instanceof ColorPicker)) continue;
            w.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.m_7979_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    public boolean m_7933_(int key, int value, int modifier) {
        if (key == 90 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_()) {
            this.undo();
            return true;
        }
        if (key == 90 && Screen.m_96637_() && Screen.m_96638_() && !Screen.m_96639_()) {
            this.redo();
            return true;
        }
        return super.m_7933_(key, value, modifier);
    }

    protected void buttonPressed(Button button) {
        if (button == this.buttonVisible) {
            this.frontier.setVisible(this.buttonVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonFullscreenVisible) {
            this.frontier.setFullscreenVisible(this.buttonFullscreenVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonFullscreenNameVisible) {
            this.frontier.setFullscreenNameVisible(this.buttonFullscreenNameVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonFullscreenOwnerVisible) {
            this.frontier.setFullscreenOwnerVisible(this.buttonFullscreenOwnerVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonMinimapVisible) {
            this.frontier.setMinimapVisible(this.buttonMinimapVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonMinimapNameVisible) {
            this.frontier.setMinimapNameVisible(this.buttonMinimapNameVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonMinimapOwnerVisible) {
            this.frontier.setMinimapOwnerVisible(this.buttonMinimapOwnerVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonAnnounceInChat) {
            this.frontier.setAnnounceInChat(this.buttonAnnounceInChat.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonAnnounceInTitle) {
            this.frontier.setAnnounceInTitle(this.buttonAnnounceInTitle.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonRandomColor) {
            int newColor = ColorHelper.getRandomColor();
            this.frontier.setColor(newColor);
            this.colorPicker.setColor(newColor);
            this.textRed.setValue((newColor & 0xFF0000) >> 16);
            this.textGreen.setValue((newColor & 0xFF00) >> 8);
            this.textBlue.setValue(newColor & 0xFF);
            this.sendChangesToServer();
        } else if (button == this.buttonCopy) {
            MapFrontiersClient.setClipboard(this.frontier);
            this.updatePasteOptionsVisibility();
        } else if (button == this.buttonPaste) {
            FrontierData clipboard = MapFrontiersClient.getClipboard();
            if (clipboard != null && (Config.pasteName || Config.pasteVisibility || Config.pasteColor || Config.pasteBanner)) {
                this.setFrontier(clipboard, Config.pasteName, Config.pasteVisibility, Config.pasteColor, Config.pasteBanner);
                this.sendChangesToServer();
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }
        } else if (button == this.buttonOpenPasteOptions) {
            Config.pasteOptionsVisible = true;
            this.updatePasteOptionsVisibility();
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonClosePasteOptions) {
            Config.pasteOptionsVisible = false;
            this.updatePasteOptionsVisibility();
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteName) {
            Config.pasteName = this.buttonPasteName.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteVisibility) {
            Config.pasteVisibility = this.buttonPasteVisibility.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteColor) {
            Config.pasteColor = this.buttonPasteColor.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteBanner) {
            Config.pasteBanner = this.buttonPasteBanner.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonUndo) {
            this.undo();
        } else if (button == this.buttonRedo) {
            this.redo();
        } else if (button == this.buttonSelect) {
            BlockPos center = this.frontier.getCenter();
            Services.PLATFORM.popGuiLayer();
            Services.JOURNEYMAP.fullscreenMapCenterOn(center.m_123341_(), center.m_123343_());
        } else if (button == this.buttonShareSettings) {
            Services.PLATFORM.pushGuiLayer(new ShareSettings(this.frontiersOverlayManager, this.frontier));
        } else if (button == this.buttonDelete) {
            ClientEventHandler.unsuscribeAllEvents((Object)this);
            this.frontiersOverlayManager.clientDeleteFrontier(this.frontier);
            this.m_7379_();
        } else if (button == this.buttonDone) {
            this.m_7379_();
        } else if (button == this.buttonBanner) {
            if (!this.frontier.hasBanner()) {
                ItemStack heldBanner = FrontierInfo.getHeldBanner(this.f_96541_);
                if (heldBanner != null) {
                    this.frontier.setBanner(heldBanner);
                }
            } else {
                this.frontier.setBanner(null);
            }
            this.updateBannerButton();
            this.sendChangesToServer();
        }
    }

    public void m_7861_() {
        this.sendChangesToServer();
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    public void m_7379_() {
        Services.PLATFORM.popGuiLayer();
        if (this.afterClose != null) {
            this.afterClose.run();
        }
    }

    private void colorPickerUpdated(boolean dragging) {
        this.frontier.setColor(this.colorPicker.getColor());
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        if (!dragging) {
            this.sendChangesToServer();
        }
    }

    private void undo() {
        if (this.undoStack.size() == 1) {
            return;
        }
        this.redoStack.push(this.undoStack.pop());
        this.setFrontier(this.undoStack.peek(), true, true, true, true);
        this.sendChangesToServer();
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void redo() {
        if (this.redoStack.empty()) {
            return;
        }
        this.setFrontier(this.redoStack.peek(), true, true, true, true);
        this.undoStack.push(this.redoStack.pop());
        this.sendChangesToServer();
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void setFrontier(FrontierData other, boolean name, boolean visibility, boolean color, boolean banner) {
        if (name) {
            this.frontier.setName1(other.getName1());
            this.frontier.setName2(other.getName2());
        }
        if (visibility) {
            this.frontier.setVisible(other.getVisible());
            this.frontier.setFullscreenVisible(other.getFullscreenVisible());
            this.frontier.setFullscreenNameVisible(other.getFullscreenNameVisible());
            this.frontier.setFullscreenOwnerVisible(other.getFullscreenOwnerVisible());
            this.frontier.setMinimapVisible(other.getMinimapVisible());
            this.frontier.setMinimapNameVisible(other.getMinimapNameVisible());
            this.frontier.setMinimapOwnerVisible(other.getMinimapOwnerVisible());
            this.frontier.setAnnounceInChat(other.getAnnounceInChat());
            this.frontier.setAnnounceInTitle(other.getAnnounceInTitle());
        }
        if (color) {
            this.frontier.setColor(other.getColor());
        }
        if (banner) {
            this.frontier.setBannerData(other.getbannerData());
        }
    }

    private void updateBannerButton() {
        if (!this.frontier.hasBanner()) {
            MutableComponent message = Component.m_237115_((String)"mapfrontiers.assign_banner");
            if (FrontierInfo.getHeldBanner(this.f_96541_) == null) {
                message.m_7220_((Component)Component.m_237113_((String)(ColorConstants.WARNING + " !")));
            }
            this.buttonBanner.m_93666_((Component)message);
        } else {
            this.buttonBanner.m_93666_((Component)Component.m_237115_((String)"mapfrontiers.remove_banner"));
        }
    }

    private static ItemStack getHeldBanner(@Nullable Minecraft minecraft) {
        if (minecraft == null || minecraft.f_91074_ == null) {
            return null;
        }
        ItemStack mainhand = minecraft.f_91074_.m_6844_(EquipmentSlot.MAINHAND);
        ItemStack offhand = minecraft.f_91074_.m_6844_(EquipmentSlot.OFFHAND);
        ItemStack heldBanner = null;
        if (mainhand.m_41720_() instanceof BannerItem) {
            heldBanner = mainhand;
        } else if (offhand.m_41720_() instanceof BannerItem) {
            heldBanner = offhand;
        }
        return heldBanner;
    }

    private void updateButtons() {
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((Player)this.f_96541_.f_91074_);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontier, playerUser);
        this.textName1.m_94186_(actions.canUpdate);
        this.textName2.m_94186_(actions.canUpdate);
        this.buttonVisible.f_93623_ = actions.canUpdate;
        this.buttonFullscreenVisible.f_93623_ = actions.canUpdate;
        this.buttonFullscreenNameVisible.f_93623_ = actions.canUpdate;
        this.buttonFullscreenOwnerVisible.f_93623_ = actions.canUpdate;
        this.buttonMinimapVisible.f_93623_ = actions.canUpdate;
        this.buttonMinimapNameVisible.f_93623_ = actions.canUpdate;
        this.buttonMinimapOwnerVisible.f_93623_ = actions.canUpdate;
        this.buttonAnnounceInChat.f_93623_ = actions.canUpdate;
        this.buttonAnnounceInTitle.f_93623_ = actions.canUpdate;
        this.textRed.m_94186_(actions.canUpdate);
        this.textGreen.m_94186_(actions.canUpdate);
        this.textBlue.m_94186_(actions.canUpdate);
        this.buttonRandomColor.f_93624_ = actions.canUpdate;
        this.colorPicker.f_93623_ = actions.canUpdate;
        this.buttonPaste.f_93623_ = actions.canUpdate;
        this.buttonOpenPasteOptions.f_93623_ = actions.canUpdate;
        this.buttonClosePasteOptions.f_93623_ = actions.canUpdate;
        this.buttonDelete.f_93624_ = actions.canDelete;
        this.buttonBanner.f_93624_ = actions.canUpdate;
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        this.buttonSelect.f_93624_ = uiState != null && this.frontier.getDimension().equals((Object)uiState.dimension);
        this.buttonShareSettings.f_93624_ = actions.canShare;
    }

    private void updatePasteOptionsVisibility() {
        this.buttonPaste.f_93624_ = MapFrontiersClient.getClipboard() != null;
        this.buttonOpenPasteOptions.f_93624_ = this.buttonPaste.f_93624_ && !Config.pasteOptionsVisible;
        this.buttonClosePasteOptions.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.buttonPasteName.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.buttonPasteVisibility.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.buttonPasteColor.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.buttonPasteBanner.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.labelPasteName.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.labelPasteVisibility.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.labelPasteColor.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
        this.labelPasteBanner.f_93624_ = this.buttonPaste.f_93624_ && Config.pasteOptionsVisible;
    }

    private void updateUndoRedoVisibility() {
        this.buttonUndo.f_93624_ = this.buttonPaste.f_93623_ && this.undoStack.size() > 1;
        this.buttonRedo.f_93624_ = this.buttonPaste.f_93623_ && this.redoStack.size() > 0;
    }

    private void sendChangesToServer() {
        this.frontiersOverlayManager.clientUpdatefrontier(this.frontier);
    }

    private void addToUndo(FrontierData frontier) {
        FrontierData u;
        boolean add = this.undoStack.empty();
        if (!(add || Objects.equals((u = this.undoStack.peek()).getName1(), frontier.getName1()) && Objects.equals(u.getName2(), frontier.getName2()) && u.getVisible() == frontier.getVisible() && u.getFullscreenVisible() == frontier.getFullscreenVisible() && u.getFullscreenNameVisible() == frontier.getFullscreenNameVisible() && u.getFullscreenOwnerVisible() == frontier.getFullscreenOwnerVisible() && u.getMinimapVisible() == frontier.getMinimapVisible() && u.getMinimapNameVisible() == frontier.getMinimapNameVisible() && u.getMinimapOwnerVisible() == frontier.getMinimapOwnerVisible() && u.getAnnounceInChat() == frontier.getAnnounceInChat() && u.getAnnounceInTitle() == frontier.getAnnounceInTitle() && u.getColor() == frontier.getColor() && Objects.equals(u.getbannerData(), frontier.getbannerData()))) {
            add = true;
        }
        if (add) {
            this.undoStack.push(frontier);
            if (!this.redoStack.empty()) {
                this.redoStack.clear();
            }
            this.updateUndoRedoVisibility();
        }
    }
}

