/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class TextBoxUser
extends TextBox {
    private final Minecraft mc;
    private final Font font;
    private String partialText;
    private final List<String> suggestions;
    private final List<String> suggestionsToDraw;
    private Component error;
    private int maxSuggestionWidth = 0;
    private int suggestionIndex = 0;

    public TextBoxUser(Minecraft mc, Font font, int x, int y, int width) {
        this(mc, font, x, y, width, "");
    }

    public TextBoxUser(Minecraft mc, Font font, int x, int y, int width, String defaultText) {
        super(font, x, y, width, defaultText);
        this.mc = mc;
        this.font = font;
        this.suggestions = new ArrayList<String>();
        this.suggestionsToDraw = new ArrayList<String>();
        this.setError(null);
    }

    public void setError(@Nullable Component error) {
        this.error = error;
        if (this.error != null) {
            this.suggestions.clear();
            this.suggestionsToDraw.clear();
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 342) {
            if (this.suggestions.isEmpty()) {
                this.suggestionIndex = 0;
                ClientPacketListener handler = this.mc.m_91403_();
                if (!StringUtils.isBlank((CharSequence)this.m_94155_()) && handler != null) {
                    this.partialText = this.m_94155_();
                    for (PlayerInfo playerInfo : handler.m_105142_()) {
                        String name = playerInfo.m_105312_().getName();
                        if (name == null || !name.regionMatches(true, 0, this.partialText, 0, this.partialText.length())) continue;
                        this.suggestions.add(name);
                    }
                }
            } else {
                ++this.suggestionIndex;
                if (this.suggestionIndex >= this.suggestions.size()) {
                    this.suggestionIndex = 0;
                }
            }
            this.suggestionsToDraw.clear();
            if (!this.suggestions.isEmpty()) {
                this.m_94144_(this.suggestions.get(this.suggestionIndex));
                if (this.suggestions.size() == 1) {
                    this.suggestions.clear();
                } else {
                    this.maxSuggestionWidth = 0;
                    int size = this.suggestions.size();
                    if (size > 7) {
                        size = 7;
                    }
                    int firstIndex = 0;
                    if (this.suggestionIndex > 6) {
                        firstIndex = this.suggestionIndex - 6;
                    }
                    for (int i = firstIndex; i < firstIndex + size; ++i) {
                        this.suggestionsToDraw.add(this.suggestions.get(i));
                        int textWidth = this.font.m_92895_(this.suggestions.get(i));
                        if (textWidth <= this.maxSuggestionWidth) continue;
                        this.maxSuggestionWidth = textWidth;
                    }
                }
            }
            return true;
        }
        this.suggestions.clear();
        this.suggestionsToDraw.clear();
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        block7: {
            block6: {
                if (this.error == null) {
                    this.m_94202_(-2039584);
                } else {
                    this.m_94202_(-2289391);
                }
                super.m_87963_(graphics, mouseX, mouseY, partialTicks);
                if (this.error == null) break block6;
                List errorList = this.font.m_92923_((FormattedText)this.error, this.f_93618_ - 8);
                int maxErrorWidth = this.f_93618_ - 8;
                graphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - errorList.size() * 12 - 5, this.m_252754_() + maxErrorWidth + 9, this.m_252907_() - 1, -6250336);
                graphics.m_280509_(this.m_252754_(), this.m_252907_() - errorList.size() * 12 - 4, this.m_252754_() + maxErrorWidth + 8, this.m_252907_() - 1, -16777216);
                int posX = this.m_252754_() + 4;
                int posY = this.m_252907_() - errorList.size() * 12;
                for (FormattedCharSequence e : errorList) {
                    graphics.m_280648_(this.font, e, posX, posY, -1);
                    posY += 12;
                }
                break block7;
            }
            if (this.suggestionsToDraw.isEmpty()) break block7;
            graphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - this.suggestionsToDraw.size() * 12 - 5, this.m_252754_() + this.maxSuggestionWidth + 9, this.m_252907_() - 1, -6250336);
            graphics.m_280509_(this.m_252754_(), this.m_252907_() - this.suggestionsToDraw.size() * 12 - 4, this.m_252754_() + this.maxSuggestionWidth + 8, this.m_252907_() - 1, -16777216);
            int posX = this.m_252754_() + 4;
            int posY = this.m_252907_() - 12;
            for (int i = this.suggestionsToDraw.size() - 1; i >= 0; --i) {
                String t = this.suggestionsToDraw.get(i);
                if (this.suggestionsToDraw.get(i) == this.suggestions.get(this.suggestionIndex)) {
                    graphics.m_280488_(this.font, t, posX, posY, -1);
                } else {
                    String suffix = t.substring(0, this.partialText.length());
                    String rest = t.substring(this.partialText.length());
                    graphics.m_280488_(this.font, suffix, posX, posY, -1);
                    graphics.m_280488_(this.font, rest, posX + this.font.m_92895_(suffix), posY, 0xAAAAAA);
                }
                posY -= 12;
            }
        }
    }

    @Override
    public void m_93692_(boolean isFocusedIn) {
        super.m_93692_(isFocusedIn);
        if (!isFocusedIn) {
            this.suggestions.clear();
            this.suggestionsToDraw.clear();
        }
        this.setError(null);
    }
}

