/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class TextBox
extends EditBox {
    private final String defaultText;
    private Consumer<String> valueChangedCallback;
    private Consumer<String> lostFocusCallback;

    public TextBox(Font font, int x, int y, int width) {
        this(font, x, y, width, "");
    }

    public TextBox(Font font, int x, int y, int width, String defaultText) {
        super(font, x, y, width, 12, (Component)Component.m_237119_());
        this.defaultText = defaultText;
        if (!StringUtils.isBlank((CharSequence)defaultText)) {
            this.m_94151_(value -> this.updateDefaultText());
        }
        this.updateDefaultText();
    }

    public void setValueChangedCallback(Consumer<String> callback) {
        this.valueChangedCallback = callback;
        if (StringUtils.isBlank((CharSequence)this.defaultText)) {
            this.m_94151_(value -> this.valueChangedCallback.accept((String)value));
        } else {
            this.m_94151_(value -> {
                this.updateDefaultText();
                this.valueChangedCallback.accept((String)value);
            });
        }
    }

    public void setLostFocusCallback(Consumer<String> callback) {
        this.lostFocusCallback = callback;
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public boolean m_5534_(char c, int key) {
        boolean res = false;
        if (this.f_93623_ && this.m_198029_() && (res = super.m_5534_(c, key)) && this.valueChangedCallback != null) {
            this.valueChangedCallback.accept(this.m_94155_());
        }
        return res;
    }

    public void m_94144_(String value) {
        super.m_94144_(value);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean res = false;
        if (this.f_93623_ && this.m_198029_()) {
            res = super.m_7933_(keyCode, scanCode, modifiers);
            if (keyCode == 257 || keyCode == 335) {
                this.m_93692_(false);
            }
        }
        return res;
    }

    public void m_93692_(boolean isFocusedIn) {
        if (this.m_93696_() && !isFocusedIn && this.lostFocusCallback != null) {
            this.lostFocusCallback.accept(this.m_94155_());
        }
        super.m_93692_(isFocusedIn);
    }

    private void updateDefaultText() {
        if (this.m_94155_().isEmpty()) {
            this.m_94167_(this.defaultText);
        } else {
            this.m_94167_("");
        }
    }
}

