/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.screens.Screen;

@ParametersAreNonnullByDefault
public class UserElement
extends ScrollBox.ScrollElement {
    private final Font font;
    private final SettingsUser user;
    private final IconButton buttonDelete;
    private int pingBar = 0;
    private final Screen screen;

    public UserElement(Font font, Screen screen, SettingsUser user) {
        super(258, 16);
        this.font = font;
        this.user = user;
        this.screen = screen;
        this.buttonDelete = new IconButton(0, 0, IconButton.Type.Remove, button -> {});
        Services.PLATFORM.addButtonToScreen((AbstractButton)this.buttonDelete, screen);
    }

    @Override
    public void delete() {
        Services.PLATFORM.removeButtonOfScreen((AbstractButton)this.buttonDelete, this.screen);
    }

    public SettingsUser getUser() {
        return this.user;
    }

    public void setPingBar(int value) {
        this.pingBar = value;
        if (this.pingBar < 0) {
            this.pingBar = 0;
        } else if (this.pingBar > 5) {
            this.pingBar = 5;
        }
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.buttonDelete.m_252865_(this.x + 243);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.buttonDelete.m_253211_(this.y + 1);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
        int color = -2236963;
        if (selected) {
            color = -1;
        }
        if (this.isHovered) {
            graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, -1608375774);
            this.buttonDelete.f_93624_ = true;
        } else {
            this.buttonDelete.f_93624_ = false;
        }
        graphics.m_280488_(this.font, this.user.toString(), this.x + 4, this.y + 4, color);
        if (this.pingBar > 0) {
            this.drawPingLine(graphics, this.x - 11, this.y + 11, 2);
        }
        if (this.pingBar > 1) {
            this.drawPingLine(graphics, this.x - 9, this.y + 11, 3);
        }
        if (this.pingBar > 2) {
            this.drawPingLine(graphics, this.x - 7, this.y + 11, 4);
        }
        if (this.pingBar > 3) {
            this.drawPingLine(graphics, this.x - 5, this.y + 11, 5);
        }
        if (this.pingBar > 4) {
            this.drawPingLine(graphics, this.x - 3, this.y + 11, 6);
        }
    }

    private void drawPingLine(GuiGraphics graphics, int posX, int posY, int height) {
        graphics.m_280509_(posX, posY - height, posX + 1, posY, -1);
    }

    @Override
    public ScrollBox.ScrollElement.Action mousePressed(double mouseX, double mouseY) {
        if (this.visible && this.isHovered) {
            if (this.buttonDelete.m_5953_(mouseX, mouseY)) {
                return ScrollBox.ScrollElement.Action.Deleted;
            }
            return ScrollBox.ScrollElement.Action.Clicked;
        }
        return ScrollBox.ScrollElement.Action.None;
    }
}

