/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class OptionButton
extends Button {
    protected final Font font;
    private final List<Component> options;
    private int selected = 0;
    private int color = -2236963;
    private int highlightedColor = -1;

    public OptionButton(Font font, int x, int y, int width, Button.OnPress pressedAction) {
        super(x, y, width, 12, (Component)Component.m_237119_(), pressedAction, Button.f_252438_);
        this.font = font;
        this.options = new ArrayList<Component>();
    }

    public void addOption(Component text) {
        this.options.add(text);
    }

    public void setSelected(int selected) {
        if (selected < 0) {
            selected = 0;
        } else if (selected >= this.options.size()) {
            selected = this.options.size() - 1;
        }
        this.selected = selected;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setColor(int color, int highlightedColor) {
        this.color = color;
        this.highlightedColor = highlightedColor;
    }

    public int getColor() {
        return this.color;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_93624_ && this.f_93622_) {
            if (delta > 0.0) {
                ++this.selected;
                if (this.selected >= this.options.size()) {
                    this.selected = 0;
                }
            } else {
                --this.selected;
                if (this.selected < 0) {
                    this.selected = this.options.size() - 1;
                }
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.m_5691_();
            return true;
        }
        return false;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int c = this.color;
        if (!this.f_93623_) {
            c = -8947849;
        } else if (this.f_93622_) {
            c = this.highlightedColor;
        }
        graphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, -6250336);
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
        graphics.m_280430_(this.font, this.options.get(this.selected), this.m_252754_() + 4, this.m_252907_() + 2, c);
    }

    public void m_5716_(double mouseX, double mouseY) {
        ++this.selected;
        if (this.selected >= this.options.size()) {
            this.selected = 0;
        }
        this.m_5691_();
    }
}

