/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

@ParametersAreNonnullByDefault
public class FrontierOverlay
extends FrontierData {
    private static final MapImage markerVertex = new MapImage(new ResourceLocation("mapfrontiers:textures/gui/marker.png"), 0, 0, 12, 12, -1, 1.0f);
    private static final MapImage markerDot = new MapImage(new ResourceLocation("mapfrontiers:textures/gui/marker.png"), 12, 0, 8, 8, -1, 1.0f);
    public BlockPos topLeft;
    public BlockPos bottomRight;
    public float perimeter = 0.0f;
    public float area = 0.0f;
    private int vertexSelected = -1;
    private boolean highlighted = false;
    private final IClientAPI jmAPI;
    private final List<PolygonOverlay> polygonOverlays = new ArrayList<PolygonOverlay>();
    private Area polygonArea;
    private final List<MarkerOverlay> markerOverlays = new ArrayList<MarkerOverlay>();
    private String displayId;
    private BannerDisplayData bannerDisplay;
    private int hash;
    private boolean dirtyhash = true;
    private boolean needUpdateOverlay = true;

    public FrontierOverlay(FrontierData data, @Nullable IClientAPI jmAPI) {
        super(data);
        this.jmAPI = jmAPI;
        this.displayId = "frontier_" + this.id.toString();
        this.updateOverlay();
        if (this.banner != null) {
            this.bannerDisplay = new BannerDisplayData(this.banner);
        }
    }

    @Override
    public void updateFromData(FrontierData other) {
        super.updateFromData(other);
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = this.vertices.size() - 1;
        }
        if (other.hasChange(FrontierData.Change.Name) || other.hasChange(FrontierData.Change.Vertices) || other.hasChange(FrontierData.Change.Other)) {
            this.updateOverlay();
        }
        if (other.hasChange(FrontierData.Change.Banner)) {
            this.bannerDisplay = this.banner == null ? null : new BannerDisplayData(this.banner);
            this.dirtyhash = true;
        }
    }

    public int getHash() {
        if (this.dirtyhash) {
            this.dirtyhash = false;
            int prime = 31;
            this.hash = 1;
            this.hash = prime * this.hash + this.id.hashCode();
            this.hash = prime * this.hash + this.color;
            this.hash = prime * this.hash + (this.dimension == null ? 0 : this.dimension.hashCode());
            this.hash = prime * this.hash + (this.name1 == null ? 0 : this.name1.hashCode());
            this.hash = prime * this.hash + (this.name2 == null ? 0 : this.name2.hashCode());
            this.hash = prime * this.hash + (this.visible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.fullscreenVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.fullscreenNameVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.fullscreenOwnerVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.minimapVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.minimapNameVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.minimapOwnerVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.announceInChat ? 1231 : 1237);
            this.hash = prime * this.hash + (this.announceInTitle ? 1231 : 1237);
            this.hash = prime * this.hash + (this.vertices == null ? 0 : this.vertices.hashCode());
            this.hash = prime * this.hash + (this.chunks == null ? 0 : this.chunks.hashCode());
            this.hash = prime * this.hash + this.mode.ordinal();
            this.hash = prime * this.hash + (this.banner == null ? 0 : this.banner.hashCode());
            this.hash = prime * this.hash + (this.usersShared == null ? 0 : this.usersShared.hashCode());
        }
        return this.hash;
    }

    public void updateOverlayIfNeeded() {
        if (this.needUpdateOverlay) {
            this.needUpdateOverlay = false;
            this.updateOverlay();
        }
    }

    public void updateOverlay() {
        this.dirtyhash = true;
        if (this.jmAPI == null) {
            return;
        }
        this.removeOverlay();
        this.recalculateOverlays();
        if (this.visible) {
            try {
                for (PolygonOverlay polygon : this.polygonOverlays) {
                    this.jmAPI.show((Displayable)polygon);
                }
                for (MarkerOverlay marker : this.markerOverlays) {
                    this.jmAPI.show((Displayable)marker);
                }
            }
            catch (Throwable t) {
                MapFrontiers.LOGGER.error(t.getMessage(), t);
            }
        }
    }

    public void removeOverlay() {
        for (PolygonOverlay polygon : this.polygonOverlays) {
            this.jmAPI.remove((Displayable)polygon);
        }
        for (MarkerOverlay marker : this.markerOverlays) {
            this.jmAPI.remove((Displayable)marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pointIsInside(BlockPos pos, double maxDistanceToOpen) {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.size() > 2) {
                return this.polygonArea != null && this.polygonArea.contains((double)pos.m_123341_() + 0.5, (double)pos.m_123343_() + 0.5);
            }
            if (maxDistanceToOpen > 0.0) {
                List list = this.vertices;
                synchronized (list) {
                    for (int i = 0; i < this.vertices.size(); ++i) {
                        Vec3 point = Vec3.m_82528_((Vec3i)pos);
                        int y1 = pos.m_123342_();
                        Vec3 edge1 = Vec3.m_82528_((Vec3i)((BlockPos)this.vertices.get(i)).m_175288_(y1));
                        int y = pos.m_123342_();
                        Vec3 edge2 = Vec3.m_82528_((Vec3i)((BlockPos)this.vertices.get((i + 1) % this.vertices.size())).m_175288_(y));
                        double distance = FrontierOverlay.closestPointToEdge(point, edge1, edge2).m_82557_(point);
                        if (!(distance <= maxDistanceToOpen * maxDistanceToOpen)) continue;
                        return true;
                    }
                }
            }
        } else if (pos.m_123341_() >= this.topLeft.m_123341_() && pos.m_123341_() <= this.bottomRight.m_123341_() && pos.m_123343_() >= this.topLeft.m_123343_() && pos.m_123343_() <= this.bottomRight.m_123343_()) {
            return this.chunks.contains(new ChunkPos(pos));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestVertex(BlockPos pos, double limit) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = limit * limit;
        int closest = -1;
        if (!this.vertices.isEmpty()) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    int y;
                    BlockPos vertex = (BlockPos)this.vertices.get(i);
                    double dist = vertex.m_123331_((Vec3i)pos.m_175288_(y = vertex.m_123342_()));
                    if (!(dist <= distance)) continue;
                    distance = dist;
                    closest = i;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestEdge(BlockPos pos) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = Double.MAX_VALUE;
        int closest = -1;
        double angleSimilarity = -1.0;
        if (this.vertices.size() == 1) {
            closest = 0;
        } else if (this.vertices.size() > 1) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    double dist;
                    double dot;
                    Vec3 point = Vec3.m_82528_((Vec3i)pos);
                    int y1 = pos.m_123342_();
                    Vec3 edge1 = Vec3.m_82528_((Vec3i)((BlockPos)this.vertices.get(i)).m_175288_(y1));
                    int y = pos.m_123342_();
                    Vec3 edge2 = Vec3.m_82528_((Vec3i)((BlockPos)this.vertices.get((i + 1) % this.vertices.size())).m_175288_(y));
                    if (edge1.equals((Object)edge2)) {
                        dot = -1.0;
                        dist = point.m_82557_(edge1);
                    } else {
                        Vec3 closestPoint = FrontierOverlay.closestPointToEdge(point, edge1, edge2);
                        if (!closestPoint.equals((Object)edge1) && !closestPoint.equals((Object)edge2)) {
                            dot = -1.0;
                        } else {
                            Vec3 toPos;
                            Vec3 edge = edge2.m_82546_(edge1);
                            Vec2 edgeDirection = new Vec2((float)edge.f_82479_, (float)edge.f_82481_).m_165902_();
                            if (closestPoint.equals((Object)edge1)) {
                                toPos = point.m_82546_(edge1);
                            } else {
                                edgeDirection = edgeDirection.m_165913_();
                                toPos = point.m_82546_(edge2);
                            }
                            Vec2 toPosDirection = new Vec2((float)toPos.f_82479_, (float)toPos.f_82481_).m_165902_();
                            dot = toPosDirection.m_165905_(edgeDirection);
                        }
                        dist = point.m_82557_(closestPoint);
                    }
                    if (dist < distance) {
                        distance = dist;
                        closest = i;
                        angleSimilarity = dot;
                        continue;
                    }
                    if (dist != distance || !(dot > angleSimilarity)) continue;
                    closest = i;
                    angleSimilarity = dot;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    private static Vec3 closestPointToEdge(Vec3 point, Vec3 edge1, Vec3 edge2) {
        Vec3 edge = edge2.m_82546_(edge1);
        if (edge.f_82479_ == 0.0 && edge.f_82481_ == 0.0) {
            return edge1;
        }
        double u = ((point.f_82479_ - edge1.f_82479_) * edge.f_82479_ + (point.f_82481_ - edge1.f_82481_) * edge.f_82481_) / (edge.f_82479_ * edge.f_82479_ + edge.f_82481_ * edge.f_82481_);
        if (u < 0.0) {
            return edge1;
        }
        if (u > 1.0) {
            return edge2;
        }
        return new Vec3(edge1.f_82479_ + u * edge.f_82479_, point.f_82480_, edge1.f_82481_ + u * edge.f_82481_);
    }

    @Override
    public void setId(UUID id) {
        super.setId(id);
        this.displayId = "frontier_" + id;
        this.needUpdateOverlay = true;
    }

    @Override
    public void addVertex(BlockPos pos) {
        this.addVertex(pos, this.vertexSelected + 1, Config.snapDistance);
        this.selectNextVertex();
    }

    public void addVertex(BlockPos pos, int index, int snapDistance) {
        if (snapDistance != 0) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.addVertex(pos, index);
        this.needUpdateOverlay = true;
    }

    @Override
    public void removeVertex(int index) {
        super.removeVertex(index);
        this.needUpdateOverlay = true;
    }

    @Override
    public boolean toggleChunk(ChunkPos chunk) {
        boolean added = super.toggleChunk(chunk);
        this.needUpdateOverlay = true;
        return added;
    }

    @Override
    public boolean addChunk(ChunkPos chunk) {
        if (super.addChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeChunk(ChunkPos chunk) {
        if (super.removeChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    public void moveSelectedVertex(BlockPos pos, float snapDistance) {
        if (this.vertexSelected < 0 || this.vertexSelected >= this.vertices.size()) {
            return;
        }
        if (snapDistance != 0.0f) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.moveVertex(pos, this.vertexSelected);
        this.needUpdateOverlay = true;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    @Override
    public void setName1(String name) {
        super.setName1(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setName2(String name) {
        super.setName2(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.vertexSelected = -1;
        }
        this.needUpdateOverlay = true;
    }

    @Override
    public void setFullscreenVisible(boolean visible) {
        super.setFullscreenVisible(visible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setFullscreenNameVisible(boolean nameVisible) {
        super.setFullscreenNameVisible(nameVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setFullscreenOwnerVisible(boolean ownerVisible) {
        super.setFullscreenOwnerVisible(ownerVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setMinimapVisible(boolean visible) {
        super.setMinimapVisible(visible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setMinimapNameVisible(boolean nameVisible) {
        super.setMinimapNameVisible(nameVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setMinimapOwnerVisible(boolean ownerVisible) {
        super.setMinimapOwnerVisible(ownerVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setDimension(ResourceKey<Level> dimension) {
        super.setDimension(dimension);
        this.dirtyhash = true;
    }

    @Override
    public void setBanner(@Nullable ItemStack itemBanner) {
        super.setBanner(itemBanner);
        this.needUpdateOverlay = true;
        this.bannerDisplay = itemBanner == null ? null : new BannerDisplayData(this.banner);
    }

    @Override
    public void setBannerData(@Nullable FrontierData.BannerData bannerData) {
        super.setBannerData(bannerData);
        this.needUpdateOverlay = true;
        this.bannerDisplay = bannerData == null ? null : new BannerDisplayData(this.banner);
    }

    @Override
    public void addUserShared(SettingsUserShared userShared) {
        super.addUserShared(userShared);
        this.dirtyhash = true;
    }

    @Override
    public void removeUserShared(int index) {
        super.removeUserShared(index);
        this.dirtyhash = true;
    }

    @Override
    public void setUsersShared(List<SettingsUserShared> usersShared) {
        super.setUsersShared(usersShared);
        this.dirtyhash = true;
    }

    public BlockPos getClosestVertex(BlockPos vertex, double belowDistance) {
        BlockPos closest = null;
        double closestDistance = belowDistance;
        for (PolygonOverlay overlay : this.polygonOverlays) {
            for (BlockPos v : overlay.getOuterArea().getPoints()) {
                double distance = v.m_123331_((Vec3i)vertex);
                if (!(distance <= closestDistance)) continue;
                closestDistance = distance;
                closest = v;
            }
            if (overlay.getHoles() == null) continue;
            for (MapPolygon hole : overlay.getHoles()) {
                for (BlockPos v : hole.getPoints()) {
                    double distance = v.m_123331_((Vec3i)vertex);
                    if (!(distance <= closestDistance)) continue;
                    closestDistance = distance;
                    closest = v;
                }
            }
        }
        return closest;
    }

    public void renderBanner(Minecraft mc, GuiGraphics graphics, int x, int y, int scale) {
        if (this.bannerDisplay == null) {
            return;
        }
        for (int i = 0; i < this.bannerDisplay.patternList.size(); ++i) {
            BannerPattern pattern = this.bannerDisplay.patternList.get(i);
            Optional patternResource = BuiltInRegistries.f_256878_.m_7854_((Object)pattern);
            if (patternResource.isEmpty()) continue;
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.m_91258_(Sheets.f_110737_).apply(BannerPattern.m_222697_((ResourceKey)((ResourceKey)patternResource.get()), (boolean)true));
            RenderSystem.setShader(GameRenderer::m_172814_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Sheets.f_110737_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buf = tessellator.m_85915_();
            float[] colors = this.bannerDisplay.colorList.get(i).m_41068_();
            int width = 22 * scale;
            int height = 40 * scale;
            float zLevel = 0.0f;
            float u1 = sprite.m_118409_();
            float u2 = sprite.m_118409_() + 0.04296875f;
            float v1 = sprite.m_118411_() + 0.001953125f;
            float v2 = sprite.m_118411_() + 0.080078125f;
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
            buf.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_7421_(u1, v2).m_5752_();
            buf.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_7421_(u2, v2).m_5752_();
            buf.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_7421_(u2, v1).m_5752_();
            buf.m_252986_(matrix, (float)x, (float)y, zLevel).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_7421_(u1, v1).m_5752_();
            tessellator.m_85914_();
            RenderSystem.disableBlend();
        }
    }

    public void removeSelectedVertex() {
        if (this.vertexSelected < 0) {
            return;
        }
        super.removeVertex(this.vertexSelected);
        this.vertexSelected = this.vertices.size() == 0 ? -1 : (this.vertexSelected > 0 ? --this.vertexSelected : this.vertices.size() - 1);
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
        this.needUpdateOverlay = true;
    }

    public void selectNextVertex() {
        ++this.vertexSelected;
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = -1;
        }
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    public int getSelectedVertexIndex() {
        return this.vertexSelected;
    }

    public BlockPos getSelectedVertex() {
        if (this.vertexSelected >= 0 && this.vertexSelected < this.vertices.size()) {
            return (BlockPos)this.vertices.get(this.vertexSelected);
        }
        return null;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.needUpdateOverlay = true;
    }

    public BlockPos getCenter() {
        return new BlockPos((this.topLeft.m_123341_() + this.bottomRight.m_123341_()) / 2, 70, (this.topLeft.m_123343_() + this.bottomRight.m_123343_()) / 2);
    }

    private BlockPos snapVertex(BlockPos vertex, float snapDistance) {
        BlockPos v;
        BlockPos closest = vertex.m_175288_(70);
        double closestDistance = snapDistance * snapDistance;
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers((ResourceKey<Level>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(closest, closestDistance)) == null) continue;
            closest = v;
            closestDistance = v.m_123331_((Vec3i)vertex);
        }
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers((ResourceKey<Level>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(closest, closestDistance)) == null) continue;
            closest = v;
            closestDistance = v.m_123331_((Vec3i)vertex);
        }
        return closest;
    }

    private void recalculateOverlays() {
        this.polygonOverlays.clear();
        this.markerOverlays.clear();
        this.updateBounds();
        this.area = 0.0f;
        this.perimeter = 0.0f;
        this.polygonArea = null;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(this.highlighted ? 3.0f : 0.0f).setStrokeColor(-1).setFillColor(this.color).setFillOpacity((float)Config.polygonsOpacity);
        if (this.mode == FrontierData.Mode.Vertex) {
            this.recalculateVertices(shapeProps);
        } else {
            this.recalculateChunks(shapeProps);
        }
    }

    private void addPolygonOverlays(String id, ShapeProperties shapeProps, MapPolygon polygon, @Nullable List<MapPolygon> polygonHoles) {
        PolygonOverlay polygonOverlay = null;
        PolygonOverlay polygonOverlayFullscreen = null;
        PolygonOverlay polygonOverlayMinimap = null;
        boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.fullscreenVisible);
        boolean fullscreenNameV = Config.getVisibilityValue(Config.fullscreenNameVisibility, this.fullscreenNameVisible);
        boolean fullscreenOwnerV = Config.getVisibilityValue(Config.fullscreenOwnerVisibility, this.fullscreenOwnerVisible);
        boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.minimapVisible);
        boolean minimapNameV = Config.getVisibilityValue(Config.minimapNameVisibility, this.minimapNameVisible);
        boolean minimapOwnerV = Config.getVisibilityValue(Config.minimapOwnerVisibility, this.minimapOwnerVisible);
        if (fullscreenV && minimapV && fullscreenNameV == minimapNameV && fullscreenOwnerV == minimapOwnerV) {
            polygonOverlay = new PolygonOverlay("mapfrontiers", id, this.dimension, shapeProps, polygon, polygonHoles);
            polygonOverlay.setActiveUIs(EnumSet.of(Context.UI.Any));
        } else {
            if (fullscreenV) {
                polygonOverlayFullscreen = new PolygonOverlay("mapfrontiers", id + "_fullscreen", this.dimension, shapeProps, polygon, polygonHoles);
                polygonOverlayFullscreen.setActiveUIs(EnumSet.of(Context.UI.Fullscreen));
            }
            if (minimapV) {
                polygonOverlayMinimap = new PolygonOverlay("mapfrontiers", id + "_minimap", this.dimension, shapeProps, polygon, polygonHoles);
                polygonOverlayMinimap.setActiveUIs(EnumSet.of(Context.UI.Minimap, Context.UI.Webmap));
            }
        }
        if (polygonOverlay != null) {
            this.addNameAndOwner(polygonOverlay, fullscreenNameV, fullscreenOwnerV);
            this.polygonOverlays.add(polygonOverlay);
        } else {
            if (polygonOverlayFullscreen != null) {
                this.addNameAndOwner(polygonOverlayFullscreen, fullscreenNameV, fullscreenOwnerV);
                this.polygonOverlays.add(polygonOverlayFullscreen);
            }
            if (polygonOverlayMinimap != null) {
                this.addNameAndOwner(polygonOverlayMinimap, minimapNameV, minimapOwnerV);
                this.polygonOverlays.add(polygonOverlayMinimap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateVertices(ShapeProperties shapeProps) {
        List list = this.vertices;
        synchronized (list) {
            if (this.vertices.size() > 2) {
                MapPolygon polygon = new MapPolygon(this.vertices);
                this.addPolygonOverlays(this.displayId, shapeProps, polygon, null);
                this.polygonArea = PolygonHelper.toArea((MapPolygon)polygon);
                BlockPos last = (BlockPos)this.vertices.get(this.vertices.size() - 1);
                for (BlockPos vertex : this.vertices) {
                    this.area += (float)Math.abs(vertex.m_123343_() + last.m_123343_()) / 2.0f * (float)(vertex.m_123341_() - last.m_123341_());
                    last = vertex;
                }
                this.area = Math.abs(this.area);
            } else {
                boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.fullscreenVisible);
                boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.minimapVisible);
                if (fullscreenV || minimapV) {
                    EnumSet<Context.UI> ui = fullscreenV && minimapV ? EnumSet.of(Context.UI.Any) : (fullscreenV ? EnumSet.of(Context.UI.Fullscreen) : EnumSet.of(Context.UI.Minimap, Context.UI.Webmap));
                    for (int i = 0; i < this.vertices.size(); ++i) {
                        String markerId = this.displayId + "_" + i;
                        MarkerOverlay marker = new MarkerOverlay("mapfrontiers", markerId, (BlockPos)this.vertices.get(i), markerVertex);
                        marker.setDimension(this.dimension);
                        marker.setDisplayOrder(100);
                        marker.setActiveUIs(ui);
                        this.markerOverlays.add(marker);
                        if (i != 0 || this.vertices.size() != 2) continue;
                        this.addMarkerDots(markerId, (BlockPos)this.vertices.get(0), (BlockPos)this.vertices.get(1));
                    }
                }
            }
            if (this.vertices.size() > 1) {
                BlockPos last = (BlockPos)this.vertices.get(this.vertices.size() - 1);
                for (BlockPos vertex : this.vertices) {
                    this.perimeter = (float)((double)this.perimeter + Math.sqrt(vertex.m_123331_((Vec3i)last)));
                    last = vertex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateChunks(ShapeProperties shapeProps) {
        HashMultimap edges = HashMultimap.create();
        Set set = this.chunks;
        synchronized (set) {
            for (ChunkPos chunk : this.chunks) {
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.f_45578_, chunk.f_45579_), new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_));
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_), new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_ + 1));
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_ + 1), new ChunkPos(chunk.f_45578_, chunk.f_45579_ + 1));
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.f_45578_, chunk.f_45579_ + 1), new ChunkPos(chunk.f_45578_, chunk.f_45579_));
            }
        }
        ArrayList outerPolygons = new ArrayList();
        HashMultimap holesPolygons = HashMultimap.create();
        while (!edges.isEmpty()) {
            boolean clockwise;
            ChunkPos edge2;
            ChunkPos starting = (ChunkPos)Collections.min(edges.keySet(), (e1, e2) -> e1.f_45578_ == e2.f_45578_ ? e1.f_45579_ - e2.f_45579_ : e1.f_45578_ - e2.f_45578_);
            ArrayList<ChunkPos> arrayList = new ArrayList<ChunkPos>();
            Object edge = starting;
            int direction = 1;
            do {
                arrayList.add((ChunkPos)edge);
                Iterator it = edges.get(edge).iterator();
                edge2 = (ChunkPos)it.next();
                while (it.hasNext() && Integer.signum(direction) == Integer.signum(edge2.f_45578_ - ((ChunkPos)edge).f_45578_ + ((ChunkPos)edge).f_45579_ - edge2.f_45579_)) {
                    edge2 = (ChunkPos)it.next();
                }
                edges.remove(edge, (Object)edge2);
                direction = edge2.f_45578_ - ((ChunkPos)edge).f_45578_ + edge2.f_45579_ - ((ChunkPos)edge).f_45579_;
            } while (!(edge = edge2).equals((Object)starting));
            this.perimeter += (float)(arrayList.size() * 16);
            boolean bl = clockwise = ((ChunkPos)arrayList.get((int)0)).f_45578_ != ((ChunkPos)arrayList.get((int)1)).f_45578_;
            if (clockwise) {
                outerPolygons.add(arrayList);
                continue;
            }
            ChunkPos ray = (ChunkPos)arrayList.get(0);
            ChunkPos outerFound = null;
            for (int i = 0; i < 999; ++i) {
                for (List list : outerPolygons) {
                    ChunkPos outerStart = (ChunkPos)list.get(0);
                    if (list.contains(ray)) {
                        outerFound = outerStart;
                        break;
                    }
                    for (List hole : holesPolygons.get((Object)outerStart)) {
                        if (!hole.contains(ray)) continue;
                        outerFound = outerStart;
                        break;
                    }
                    if (outerFound == null) continue;
                    break;
                }
                if (outerFound != null) break;
                ray = new ChunkPos(ray.f_45578_ - 1, ray.f_45579_);
            }
            if (outerFound != null) {
                holesPolygons.put(outerFound, arrayList);
                continue;
            }
            MapFrontiers.LOGGER.warn(String.format("Frontier %1$s is too large and the polygon corresponding to the hole %2$s could not be located", this.id, arrayList.get(0)));
        }
        for (List list : outerPolygons) {
            FrontierOverlay.removeCollinear(list);
            for (List hole : holesPolygons.get((Object)((ChunkPos)list.get(0)))) {
                FrontierOverlay.removeCollinear(hole);
            }
        }
        for (List list : outerPolygons) {
            MapPolygon polygon = new MapPolygon(list.stream().map(c -> new BlockPos(c.m_45604_(), 70, c.m_45605_())).toList());
            ArrayList<MapPolygon> polygonHoles = null;
            if (holesPolygons.containsKey(list.get(0))) {
                polygonHoles = new ArrayList<MapPolygon>();
                for (List hole : holesPolygons.get((Object)((ChunkPos)list.get(0)))) {
                    polygonHoles.add(new MapPolygon(hole.stream().map(c -> new BlockPos(c.m_45604_(), 70, c.m_45605_())).toList()));
                }
            }
            this.addPolygonOverlays(this.displayId + "_" + list.get(0), shapeProps, polygon, polygonHoles);
        }
        this.area = this.chunks.size() * 256;
    }

    private static void addNewEdge(Multimap<ChunkPos, ChunkPos> edges, ChunkPos from, ChunkPos to) {
        if (!edges.remove((Object)to, (Object)from)) {
            edges.put((Object)from, (Object)to);
        }
    }

    private static void removeCollinear(List<ChunkPos> chunks) {
        if (chunks.size() <= 4) {
            return;
        }
        ChunkPos prev = chunks.get(0);
        for (int i = chunks.size() - 1; i > 0; --i) {
            ChunkPos next = chunks.get(i - 1);
            if (prev.f_45578_ == next.f_45578_ || prev.f_45579_ == next.f_45579_) {
                chunks.remove(i);
            }
            if (i >= chunks.size()) continue;
            prev = chunks.get(i);
        }
    }

    private void addNameAndOwner(PolygonOverlay polygonOverlay, boolean nameVisible, boolean ownerVisible) {
        if (!nameVisible && !ownerVisible) {
            return;
        }
        TextProperties textProps = new TextProperties().setColor(this.color).setScale(2.0f).setBackgroundOpacity(0.0f);
        if (Config.hideNamesThatDontFit) {
            if (this.mode == FrontierData.Mode.Vertex) {
                textProps = this.setMinSizeTextPropierties(textProps, this.bottomRight.m_123341_() - this.topLeft.m_123341_(), nameVisible, ownerVisible);
            } else {
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                for (BlockPos vertex : polygonOverlay.getOuterArea().getPoints()) {
                    if (vertex.m_123341_() < minX) {
                        minX = vertex.m_123341_();
                    }
                    if (vertex.m_123341_() <= maxX) continue;
                    maxX = vertex.m_123341_();
                }
                textProps = this.setMinSizeTextPropierties(textProps, maxX - minX, nameVisible, ownerVisible);
            }
        }
        int lines = 0;
        Object label = "";
        if (nameVisible) {
            if (!this.name1.isEmpty()) {
                ++lines;
                label = (String)label + this.name1 + "\n";
            }
            if (!this.name2.isEmpty()) {
                ++lines;
                label = (String)label + this.name2 + "\n";
            }
        }
        if (ownerVisible && !this.owner.username.isEmpty()) {
            ++lines;
            label = (String)label + ChatFormatting.ITALIC + this.owner.username + "\n";
        }
        if (lines > 0) {
            if (lines > 1) {
                textProps.setOffsetY(10);
            }
            polygonOverlay.setTextProperties(textProps).setOverlayGroupName("frontier").setLabel((String)label);
        }
    }

    private TextProperties setMinSizeTextPropierties(TextProperties textProperties, int polygonWidth, boolean nameVisible, boolean ownerVisible) {
        int zoom;
        int name1Width = nameVisible ? Minecraft.m_91087_().f_91062_.m_92895_(this.name1) * 2 : 0;
        int name2Width = nameVisible ? Minecraft.m_91087_().f_91062_.m_92895_(this.name2) * 2 : 0;
        int onwerWidth = ownerVisible ? Minecraft.m_91087_().f_91062_.m_92895_(this.owner.username) * 2 : 0;
        int labelWidth = Math.max(onwerWidth, Math.max(name1Width, name2Width)) + 6;
        for (zoom = 0; labelWidth > polygonWidth && zoom < 8; ++zoom, polygonWidth *= 2) {
        }
        return textProperties.setMinZoom(zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBounds() {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.isEmpty()) {
                this.topLeft = new BlockPos(0, 70, 0);
                this.bottomRight = new BlockPos(0, 70, 0);
            } else {
                int minX = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                List list = this.vertices;
                synchronized (list) {
                    for (BlockPos vertex : this.vertices) {
                        if (vertex.m_123341_() < minX) {
                            minX = vertex.m_123341_();
                        }
                        if (vertex.m_123343_() < minZ) {
                            minZ = vertex.m_123343_();
                        }
                        if (vertex.m_123341_() > maxX) {
                            maxX = vertex.m_123341_();
                        }
                        if (vertex.m_123343_() <= maxZ) continue;
                        maxZ = vertex.m_123343_();
                    }
                }
                this.topLeft = new BlockPos(minX, 70, minZ);
                this.bottomRight = new BlockPos(maxX, 70, maxZ);
            }
        } else if (this.chunks.isEmpty()) {
            this.topLeft = new BlockPos(0, 70, 0);
            this.bottomRight = new BlockPos(0, 70, 0);
        } else {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            Set set = this.chunks;
            synchronized (set) {
                for (ChunkPos chunk : this.chunks) {
                    if (chunk.f_45578_ < minX) {
                        minX = chunk.f_45578_;
                    }
                    if (chunk.f_45579_ < minZ) {
                        minZ = chunk.f_45579_;
                    }
                    if (chunk.f_45578_ > maxX) {
                        maxX = chunk.f_45578_;
                    }
                    if (chunk.f_45579_ <= maxZ) continue;
                    maxZ = chunk.f_45579_;
                }
            }
            this.topLeft = new BlockPos(minX * 16, 70, minZ * 16);
            this.bottomRight = new BlockPos(maxX * 16 + 16, 70, maxZ * 16 + 16);
        }
    }

    private void addMarkerDots(String markerId, BlockPos from, BlockPos to) {
        if (Math.abs(to.m_123343_() - from.m_123343_()) < Math.abs(to.m_123341_() - from.m_123341_())) {
            if (from.m_123341_() > to.m_123341_()) {
                this.addLineMarkerDots(markerId, to.m_123341_(), to.m_123343_(), from.m_123341_(), from.m_123343_());
            } else {
                this.addLineMarkerDots(markerId, from.m_123341_(), from.m_123343_(), to.m_123341_(), to.m_123343_());
            }
        } else if (from.m_123343_() > to.m_123343_()) {
            this.addLineMarkerDots(markerId, to.m_123341_(), to.m_123343_(), from.m_123341_(), from.m_123343_());
        } else {
            this.addLineMarkerDots(markerId, from.m_123341_(), from.m_123343_(), to.m_123341_(), to.m_123343_());
        }
    }

    private void addLineMarkerDots(String markerId, int x0, int z0, int x1, int z1) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dz = -Math.abs(z1 - z0);
        int sz = z0 < z1 ? 1 : -1;
        int err = dx + dz;
        int i = 0;
        while (x0 != x1 || z0 != z1) {
            int e2 = 2 * err;
            if (e2 >= dz) {
                if (x0 == x1) break;
                err += dz;
                x0 += sx;
            }
            if (e2 <= dx) {
                if (z0 == z1) break;
                err += dx;
                z0 += sz;
            }
            BlockPos pos = new BlockPos(x0, 70, z0);
            MarkerOverlay dot = new MarkerOverlay("mapfrontiers", markerId + "_" + i, pos, markerDot);
            dot.setDimension(this.dimension);
            dot.setDisplayOrder(99);
            int minZoom = 0;
            if (i % 2 == 0) {
                minZoom = 3;
            } else if (i % 4 == 1) {
                minZoom = 2;
            } else if (i % 8 == 3) {
                minZoom = 1;
            }
            dot.setMinZoom(minZoom);
            this.markerOverlays.add(dot);
            ++i;
        }
    }

    static {
        markerVertex.setAnchorX(markerVertex.getDisplayWidth() / 2.0).setAnchorY(markerVertex.getDisplayHeight() / 2.0);
        markerVertex.setRotation(0);
        markerDot.setAnchorX(markerDot.getDisplayWidth() / 2.0).setAnchorY(markerDot.getDisplayHeight() / 2.0);
        markerDot.setRotation(0);
    }

    public static class BannerDisplayData {
        public final List<BannerPattern> patternList = new ArrayList<BannerPattern>();
        public final List<DyeColor> colorList = new ArrayList<DyeColor>();
        public String patternResourceLocation;

        public BannerDisplayData(FrontierData.BannerData bannerData) {
            this.patternList.add((BannerPattern)BuiltInRegistries.f_256878_.m_6246_(BannerPatterns.f_222726_));
            this.colorList.add(bannerData.baseColor);
            StringBuilder patternResLocBuilder = new StringBuilder("b");
            patternResLocBuilder.append(bannerData.baseColor.m_41060_());
            if (bannerData.patterns != null) {
                for (int i = 0; i < bannerData.patterns.size(); ++i) {
                    CompoundTag nbtTagCompound = bannerData.patterns.m_128728_(i);
                    Holder bannerPattern = BannerPattern.m_222700_((String)nbtTagCompound.m_128461_("Pattern"));
                    if (bannerPattern == null) continue;
                    this.patternList.add((BannerPattern)bannerPattern.m_203334_());
                    int j = nbtTagCompound.m_128451_("Color");
                    this.colorList.add(DyeColor.m_41053_((int)j));
                    patternResLocBuilder.append(((BannerPattern)bannerPattern.m_203334_()).m_58579_());
                    patternResLocBuilder.append(j);
                }
            }
            this.patternResourceLocation = patternResLocBuilder.toString();
        }
    }
}

