/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers;

import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.command.CommandAccept;
import games.alejandrocoria.mapfrontiers.common.event.EventHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontiers;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapFrontiers {
    public static final String MODID = "mapfrontiers";
    public static final Logger LOGGER = LogManager.getLogger((String)"MapFrontiers");
    private static FrontiersManager frontiersManager;
    private static final HashSet<ServerPlayer> pendingJoinedPlayers;

    protected static void init() {
        PacketHandler.init();
        EventHandler.subscribeCommandRegistrationEvent(MapFrontiers.class, CommandAccept::register);
        EventHandler.subscribeServerStartingEvent(MapFrontiers.class, server -> {
            frontiersManager = new FrontiersManager();
            frontiersManager.loadOrCreateData((MinecraftServer)server);
            LOGGER.info("ServerStartingEvent done");
        });
        EventHandler.subscribeServerStoppingEvent(MapFrontiers.class, server -> {
            if (frontiersManager != null) {
                frontiersManager.close();
            }
            frontiersManager = null;
            pendingJoinedPlayers.clear();
            LOGGER.info("ServerStoppingEvent done");
        });
        EventHandler.subscribePlayerJoinedEvent(MapFrontiers.class, (server, player) -> {
            if (frontiersManager == null) {
                return;
            }
            frontiersManager.ensureOwners((MinecraftServer)server);
            LOGGER.info("PlayerJoinedEvent done (" + player.m_20149_() + ")");
        });
    }

    public static void ReceiveHandshake(ServerPlayer player) {
        PacketHandler.sendTo(new PacketSettingsProfile(frontiersManager.getSettings().getProfile(player)), player);
        PacketFrontiers packetFrontiers = new PacketFrontiers();
        for (ArrayList<FrontierData> frontiers : frontiersManager.getAllGlobalFrontiers().values()) {
            packetFrontiers.addGlobalFrontiers(frontiers);
        }
        for (ArrayList<FrontierData> frontiers : frontiersManager.getAllPersonalFrontiers(new SettingsUser((Player)player)).values()) {
            packetFrontiers.addPersonalFrontiers(frontiers);
        }
        PacketHandler.sendTo(packetFrontiers, player);
    }

    public static boolean isOPorHost(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return false;
        }
        return server.m_6846_().m_11303_(player.m_36316_());
    }

    static {
        pendingJoinedPlayers = new HashSet();
    }
}

