/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.configuration.presence;

import com.hypherionmc.craterlib.core.config.annotations.HideFromScreen;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import me.hypherionmc.simplerpclib.configuration.objects.RPCButton;
import me.hypherionmc.simplerpclib.discord.RichPresenceBuilder;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.APIUtils;
import me.hypherionmc.simplerpclib.util.RPCContainer;
import shadow.hypherionmc.moonconfig.core.conversion.Path;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;
import shadow.hypherionmc.moonconfig.core.fields.RandomArrayList;

public class InitSection
implements RPCContainer {
    @Path(value="enabled")
    @SpecComment(value="Enable/Disable the Game Loading Event")
    public boolean enabled = true;
    @Path(value="description")
    @SpecComment(value="The first line of text under the app name")
    public String description = "Minecraft is loading";
    @Path(value="state")
    @SpecComment(value="The second line of text under the app name")
    public String state = "Game Starting...";
    @Path(value="largeImageKey")
    @SpecComment(value="The Asset ID of the image to display as the large image")
    @HideFromScreen
    public RandomArrayList<String> largeImageKey = RandomArrayList.of((Object[])new String[]{"mclogonew"});
    @Path(value="largeImageText")
    @SpecComment(value="The text that gets displayed when the large image is hovered")
    public String largeImageText = "It's Minecraft %mcver%, but modded";
    @Path(value="smallImageKey")
    @SpecComment(value="The Asset ID of the image to display as the small image")
    @HideFromScreen
    public RandomArrayList<String> smallImageKey = RandomArrayList.of((Object[])new String[]{"mclogo"});
    @Path(value="smallImageText")
    @SpecComment(value="The text that gets displayed when the small image is hovered")
    public String smallImageText = "%mods% mods installed";
    @Path(value="buttons")
    @SpecComment(value="The buttons to display on Discord")
    @HideFromScreen
    public List<RPCButton> buttonsList = new ArrayList<RPCButton>();

    @Override
    public RichPresenceBuilder buildPresence(RichPresenceCore core) {
        RichPresenceBuilder build = new RichPresenceBuilder().setDetails(core.getUtilHandler().parseVarsInternal(this.description, core.getClientConfig().variablesConfig)).setLargeImage(core.getUtilHandler().parseVarsInternal(this.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setLargeImageText(core.getUtilHandler().parseVarsInternal(this.largeImageText, core.getClientConfig().variablesConfig)).setSmallImage(core.getUtilHandler().parseVarsInternal(this.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setSmallImageText(core.getUtilHandler().parseVarsInternal(this.smallImageText, core.getClientConfig().variablesConfig)).setTimeStamp(OffsetDateTime.now()).setButtons(APIUtils.parseButtons(this.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setState(core.getUtilHandler().parseVarsInternal(this.state, core.getClientConfig().variablesConfig));
        build = LauncherUtils.getLauncherOverrides(build, core);
        return this.enabled ? build : null;
    }
}

