/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.ModItems;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class OreDropsLootModifier
extends LootModifier {
    public static final Codec<OreDropsLootModifier> CODEC = RecordCodecBuilder.create(instance -> OreDropsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, OreDropsLootModifier::new));

    public OreDropsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (tool != null && blockState != null && ConfigHelper.get().getCommon().getAdditionalDrops().enableAdditionalOreDrops()) {
            Block block = blockState.m_60734_();
            Item toolItem = tool.m_41720_();
            RandomSource random = context.m_230907_();
            if (EnchantmentHelper.m_44831_((ItemStack)tool).containsKey(Enchantments.f_44985_)) {
                return generatedLoot;
            }
            if ((block == Blocks.f_49996_ || block == Blocks.f_152468_) && toolItem == ModItems.NETHERITE_IRON_PICKAXE && (double)random.m_188501_() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalRawIronDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_151050_, random.m_216332_(1, 2)));
            }
            if ((block == Blocks.f_49995_ || block == Blocks.f_152467_) && toolItem == ModItems.NETHERITE_GOLD_PICKAXE && (double)random.m_188501_() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalRawGoldDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_151053_, random.m_216332_(1, 1)));
            }
            if ((block == Blocks.f_50264_ || block == Blocks.f_152479_) && toolItem == ModItems.NETHERITE_EMERALD_PICKAXE && (double)random.m_188501_() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalEmeraldDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42616_, random.m_216332_(1, 1)));
            }
            if ((block == Blocks.f_50089_ || block == Blocks.f_152474_) && toolItem == ModItems.NETHERITE_DIAMOND_PICKAXE && (double)random.m_188501_() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalDiamondDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42415_, random.m_216332_(1, 1)));
            }
            if (block == Blocks.f_49998_ && toolItem == ModItems.NETHERITE_GOLD_PICKAXE && (double)random.m_188501_() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalGoldNuggetDropChance()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42587_, random.m_216332_(1, 3)));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

