/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite;

import com.autovw.advancednetherite.AdvancedNetherite;
import com.autovw.advancednetherite.AdvancedNetheriteTab;
import com.autovw.advancednetherite.ForgePlatformHelper;
import com.autovw.advancednetherite.client.ClientHandler;
import com.autovw.advancednetherite.config.Config;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.registry.ModBlockRegistry;
import com.autovw.advancednetherite.core.registry.ModItemRegistry;
import com.autovw.advancednetherite.core.registry.ModLootModifiers;
import com.autovw.advancednetherite.core.util.ModToolTiers;
import com.autovw.advancednetherite.registry.ForgeRegistryHelper;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="advancednetherite")
public class AdvancedNetheriteForge {
    public static final Logger LOGGER = LogUtils.getLogger();

    public AdvancedNetheriteForge() {
        AdvancedNetherite.init(ForgePlatformHelper.getInstance());
        AdvancedNetherite.setRegistryHelper(new ForgeRegistryHelper());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverConfig);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        ModBlockRegistry.BLOCKS.register(bus);
        ModItemRegistry.ITEMS.register(bus);
        ModLootModifiers.LOOT_MODIFIERS.register(bus);
        AdvancedNetheriteTab.TABS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::tierSortingRegistry);
        ConfigHelper.registerClientConfig(() -> Config.CLIENT);
        ConfigHelper.registerCommonConfig(() -> Config.COMMON);
        ConfigHelper.registerServerConfig(() -> Config.SERVER);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientHandler::onClientSetup);
    }

    private void tierSortingRegistry() {
        TierSortingRegistry.registerTier((Tier)ModToolTiers.NETHERITE_IRON, (ResourceLocation)new ResourceLocation("advancednetherite", "netherite_iron"), List.of(Tiers.NETHERITE), List.of());
        TierSortingRegistry.registerTier((Tier)ModToolTiers.NETHERITE_GOLD, (ResourceLocation)new ResourceLocation("advancednetherite", "netherite_gold"), List.of(ModToolTiers.NETHERITE_IRON), List.of());
        TierSortingRegistry.registerTier((Tier)ModToolTiers.NETHERITE_EMERALD, (ResourceLocation)new ResourceLocation("advancednetherite", "netherite_emerald"), List.of(ModToolTiers.NETHERITE_GOLD), List.of());
        TierSortingRegistry.registerTier((Tier)ModToolTiers.NETHERITE_DIAMOND, (ResourceLocation)new ResourceLocation("advancednetherite", "netherite_diamond"), List.of(ModToolTiers.NETHERITE_EMERALD), List.of());
    }
}

