/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class EmberIreSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    private static SimpleParticleType particleWalk = ParticleTypes.f_123801_;
    private static SimpleParticleType particleSprint = ParticleTypes.f_123801_;
    private static SimpleParticleType particlePassive = ParticleTypes.f_123762_;

    public EmberIreSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            int fhitchance = (int)Config.getFloat("emberIreChance", "UniqueEffects", ConfigDefaultValues.emberIreChance);
            int fduration = (int)Config.getFloat("emberIreDuration", "UniqueEffects", ConfigDefaultValues.emberIreDuration);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= fhitchance) {
                attacker.m_20254_(fduration / 20);
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19600_, fduration, 0), (Entity)attacker);
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, fduration, 1), (Entity)attacker);
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 0), (Entity)attacker);
                world.m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_01.get(), attacker.m_5720_(), 0.5f, 2.0f);
                particlePassive = ParticleTypes.f_123756_;
                particleWalk = ParticleTypes.f_123777_;
                particleSprint = ParticleTypes.f_123777_;
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_() && user.m_21023_(MobEffects.f_19600_) && user.m_21023_(MobEffects.f_19598_) && user.m_21023_(MobEffects.f_19596_)) {
            ServerLevel sWorld = (ServerLevel)user.m_9236_();
            BlockPos position = user.m_20183_();
            Vec3 rotation = user.m_20252_(1.0f);
            Vec3 newPos = user.m_20182_().m_82549_(rotation);
            LargeFireball fireball = new LargeFireball(EntityType.f_20463_, world);
            fireball.m_20248_(newPos.m_7096_(), user.m_20186_() + 1.5, newPos.m_7094_());
            fireball.m_5602_((Entity)user);
            user.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 20, 4), (Entity)user);
            user.m_147207_(new MobEffectInstance(MobEffects.f_19607_, 60, 2), (Entity)user);
            sWorld.m_7967_((Entity)fireball);
            fireball.m_20256_(rotation);
            user.m_21195_(MobEffects.f_19600_);
            user.m_21195_(MobEffects.f_19596_);
            user.m_21195_(MobEffects.f_19598_);
            world.m_5594_(null, position, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.3f, 2.0f);
            user.m_20095_();
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_21023_(MobEffects.f_19600_) && !player.m_6060_()) {
            particlePassive = ParticleTypes.f_123762_;
            particleWalk = ParticleTypes.f_123801_;
            particleSprint = ParticleTypes.f_123801_;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, particleWalk, particleSprint, particlePassive, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip5").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

