/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.crockery;

import earth.terrarium.handcrafted.common.blocks.base.SimpleBlock;
import earth.terrarium.handcrafted.common.blocks.crockery.CrockeryBlockEntity;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrockeryComboBlock
extends SimpleBlock
implements EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public CrockeryComboBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof CrockeryBlockEntity) {
            CrockeryBlockEntity crockery = (CrockeryBlockEntity)blockEntity;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)crockery.getStack());
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrockeryBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ConstantComponents.CROCKERY_COMBO);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrockeryBlockEntity) {
            CrockeryBlockEntity crockery = (CrockeryBlockEntity)blockEntity;
            ItemStack stack = crockery.getStack();
            if (stack.m_41619_()) {
                ItemStack itemInHand = player.m_21120_(hand).m_41777_();
                itemInHand.m_41764_(1);
                crockery.setStack(itemInHand);
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                level.m_5594_(null, pos, SoundEvents.f_12013_, player.m_5720_(), 1.0f, 1.0f);
            } else {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                crockery.setStack(ItemStack.f_41583_);
                level.m_5594_(null, pos, SoundEvents.f_12016_, player.m_5720_(), 1.0f, 1.0f);
            }
        }
        return InteractionResult.CONSUME_PARTIAL;
    }
}

