/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HeadLayerFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private Set<Item> hideHeadLayers = Sets.newHashSet((Object[])new Item[]{Items.f_42681_, Items.f_42682_, Items.f_42683_, Items.f_42678_, Items.f_42679_});
    private static final Minecraft mc = Minecraft.m_91087_();
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.m_117386_()).hasThinArms();

    public HeadLayerFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer player, float f, float g, float h, float j, float k, float l) {
        if (player.m_20145_() || !SkinLayersModBase.config.enableHat) {
            return;
        }
        if (HeadLayerFeatureRenderer.mc.f_91073_ == null) {
            return;
        }
        if (HeadLayerFeatureRenderer.mc.f_91074_.m_20280_((Entity)player) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
        if (itemStack != null && this.hideHeadLayers.contains(itemStack.m_41720_())) {
            return;
        }
        if (itemStack != null && itemStack.m_41720_() == Items.f_42680_ && !SkinLayersModBase.disguiseHeadsCompatibility) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()))) {
            return;
        }
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110454_((ResourceLocation)player.m_108560_(), (boolean)true));
        int overlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        this.renderCustomHelmet(settings, player, poseStack, vertexConsumer, i, overlay);
    }

    public void renderCustomHelmet(PlayerSettings settings, AbstractClientPlayer abstractClientPlayer, PoseStack matrixStack, VertexConsumer vertices, int light, int overlay) {
        if (settings.getHeadMesh() == null) {
            return;
        }
        if (!((PlayerModel)this.m_117386_()).f_102808_.f_104207_ || !abstractClientPlayer.m_36170_(PlayerModelPart.HAT)) {
            return;
        }
        float voxelSize = SkinLayersModBase.config.headVoxelSize;
        matrixStack.m_85836_();
        ((PlayerModel)this.m_117386_()).f_102808_.m_104299_(matrixStack);
        matrixStack.m_85837_(0.0, -0.25, 0.0);
        matrixStack.m_85841_(voxelSize, voxelSize, voxelSize);
        matrixStack.m_85837_(0.0, 0.25, 0.0);
        matrixStack.m_85837_(0.0, -0.04, 0.0);
        settings.getHeadMesh().render(((PlayerModel)this.m_117386_()).f_102808_, matrixStack, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }
}

