/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.client.PlayerSkins;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GravestoneRenderer
implements BlockEntityRenderer<GraveStoneTileEntity> {
    private BlockEntityRendererProvider.Context renderer;

    public GravestoneRenderer(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public void render(GraveStoneTileEntity grave, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Component name = grave.getGraveName();
        if (name == null) {
            return;
        }
        Direction direction = (Direction)grave.m_58900_().m_61143_((Property)GraveStoneBlock.FACING);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.0, 0.5);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f + direction.m_122435_()));
        Font font = this.renderer.m_173586_();
        int textWidth = font.m_92895_(name.getString());
        double textScale = Math.min(0.8 / (double)textWidth, 0.02);
        matrixStack.m_85837_(0.0, 0.3, 0.37);
        matrixStack.m_85841_((float)textScale, (float)textScale, (float)textScale);
        float left = -textWidth / 2;
        font.m_271703_(name.getString(), left, 0.0f, Main.CLIENT_CONFIG.graveTextColor, false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        matrixStack.m_85849_();
        BlockState state = grave.m_58904_().m_8055_(grave.m_58899_().m_7495_());
        boolean render = state.m_60796_((BlockGetter)grave.m_58904_(), grave.m_58899_());
        UUID playerUUID = grave.getDeath().getPlayerUUID();
        if (playerUUID != null && !playerUUID.equals(GraveUtils.EMPTY_UUID) && ((Boolean)Main.CLIENT_CONFIG.renderSkull.get()).booleanValue() && render) {
            this.renderSkull(playerUUID, name.getString(), direction, matrixStack, buffer, combinedLight);
        }
    }

    public void renderSkull(UUID uuid, String name, Direction rotation, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight) {
        SkullModel model = new SkullModel(this.renderer.m_173582_(ModelLayers.f_171163_));
        ResourceLocation resourcelocation = PlayerSkins.getSkin(uuid, name);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotation.m_122435_()));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-26.0f));
        matrixStack.m_85837_(0.0, -0.14, 0.18);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-61.0f));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        model.m_7695_(matrixStack, buffer.m_6299_(model.m_103119_(resourcelocation)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }
}

