/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.PlayerDeathEvent;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DeathEvents {
    public DeathEvents() {
        de.maxhenkel.gravestone.corelib.death.DeathEvents.register();
    }

    @SubscribeEvent
    public void playerDeath(PlayerDeathEvent event) {
        BlockEntity tileentity;
        event.storeDeath();
        Death death = event.getDeath();
        ServerPlayer player = event.getPlayer();
        Level world = player.m_9236_();
        if (DeathEvents.keepInventory((Player)player)) {
            return;
        }
        BlockPos graveStoneLocation = GraveUtils.getGraveStoneLocation(world, death.getBlockPos());
        if (((Boolean)Main.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            player.m_150109_().m_36054_(((ObituaryItem)((Object)Main.OBITUARY.get())).toStack(death));
        }
        if (graveStoneLocation == null) {
            Main.LOGGER.info("Grave of '{}' can't be placed (No space)", (Object)death.getPlayerName());
            Main.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        world.m_46597_(graveStoneLocation, (BlockState)((GraveStoneBlock)Main.GRAVESTONE.get()).m_49966_().m_61124_((Property)GraveStoneBlock.FACING, (Comparable)player.m_6350_().m_122424_()));
        if (GraveUtils.isReplaceable(world, graveStoneLocation.m_7495_())) {
            world.m_46597_(graveStoneLocation.m_7495_(), Blocks.f_50493_.m_49966_());
        }
        if (!((tileentity = world.m_7702_(graveStoneLocation)) instanceof GraveStoneTileEntity)) {
            Main.LOGGER.info("Grave of '{}' can't be filled with loot (No tileentity found)", (Object)death.getPlayerName());
            Main.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        GraveStoneTileEntity gravestone = (GraveStoneTileEntity)tileentity;
        gravestone.setDeath(death);
        event.removeDrops();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!((Boolean)Main.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (DeathEvents.keepInventory(event.getEntity())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof ObituaryItem)) continue;
            event.getEntity().m_150109_().m_36054_(stack);
        }
    }

    public static boolean keepInventory(Player player) {
        try {
            return player.m_20193_().m_6106_().m_5470_().m_46207_(GameRules.f_46133_);
        }
        catch (Exception e) {
            return false;
        }
    }
}

