/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.Config;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.ImageManipulations;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;

public class ServerPaintingManager {
    public static MinecraftServer server;
    private static Map<ResourceLocation, Painting> datapackPaintings;

    public static CustomServerPaintings get() {
        return (CustomServerPaintings)server.m_129783_().m_8895_().m_164861_(CustomServerPaintings::fromNbt, CustomServerPaintings::new, "immersive_paintings");
    }

    public static Map<ResourceLocation, Painting> getDatapackPaintings() {
        return datapackPaintings;
    }

    public static void setDatapackPaintings(Map<ResourceLocation, Painting> datapackPaintings) {
        ServerPaintingManager.datapackPaintings = datapackPaintings;
    }

    public static Path getPaintingPath(ResourceLocation identifier) {
        return Path.of("immersive_paintings", identifier.toString().replace(":", "_") + ".png");
    }

    public static void registerPainting(ResourceLocation identifier, Painting painting) {
        Painting.Texture texture = painting.getTexture(Painting.Type.FULL);
        if (texture.image != null) {
            Path path = ServerPaintingManager.getPaintingPath(identifier);
            new File(path.getParent().toString()).mkdirs();
            texture.image.write(path.toFile());
        }
        ServerPaintingManager.get().getCustomServerPaintings().put(identifier, painting);
        ServerPaintingManager.get().m_77760_(true);
    }

    public static void deregisterPainting(ResourceLocation identifier) {
        ServerPaintingManager.get().getCustomServerPaintings().remove(identifier);
        ServerPaintingManager.get().m_77760_(true);
        ServerPaintingManager.getPaintingPath(identifier).toFile().delete();
    }

    public static Painting getPainting(ResourceLocation i) {
        if (datapackPaintings.containsKey(i)) {
            return datapackPaintings.get(i);
        }
        return ServerPaintingManager.get().customServerPaintings.getOrDefault(i, Painting.DEFAULT);
    }

    public static Optional<ByteImage> getImage(ResourceLocation i, Painting.Type type) {
        Optional<byte[]> data = ServerPaintingManager.getImageData(i, type);
        if (data.isPresent()) {
            try {
                return Optional.of(ByteImage.read(data.get()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<byte[]> getImageData(ResourceLocation i, Painting.Type type) {
        Painting painting = ServerPaintingManager.getPainting(i);
        Painting.Texture texture = painting.getTexture(type);
        byte[] data = null;
        if (type == Painting.Type.FULL) {
            if (texture.image == null) {
                try {
                    if (texture.resource != null) {
                        data = texture.getResource();
                        return Optional.ofNullable(data);
                    }
                    if (!ServerPaintingManager.get().customServerPaintings.containsKey(i)) return Optional.ofNullable(data);
                    try (FileInputStream stream = new FileInputStream(ServerPaintingManager.getPaintingPath(i).toString());){
                        data = stream.readAllBytes();
                        return Optional.ofNullable(data);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                data = texture.image.encode();
            }
            return Optional.ofNullable(data);
        } else {
            Optional<byte[]> imageData = Cache.getData(texture);
            if (imageData.isPresent()) {
                data = imageData.get();
                return Optional.ofNullable(data);
            } else {
                int h;
                int w;
                Optional<ByteImage> optionalByteImage = ServerPaintingManager.getImage(i, Painting.Type.FULL);
                if (!optionalByteImage.isPresent()) return Optional.ofNullable(data);
                ByteImage image = optionalByteImage.get();
                if (type == Painting.Type.THUMBNAIL) {
                    float zoom = Math.min((float)Config.getInstance().thumbnailSize / (float)image.getWidth(), (float)Config.getInstance().thumbnailSize / (float)image.getHeight());
                    if (zoom >= 1.0f) {
                        return ServerPaintingManager.getImageData(i, Painting.Type.FULL);
                    }
                    w = (int)((float)image.getWidth() * zoom);
                    h = (int)((float)image.getHeight() * zoom);
                } else if (type == Painting.Type.HALF) {
                    w = image.getWidth() / 2;
                    h = image.getHeight() / 2;
                } else if (type == Painting.Type.QUARTER) {
                    w = image.getWidth() / 4;
                    h = image.getHeight() / 4;
                } else {
                    w = image.getWidth() / 8;
                    h = image.getHeight() / 8;
                }
                ByteImage target = new ByteImage(w, h);
                ImageManipulations.resize(target, image, (double)image.getWidth() / (double)w, 0, 0);
                texture.image = target;
                data = texture.image.encode();
                Cache.set(texture, data);
            }
        }
        return Optional.ofNullable(data);
    }

    static {
        datapackPaintings = new HashMap<ResourceLocation, Painting>();
    }

    public static class CustomServerPaintings
    extends SavedData {
        final Map<ResourceLocation, Painting> customServerPaintings = new HashMap<ResourceLocation, Painting>();

        public static CustomServerPaintings fromNbt(CompoundTag nbt) {
            CustomServerPaintings c = new CustomServerPaintings();
            for (String key : nbt.m_128431_()) {
                c.customServerPaintings.put(new ResourceLocation(key), Painting.fromNbt(nbt.m_128469_(key)));
            }
            return c;
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            CompoundTag c = new CompoundTag();
            for (Map.Entry<ResourceLocation, Painting> entry : this.customServerPaintings.entrySet()) {
                c.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().toNbt());
            }
            return c;
        }

        public Map<ResourceLocation, Painting> getCustomServerPaintings() {
            return this.customServerPaintings;
        }
    }
}

