/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import twilightforest.client.MagicPaintingTextureManager;
import twilightforest.entity.MagicPainting;
import twilightforest.init.custom.MagicPaintingVariants;
import twilightforest.util.MagicPaintingVariant;

public class MagicPaintingRenderer
extends EntityRenderer<MagicPainting> {
    protected static final float ONE_SECOND = 8.3333335E-4f;

    public MagicPaintingRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(MagicPainting painting, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        MagicPaintingVariant paintingVariant = painting.getVariant().orElse(null);
        if (paintingVariant == null) {
            return;
        }
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        stack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(painting)));
        this.renderPainting(stack, vertexconsumer, painting, paintingVariant);
        stack.m_85849_();
        super.m_7392_((Entity)painting, yaw, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(MagicPainting painting) {
        return MagicPaintingTextureManager.ATLAS_LOCATION;
    }

    private void renderPainting(PoseStack stack, VertexConsumer vertex, MagicPainting painting, MagicPaintingVariant variant) {
        ResourceLocation textureLocation = MagicPaintingVariants.getVariantResourceLocation(painting.m_9236_().m_9598_(), variant);
        int width = variant.width();
        int height = variant.height();
        int widthAsBlock = width / 16;
        int heightAsBlock = height / 16;
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        float x = (float)(-width) / 2.0f;
        float y = (float)(-height) / 2.0f;
        float z = 0.5f;
        double widthFactor = 16.0 / (double)widthAsBlock;
        double heightFactor = 16.0 / (double)heightAsBlock;
        Direction direction = painting.m_6350_();
        int posX = painting.m_146903_();
        int posZ = painting.m_146907_();
        for (MagicPaintingVariant.Layer layer : variant.layers()) {
            float alpha = this.getAlpha(layer.opacityModifier(), painting);
            if (alpha <= 0.0f) continue;
            MagicPaintingVariant.Layer.Parallax parallax = layer.parallax();
            int layerWidth = parallax != null ? parallax.width() : width;
            int layerHeight = parallax != null ? parallax.height() : height;
            double layerWidthAsBlock = (double)layerWidth / 16.0;
            double layerHeightAsBlock = (double)layerHeight / 16.0;
            double layerWidthFactor = 16.0 / layerWidthAsBlock;
            double layerHeightFactor = 16.0 / layerHeightAsBlock;
            double widthDiff = parallax != null ? (widthFactor - layerWidthFactor) * (double)widthAsBlock * 0.5 : 0.0;
            double widthOffset = widthDiff != 0.0 ? this.getWidthOffset(parallax, painting, widthDiff) : 0.0;
            double heightDiff = parallax != null ? (heightFactor - layerHeightFactor) * (double)heightAsBlock * 0.5 : 0.0;
            double heightOffset = heightDiff != 0.0 ? this.getHeightOffset(parallax, painting, heightDiff) : 0.0;
            TextureAtlasSprite layerTexture = MagicPaintingTextureManager.instance.getLayerSprite(textureLocation, layer);
            for (int k = 0; k < widthAsBlock; ++k) {
                for (int l = 0; l < heightAsBlock; ++l) {
                    float xMax = x + (float)((k + 1) * 16);
                    float xMin = x + (float)(k * 16);
                    float yMax = y + (float)((l + 1) * 16);
                    float yMin = y + (float)(l * 16);
                    if (direction == Direction.NORTH) {
                        posX = Mth.m_14107_((double)(painting.m_20185_() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.WEST) {
                        posZ = Mth.m_14107_((double)(painting.m_20189_() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.SOUTH) {
                        posX = Mth.m_14107_((double)(painting.m_20185_() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.EAST) {
                        posZ = Mth.m_14107_((double)(painting.m_20189_() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    int light = layer.fullbright() ? 15728850 : LevelRenderer.m_109541_((BlockAndTintGetter)painting.m_9236_(), (BlockPos)new BlockPos(posX, Mth.m_14107_((double)(painting.m_20186_() + (double)((yMax + yMin) / 2.0f / 16.0f))), posZ));
                    float xEnd = layerTexture.m_118367_(layerWidthFactor * (double)(widthAsBlock - k) + widthOffset);
                    float xStart = layerTexture.m_118367_(layerWidthFactor * (double)(widthAsBlock - (k + 1)) + widthOffset);
                    float yEnd = layerTexture.m_118393_(layerHeightFactor * (double)(heightAsBlock - l) + heightOffset);
                    float yStart = layerTexture.m_118393_(layerHeightFactor * (double)(heightAsBlock - (l + 1)) + heightOffset);
                    this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, -z, xStart, yEnd, 0, 0, -1, light, alpha);
                    this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, -z, xEnd, yEnd, 0, 0, -1, light, alpha);
                    this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, -z, xEnd, yStart, 0, 0, -1, light, alpha);
                    this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, -z, xStart, yStart, 0, 0, -1, light, alpha);
                }
            }
        }
        TextureAtlasSprite backSprite = MagicPaintingTextureManager.instance.getBackSprite();
        float u0 = backSprite.m_118409_();
        float u1 = backSprite.m_118410_();
        float v0 = backSprite.m_118411_();
        float v1 = backSprite.m_118412_();
        float u01 = backSprite.m_118409_();
        float u11 = backSprite.m_118410_();
        float v01 = backSprite.m_118411_();
        float v = backSprite.m_118393_(1.0);
        float u02 = backSprite.m_118409_();
        float u = backSprite.m_118367_(1.0);
        float v02 = backSprite.m_118411_();
        float v11 = backSprite.m_118412_();
        for (int w = 0; w < widthAsBlock; ++w) {
            for (int h = 0; h < heightAsBlock; ++h) {
                float xMax = x + (float)((w + 1) * 16);
                float xMin = x + (float)(w * 16);
                float yMax = y + (float)((h + 1) * 16);
                float yMin = y + (float)(h * 16);
                if (direction == Direction.NORTH) {
                    posX = Mth.m_14107_((double)(painting.m_20185_() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                if (direction == Direction.WEST) {
                    posZ = Mth.m_14107_((double)(painting.m_20189_() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                if (direction == Direction.SOUTH) {
                    posX = Mth.m_14107_((double)(painting.m_20185_() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                if (direction == Direction.EAST) {
                    posZ = Mth.m_14107_((double)(painting.m_20189_() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)painting.m_9236_(), (BlockPos)new BlockPos(posX, Mth.m_14107_((double)(painting.m_20186_() + (double)((yMax + yMin) / 2.0f / 16.0f))), posZ));
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, z, u1, v0, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, z, u0, v0, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, z, u0, v1, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, z, u1, v1, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, -z, u01, v01, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, -z, u11, v01, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, z, u11, v, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, z, u01, v, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, z, u01, v01, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, z, u11, v01, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, -z, u11, v, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, -z, u01, v, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, z, u, v02, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, z, u, v11, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, -z, u02, v11, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, -z, u02, v02, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, -z, u, v02, 1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, -z, u, v11, 1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, z, u02, v11, 1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, z, u02, v02, 1, 0, 0, light, 1.0f);
            }
        }
    }

    protected void vertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertex, float x, float y, float z, float u, float v, int normX, int normY, int normZ, int light, float a) {
        vertex.m_252986_(matrix4f, x, y, z).m_6122_(255, 255, 255, (int)(255.0f * a)).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, (float)normX, (float)normY, (float)normZ).m_5752_();
    }

    protected double getWidthOffset(@Nullable MagicPaintingVariant.Layer.Parallax parallax, MagicPainting painting, double widthDiff) {
        if (parallax != null) {
            switch (parallax.type()) {
                case VIEW_ANGLE: {
                    float partialTick = Minecraft.m_91087_().getPartialTick();
                    Vec3 camPos = Minecraft.m_91087_().f_91075_ != null ? Minecraft.m_91087_().f_91075_.m_20299_(partialTick) : Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                    Vec3 paintPos = painting.m_20182_().m_231075_(painting.m_6350_().m_122424_(), 1.0);
                    double x = camPos.f_82479_ - paintPos.f_82479_;
                    double z = camPos.f_82481_ - paintPos.f_82481_;
                    double yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)z, (double)x) * 57.2957763671875) - 90.0f - painting.m_146908_()));
                    return widthDiff + Mth.m_14008_((double)(yRot * (double)parallax.multiplier() * widthDiff), (double)(-widthDiff), (double)widthDiff);
                }
                case SINE_TIME: {
                    return widthDiff + Math.sin(((float)painting.f_19797_ + Minecraft.m_91087_().getPartialTick()) * parallax.multiplier()) * widthDiff;
                }
                case LINEAR_TIME: {
                    double trueTick = ((float)painting.f_19797_ + Minecraft.m_91087_().getPartialTick()) * parallax.multiplier();
                    double wholeDiff = widthDiff * 2.0;
                    return widthDiff + ((double)parallax.multiplier() > 0.0 ? -widthDiff + trueTick % wholeDiff : widthDiff - trueTick % wholeDiff);
                }
            }
        }
        return 0.0;
    }

    protected double getHeightOffset(@Nullable MagicPaintingVariant.Layer.Parallax parallax, MagicPainting painting, double heightDiff) {
        if (parallax != null) {
            switch (parallax.type()) {
                case VIEW_ANGLE: {
                    float partialTick = Minecraft.m_91087_().getPartialTick();
                    Vec3 camPos = Minecraft.m_91087_().f_91075_ != null ? Minecraft.m_91087_().f_91075_.m_20299_(partialTick) : Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                    Vec3 paintPos = painting.m_20182_().m_231075_(painting.m_6350_().m_122424_(), 1.0);
                    double x = camPos.f_82479_ - paintPos.f_82479_;
                    double y = camPos.f_82480_ - paintPos.f_82480_;
                    double z = camPos.f_82481_ - paintPos.f_82481_;
                    double pythagoras = Math.sqrt(x * x + z * z);
                    double xRot = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)y, (double)pythagoras) * 57.2957763671875))));
                    return heightDiff - Mth.m_14008_((double)(xRot * (double)parallax.multiplier() * heightDiff), (double)(-heightDiff), (double)heightDiff);
                }
                case SINE_TIME: {
                    return heightDiff - Math.cos(((float)painting.f_19797_ + Minecraft.m_91087_().getPartialTick()) * parallax.multiplier()) * heightDiff;
                }
                case LINEAR_TIME: {
                    double trueTick = ((float)painting.f_19797_ + Minecraft.m_91087_().getPartialTick()) * parallax.multiplier();
                    double wholeDiff = heightDiff * 2.0;
                    return heightDiff - ((double)parallax.multiplier() > 0.0 ? -heightDiff + trueTick % wholeDiff : heightDiff - trueTick % wholeDiff);
                }
            }
        }
        return 0.0;
    }

    protected float getAlpha(@Nullable MagicPaintingVariant.Layer.OpacityModifier opacityModifier, MagicPainting painting) {
        float a = 1.0f;
        if (opacityModifier != null) {
            switch (opacityModifier.type()) {
                case DISTANCE: {
                    Vec3 camPos = Optional.ofNullable(Minecraft.m_91087_().f_91075_).map(Entity::m_146892_).orElse(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_());
                    a = (float)(opacityModifier.invert() ? (double)opacityModifier.multiplier() - camPos.m_82554_(painting.m_20182_()) : camPos.m_82554_(painting.m_20182_()) - (double)opacityModifier.multiplier());
                    break;
                }
                case WEATHER: {
                    float partialTick = Minecraft.m_91087_().getPartialTick();
                    a = (painting.m_9236_().m_46722_(partialTick) + painting.m_9236_().m_46661_(partialTick)) * 0.5f * Math.abs(opacityModifier.multiplier());
                    if (!opacityModifier.invert()) break;
                    a = 1.0f - a;
                    break;
                }
                case LIGHTNING: {
                    Level level = painting.m_9236_();
                    if (!(level instanceof ClientLevel)) break;
                    ClientLevel clientLevel = (ClientLevel)level;
                    a = (float)clientLevel.m_104819_() * opacityModifier.multiplier();
                    if (!opacityModifier.invert()) break;
                    a = 1.0f - a;
                    break;
                }
                case DAY_TIME: {
                    float dayTime = Math.abs(painting.m_9236_().m_46942_(Minecraft.m_91087_().getPartialTick()) - 0.5f) * 2.0f;
                    if (opacityModifier.invert()) {
                        dayTime = 1.0f - dayTime;
                    }
                    a = (float)Math.pow(dayTime, opacityModifier.multiplier());
                    break;
                }
                case DAY_TIME_SHARP: {
                    float threshold;
                    float dayTime = Math.abs(painting.m_9236_().m_46942_(Minecraft.m_91087_().getPartialTick()) - 0.5f) * 2.0f;
                    if (opacityModifier.invert()) {
                        dayTime = 1.0f - dayTime;
                    }
                    if ((threshold = 1.0f - opacityModifier.multiplier()) > 0.99916667f) {
                        threshold = 0.99916667f;
                    } else if (threshold < 8.3333335E-4f) {
                        threshold = 8.3333335E-4f;
                    }
                    if (dayTime < threshold) {
                        a = 0.0f;
                        break;
                    }
                    if (!(dayTime <= threshold + 8.3333335E-4f)) break;
                    a = (dayTime - threshold) / 8.3333335E-4f;
                    break;
                }
                case SINE_TIME: {
                    a = (float)Math.sin(((float)painting.f_19797_ + Minecraft.m_91087_().getPartialTick()) * opacityModifier.multiplier()) * 0.5f + 0.5f;
                    if (!opacityModifier.invert()) break;
                    a = 1.0f - a;
                }
            }
        }
        return Mth.m_14036_((float)a, (float)0.0f, (float)1.0f);
    }
}

