/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fluids.FluidStack;

public class TransparentStraightPipeRenderer
extends SafeBlockEntityRenderer<StraightPipeBlockEntity> {
    public TransparentStraightPipeRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(StraightPipeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        FluidTransportBehaviour pipe = be.getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null) {
            return;
        }
        for (Direction side : Iterate.directions) {
            LerpedFloat progress;
            FluidStack fluidStack;
            PipeConnection.Flow flow = pipe.getFlow(side);
            if (flow == null || (fluidStack = flow.fluid).isEmpty() || (progress = flow.progress) == null) continue;
            float value = progress.getValue(partialTicks);
            boolean inbound = flow.inbound;
            if (value == 1.0f) {
                if (inbound) {
                    PipeConnection.Flow opposite = pipe.getFlow(side.m_122424_());
                    if (opposite == null) {
                        value -= 1.0E-6f;
                    }
                } else {
                    FluidTransportBehaviour adjacent = BlockEntityBehaviour.get((BlockGetter)be.m_58904_(), be.m_58899_().m_121945_(side), FluidTransportBehaviour.TYPE);
                    if (adjacent == null) {
                        value -= 1.0E-6f;
                    } else {
                        PipeConnection.Flow other = adjacent.getFlow(side.m_122424_());
                        if (other == null || !other.inbound && !other.complete) {
                            value -= 1.0E-6f;
                        }
                    }
                }
            }
            FluidRenderer.renderFluidStream(fluidStack, side, 0.1875f, value, inbound, buffer, ms, light);
        }
    }
}

