/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.mystchonky.tomeofblood.TomeOfBlood;
import com.mystchonky.tomeofblood.common.glyphs.GlyphLibrary;
import com.mystchonky.tomeofblood.common.registry.IntegrationRegistry;
import com.mystchonky.tomeofblood.common.registry.MobEffectRegistry;
import com.mystchonky.tomeofblood.common.util.DemonWillUtil;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.soul.ItemSentientSword;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class EffectSentientHarm
extends AbstractEffect
implements IDamageEffect,
IPotionEffect {
    public static EffectSentientHarm INSTANCE = new EffectSentientHarm();

    public EffectSentientHarm() {
        super(TomeOfBlood.prefix(GlyphLibrary.EffectSentientHarm), "Sentient Harm");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            Entity entity = rayTraceResult.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                EnumDemonWillType type = DemonWillUtil.getActiveTypeFromPlayer(spellContext);
                int souls = (int)PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)type, (Player)player);
                int bracket = DemonWillUtil.getBracket(type, souls);
                int time = (int)spellStats.getDurationMultiplier();
                float damage = (float)((Double)this.DAMAGE.get() + (double)DemonWillUtil.getExtraDamage(type, bracket) + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
                target.m_7292_(new MobEffectInstance((MobEffect)BloodMagicPotions.SOUL_SNARE.get(), 300, 0, false, false));
                this.applyConfigPotion(target, (MobEffect)BloodMagicPotions.SOUL_SNARE.get(), spellStats, false);
                if (time > 0) {
                    this.applyConfigPotion(target, this.getEffectType(type), spellStats);
                } else {
                    boolean damaged = this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)target, this.buildDamageSource(world, shooter), damage);
                    if (damaged && bracket >= 0) {
                        PlayerDemonWillHandler.consumeDemonWill((EnumDemonWillType)type, (Player)player, (double)ItemSentientSword.soulDrainPerSwing[bracket]);
                    }
                }
            }
        }
    }

    public MobEffect getEffectType(EnumDemonWillType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumDemonWillType.DEFAULT -> MobEffects.f_19614_;
            case EnumDemonWillType.CORROSIVE -> MobEffects.f_19615_;
            case EnumDemonWillType.VENGEFUL -> MobEffects.f_19613_;
            case EnumDemonWillType.STEADFAST -> MobEffects.f_19597_;
            case EnumDemonWillType.DESTRUCTIVE -> (MobEffect)MobEffectRegistry.VULNERABLE.get();
        };
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 4.0);
        this.addAmpConfig(builder, 2.0);
        this.addPotionConfig(builder, 5);
        this.addExtendTimeConfig(builder, 5);
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    public int getDefaultManaCost() {
        return 25;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentFortune.INSTANCE});
    }

    public String getBookDescription() {
        return "Consume Demon Will and attack your target (damage scales with will in inventory). Target drops Raw will on kill. $(br2)Extend Time applies potion effect based on Will type. $(br2)Raw - Poison $(br)Corrosive - Withering $(br)Vengeful - Weakness $(br)Steadfast - Slowness $(br)Destructive - Vulnerable ";
    }

    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{IntegrationRegistry.BLOODMAGIC});
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

