/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.common.Journeymap;
import journeymap.common.accessors.ScreenAccess;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.Logger;

public abstract class JmUI
extends Screen
implements ScreenAccess {
    protected final String title;
    protected final int headerHeight = 35;
    protected final Logger logger = Journeymap.getLogger();
    protected Texture logo = TextureCache.getTexture(TextureCache.Logo);
    protected static Stack<Screen> returnDisplayStack = new Stack();
    protected boolean renderBottomBar = false;

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, Screen returnDisplay) {
        super((Component)Constants.getStringTextComponent(title));
        this.title = title;
        returnDisplayStack.push(returnDisplay);
    }

    public Minecraft getMinecraft() {
        this.f_96541_ = Minecraft.m_91087_();
        return this.f_96541_;
    }

    public void m_6575_(Minecraft minecraft, int width, int height) {
        super.m_6575_(minecraft, width, height);
    }

    public boolean m_7043_() {
        return true;
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public void sizeDisplay(PoseStack poseStack, boolean scaled) {
        int glwidth = scaled ? this.f_96543_ : this.f_96541_.m_91268_().m_85443_();
        int glheight = scaled ? this.f_96544_ : this.f_96541_.m_91268_().m_85444_();
        DrawUtil.sizeDisplay(poseStack, glwidth, glheight);
    }

    public double getScaleFactor() {
        double scaleFactor = this.f_96541_.m_91268_().m_85449_();
        int monitorWidth = this.f_96541_.m_91268_().m_85450_().m_84950_().m_85332_();
        int windowWidth = this.f_96541_.m_91268_().m_85441_();
        int screenWidth = this.f_96541_.m_91268_().m_85443_();
        int scaledWidth = this.f_96541_.m_91268_().m_85445_();
        if (Minecraft.f_91002_ && windowWidth > monitorWidth) {
            scaleFactor = this.f_96541_.m_91268_().m_85449_() / (double)(windowWidth / scaledWidth);
            if (screenWidth == monitorWidth) {
                scaleFactor = this.f_96541_.m_91268_().m_85449_() / (double)(windowWidth / monitorWidth);
            }
        }
        return scaleFactor;
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.getRenderables().size(); ++k) {
            Button button;
            net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseEvent) {
        return super.m_6348_(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo(PoseStack poseStack) {
        if (!this.logo.hasImage()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(poseStack, this.f_96541_.m_91268_().m_85443_(), this.f_96541_.m_91268_().m_85444_());
        DrawUtil.drawImage(poseStack, this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(poseStack, this.f_96543_, this.f_96544_);
    }

    protected void renderBottomBar(PoseStack stack) {
        if (this.renderBottomBar) {
            DrawUtil.drawRectangle(stack, 0.0, this.f_96544_ - 30, this.f_96543_, this.f_96544_, 0, 0.6f);
        }
    }

    protected void drawTitle(GuiGraphics graphics) {
        DrawUtil.drawRectangle(graphics.m_280168_(), 0.0, 0.0, this.f_96543_, 35.0, 0, 0.9f);
        DrawUtil.drawLabel(graphics, this.title, this.f_96543_ / 2, 17.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v1.9-SNAPSHOT";
        DrawUtil.drawLabel(graphics, apiVersion, this.f_96543_ - 10, 17.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void m_7856_() {
        this.getRenderables().clear();
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            this.drawGradientRect(guiGraphics, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680, 0);
        } else {
            super.m_280273_(guiGraphics);
        }
    }

    protected abstract void layoutButtons(GuiGraphics var1);

    public List getButtonList() {
        return this.getRenderables();
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float par3) {
        try {
            PoseStack poseStack = guiGraphics.m_280168_();
            this.m_280273_(guiGraphics);
            this.renderBottomBar(poseStack);
            this.layoutButtons(guiGraphics);
            this.drawTitle(guiGraphics);
            this.drawLogo(poseStack);
            List<FormattedCharSequence> tooltip = null;
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                Button button;
                net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
                guibutton.m_88315_(guiGraphics, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getFormattedTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(guiGraphics, tooltip, x, y, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(GuiGraphics guiGraphics, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        guiGraphics.m_285978_(RenderType.m_286086_(), pX1, pY1, pX2, pY2, pColorFrom, pColorTo, pBlitOffset);
    }

    public void close() {
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            if (this.f_96541_.f_91073_ != null) {
                UIManager.INSTANCE.openFullscreenMap();
            } else {
                UIManager.INSTANCE.closeAll();
            }
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public boolean m_5534_(char c, int i) {
        return super.m_5534_(c, i);
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean m_7933_(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.m_7933_(key, value, modifier);
    }

    public void renderTooltip(GuiGraphics graphics, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> FormattedCharSequence.m_13714_((String)e, (Style)Style.f_131099_)).collect(Collectors.toList());
        this.renderWrappedToolTip(graphics, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public Screen getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(GuiGraphics graphics, List tooltip, int mouseX, int mouseY, Font fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof FormattedCharSequence && Minecraft.m_91087_().f_91080_ == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (FormattedCharSequence line : tooltip) {
                int lineWidth = fontRenderer.m_92724_(line);
                if (fontRenderer.m_92718_()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.f_96543_) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.f_96544_) {
                drawY = this.f_96544_ - boxHeight - 6;
            }
            int j1 = -267386864;
            this.drawGradientRect(graphics, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1, 300);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(graphics, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1, 300);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                FormattedCharSequence line = (FormattedCharSequence)tooltip.get(i2);
                if (fontRenderer.m_92718_()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.m_92724_(line) * 1.1);
                    fontRenderer.m_272191_(line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                } else {
                    fontRenderer.m_272191_(line, (float)drawX, (float)drawY, -1, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            RenderWrapper.enableDepthTest();
        }
    }

    @Override
    public List<Renderable> getRenderables() {
        return this.f_169369_;
    }
}

