/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.suite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.illusivesoulworks.diet.api.type.IDietEffect;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietSuite;
import com.illusivesoulworks.diet.common.data.group.DietGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class DietSuite
implements IDietSuite {
    private final String name;
    private final Set<IDietGroup> groups;
    private final List<IDietEffect> effects;

    private DietSuite(String name, Set<IDietGroup> groups, List<IDietEffect> effects) {
        this.name = name;
        TreeSet<IDietGroup> sorted = new TreeSet<IDietGroup>(Comparator.comparing(IDietGroup::getOrder).thenComparing(IDietGroup::getName));
        sorted.addAll(groups);
        this.groups = ImmutableSet.copyOf(sorted);
        this.effects = ImmutableList.copyOf(effects);
    }

    public static IDietSuite load(CompoundTag tag) {
        HashSet<IDietGroup> set = new HashSet<IDietGroup>();
        CompoundTag groups = (CompoundTag)tag.m_128423_("Groups");
        if (groups != null) {
            for (String key : groups.m_128431_()) {
                set.add(DietGroup.load((CompoundTag)Objects.requireNonNull(groups.m_128423_(key))));
            }
        }
        return new DietSuite(tag.m_128461_("Name"), set, new ArrayList<IDietEffect>());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<IDietGroup> getGroups() {
        return this.groups;
    }

    @Override
    public List<IDietEffect> getEffects() {
        return this.effects;
    }

    @Override
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Name", this.name);
        CompoundTag groups = new CompoundTag();
        for (IDietGroup group : this.groups) {
            groups.m_128365_(group.getName(), (Tag)group.save());
        }
        tag.m_128365_("Groups", (Tag)groups);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DietSuite dietSuite = (DietSuite)o;
        return Objects.equals(this.name, dietSuite.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final String name;
        private final Set<IDietGroup> groups;
        private final List<IDietEffect> effects;

        public Builder(String name) {
            this.name = name;
            this.groups = new TreeSet<IDietGroup>(Comparator.comparingInt(IDietGroup::getOrder).thenComparing(IDietGroup::getName));
            this.effects = new ArrayList<IDietEffect>();
        }

        public Builder group(IDietGroup group) {
            this.groups.add(group);
            return this;
        }

        public Builder groups(Set<IDietGroup> groups) {
            this.groups.addAll(groups);
            return this;
        }

        public Builder effect(IDietEffect effect) {
            this.effects.add(effect);
            return this;
        }

        public Builder effects(List<IDietEffect> effects) {
            this.effects.addAll(effects);
            return this;
        }

        public Builder clear() {
            this.groups.clear();
            this.effects.clear();
            return this;
        }

        public IDietSuite build() {
            return new DietSuite(this.name, this.groups, this.effects);
        }
    }
}

