/*
 * Decompiled with CFR 0.152.
 */
package elocindev.necronomicon.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import elocindev.necronomicon.api.json.JsonFileAPI;
import elocindev.necronomicon.config.NecConfig;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"necronomicon");
    private static final Gson BUILDER = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T registerConfig(Path file, Class<T> configClass) {
        try {
            String json;
            if (Files.notExists(file, new LinkOption[0])) {
                T defaultConfig;
                try {
                    LOGGER.info("Creating default config file for " + configClass.getName() + ".");
                    defaultConfig = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create an instance of the config class.", e);
                }
                String defaultJson = BUILDER.toJson(defaultConfig);
                Files.writeString(file, (CharSequence)defaultJson, new OpenOption[0]);
                return defaultConfig;
            }
            try {
                LOGGER.info("File exists, reading config for " + configClass.getName() + ".");
                json = Files.readString(file);
                LOGGER.info("Config for " + configClass.getName() + " read successfully.");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the config file " + file.getFileName().toString(), e);
            }
            Object configEntries = BUILDER.fromJson(json, configClass);
            String updatedJson = BUILDER.toJson(configEntries);
            JsonObject updatedJsonObject = (JsonObject)BUILDER.fromJson(updatedJson, JsonObject.class);
            JsonObject originalJsonObject = (JsonObject)BUILDER.fromJson(json, JsonObject.class);
            for (String key : originalJsonObject.keySet()) {
                if (updatedJsonObject.has(key)) continue;
                originalJsonObject.remove(key);
            }
            try {
                Files.writeString(file, (CharSequence)originalJsonObject.toString(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write the updated config to file.", e);
            }
            JsonFileAPI.setPrettyPrint(file);
            return (T)configEntries;
        }
        catch (Exception e) {
            throw new RuntimeException(file.getFileName().toString() + " - Failed to register config, it is likely that you added invalid entries in your config, or that the formatting isn't valid.", e);
        }
    }

    public static <T> void initializeConfigs(Class<T> configClass) {
        Field[] fields;
        for (Field field : fields = configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(NecConfig.class)) continue;
            try {
                if (field.getType() != configClass) continue;
                field.setAccessible(true);
                String filePath = (String)field.getType().getMethod("getFile", new Class[0]).invoke(null, new Object[0]);
                Path file = Paths.get(filePath, new String[0]);
                Object configInstance = ConfigBuilder.registerConfig(file, field.getType());
                field.set(field, configInstance);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize config field: " + field.getName(), e);
            }
        }
    }
}

