/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Axis {
    X{

        @Override
        public double get(double x, double y, double z) {
            return x;
        }

        @Override
        public float get(float x, float y, float z) {
            return x;
        }

        @Override
        public int get(int x, int y, int z) {
            return x;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return x;
        }

        @Override
        public int get(Vec3i vec) {
            return vec.m_123341_();
        }

        @Override
        public Vec3i set(Vec3i vec, int value) {
            return new Vec3i(value, vec.m_123342_(), vec.m_123343_());
        }

        @Override
        public BlockPos set(BlockPos pos, int value) {
            return new BlockPos(value, pos.m_123342_(), pos.m_123343_());
        }

        @Override
        public void set(BlockPos.MutableBlockPos pos, int value) {
            pos.m_142451_(value);
        }

        @Override
        public SectionPos set(SectionPos pos, int value) {
            return SectionPos.m_123173_((int)value, (int)pos.m_123342_(), (int)pos.m_123343_());
        }

        @Override
        public int get(ChunkPos pos) {
            return pos.f_45578_;
        }

        @Override
        public ChunkPos set(ChunkPos pos, int value) {
            return new ChunkPos(value, pos.f_45579_);
        }

        @Override
        public double get(Vec3 vec) {
            return vec.f_82479_;
        }

        @Override
        public Vec3 set(Vec3 vec, double value) {
            return new Vec3(value, vec.f_82480_, vec.f_82481_);
        }

        @Override
        public double get(Vector3d vec) {
            return vec.x;
        }

        @Override
        public void set(Vector3d vec, double value) {
            vec.x = value;
        }

        @Override
        public float get(Vector3f vec) {
            return vec.x;
        }

        @Override
        public void set(Vector3f vec, float value) {
            vec.x = value;
        }

        @Override
        public Axis one() {
            return Y;
        }

        @Override
        public Axis two() {
            return Z;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.EAST : Facing.WEST;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.X;
        }

        @Override
        public Vec3i mirror(Vec3i vec) {
            return new Vec3i(-vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }

        @Override
        public BlockPos mirror(BlockPos vec) {
            return new BlockPos(-vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }
    }
    ,
    Y{

        @Override
        public double get(double x, double y, double z) {
            return y;
        }

        @Override
        public float get(float x, float y, float z) {
            return y;
        }

        @Override
        public int get(int x, int y, int z) {
            return y;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return y;
        }

        @Override
        public int get(Vec3i vec) {
            return vec.m_123342_();
        }

        @Override
        public Vec3i set(Vec3i vec, int value) {
            return new Vec3i(vec.m_123341_(), value, vec.m_123343_());
        }

        @Override
        public BlockPos set(BlockPos pos, int value) {
            return new BlockPos(pos.m_123341_(), value, pos.m_123343_());
        }

        @Override
        public void set(BlockPos.MutableBlockPos pos, int value) {
            pos.m_142448_(value);
        }

        @Override
        public SectionPos set(SectionPos pos, int value) {
            return SectionPos.m_123173_((int)pos.m_123341_(), (int)value, (int)pos.m_123343_());
        }

        @Override
        public int get(ChunkPos pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChunkPos set(ChunkPos pos, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double get(Vec3 vec) {
            return vec.f_82480_;
        }

        @Override
        public Vec3 set(Vec3 vec, double value) {
            return new Vec3(vec.f_82479_, value, vec.f_82481_);
        }

        @Override
        public double get(Vector3d vec) {
            return vec.y;
        }

        @Override
        public void set(Vector3d vec, double value) {
            vec.y = value;
        }

        @Override
        public float get(Vector3f vec) {
            return vec.y;
        }

        @Override
        public void set(Vector3f vec, float value) {
            vec.y = value;
        }

        @Override
        public Axis one() {
            return Z;
        }

        @Override
        public Axis two() {
            return X;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.UP : Facing.DOWN;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.Y;
        }

        @Override
        public Vec3i mirror(Vec3i vec) {
            return new Vec3i(vec.m_123341_(), -vec.m_123342_(), vec.m_123343_());
        }

        @Override
        public BlockPos mirror(BlockPos vec) {
            return new BlockPos(vec.m_123341_(), -vec.m_123342_(), vec.m_123343_());
        }
    }
    ,
    Z{

        @Override
        public double get(double x, double y, double z) {
            return z;
        }

        @Override
        public float get(float x, float y, float z) {
            return z;
        }

        @Override
        public int get(int x, int y, int z) {
            return z;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return z;
        }

        @Override
        public int get(Vec3i vec) {
            return vec.m_123343_();
        }

        @Override
        public Vec3i set(Vec3i vec, int value) {
            return new Vec3i(vec.m_123341_(), vec.m_123342_(), value);
        }

        @Override
        public BlockPos set(BlockPos pos, int value) {
            return new BlockPos(pos.m_123341_(), pos.m_123342_(), value);
        }

        @Override
        public void set(BlockPos.MutableBlockPos pos, int value) {
            pos.m_142443_(value);
        }

        @Override
        public SectionPos set(SectionPos pos, int value) {
            return SectionPos.m_123173_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)value);
        }

        @Override
        public int get(ChunkPos pos) {
            return pos.f_45579_;
        }

        @Override
        public ChunkPos set(ChunkPos pos, int value) {
            return new ChunkPos(pos.f_45578_, value);
        }

        @Override
        public double get(Vec3 vec) {
            return vec.f_82481_;
        }

        @Override
        public Vec3 set(Vec3 vec, double value) {
            return new Vec3(vec.f_82479_, vec.f_82480_, value);
        }

        @Override
        public double get(Vector3d vec) {
            return vec.z;
        }

        @Override
        public void set(Vector3d vec, double value) {
            vec.z = value;
        }

        @Override
        public float get(Vector3f vec) {
            return vec.z;
        }

        @Override
        public void set(Vector3f vec, float value) {
            vec.z = value;
        }

        @Override
        public Axis one() {
            return X;
        }

        @Override
        public Axis two() {
            return Y;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.SOUTH : Facing.NORTH;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.Z;
        }

        @Override
        public Vec3i mirror(Vec3i vec) {
            return new Vec3i(vec.m_123341_(), vec.m_123342_(), -vec.m_123343_());
        }

        @Override
        public BlockPos mirror(BlockPos vec) {
            return new BlockPos(vec.m_123341_(), vec.m_123342_(), -vec.m_123343_());
        }
    };


    public static Axis get(Direction.Axis axis) {
        return switch (axis) {
            case Direction.Axis.X -> X;
            case Direction.Axis.Y -> Y;
            case Direction.Axis.Z -> Z;
            default -> throw new IllegalArgumentException();
        };
    }

    public static Axis third(Axis one, Axis two) {
        switch (one) {
            case X: {
                if (two == Y) {
                    return Z;
                }
                return Y;
            }
            case Y: {
                if (two == X) {
                    return Z;
                }
                return X;
            }
            case Z: {
                if (two == Y) {
                    return X;
                }
                return Y;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis getMirrorAxis(Mirror mirrorIn) {
        return switch (mirrorIn) {
            case Mirror.FRONT_BACK -> X;
            case Mirror.LEFT_RIGHT -> Z;
            default -> null;
        };
    }

    public abstract Axis one();

    public abstract Axis two();

    public abstract Facing facing(boolean var1);

    public abstract double get(double var1, double var3, double var5);

    public abstract float get(float var1, float var2, float var3);

    public abstract int get(int var1, int var2, int var3);

    public abstract int get(Vec3i var1);

    public abstract Vec3i set(Vec3i var1, int var2);

    public abstract BlockPos set(BlockPos var1, int var2);

    public abstract void set(BlockPos.MutableBlockPos var1, int var2);

    public abstract SectionPos set(SectionPos var1, int var2);

    public abstract int get(ChunkPos var1);

    public abstract ChunkPos set(ChunkPos var1, int var2);

    public abstract double get(Vec3 var1);

    public abstract Vec3 set(Vec3 var1, double var2);

    public abstract double get(Vector3d var1);

    public abstract void set(Vector3d var1, double var2);

    public abstract float get(Vector3f var1);

    public abstract void set(Vector3f var1, float var2);

    public abstract <T> T get(T var1, T var2, T var3);

    public abstract Direction.Axis toVanilla();

    public Facing mirror(Facing facing) {
        if (facing.axis == this) {
            return facing.opposite();
        }
        return facing;
    }

    public Direction mirror(Direction facing) {
        if (facing.m_122434_() == this.toVanilla()) {
            return facing.m_122424_();
        }
        return facing;
    }

    public abstract Vec3i mirror(Vec3i var1);

    public abstract BlockPos mirror(BlockPos var1);

    public void mirror(Vec3d vec) {
        vec.set(this, -vec.get(this));
    }

    public void mirror(Vec3f vec) {
        vec.set(this, -vec.get(this));
    }
}

