/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobal;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;

public interface IGuiInventory {
    public static final GuiSyncGlobal<GuiControl, CompoundTag> SYNC = GuiSyncHolder.GLOBAL.register("inv_one", (control, nbt) -> {
        IGuiInventory inventory = (IGuiInventory)((Object)control);
        for (String name : nbt.m_128431_()) {
            int id = Integer.parseInt(name);
            inventory.getSlot((int)id).slot.m_5852_(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(name)));
            inventory.setChanged(id);
        }
    });
    public static final GuiSyncGlobal<GuiControl, ListTag> SYNC_ALL = GuiSyncHolder.GLOBAL.register("inv_all", (control, list) -> {
        IGuiInventory inventory = (IGuiInventory)((Object)control);
        for (int i = 0; i < inventory.inventorySize(); ++i) {
            inventory.getSlot((int)i).slot.m_5852_(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
        inventory.setChanged();
    });

    public GuiSlot getSlot(int var1);

    public int inventorySize();

    public String name();

    public void setChanged();

    public void setChanged(int var1);

    default public void insert(ItemStack toAdd, boolean useEmptySlot) {
        for (int i = 0; i < this.inventorySize(); ++i) {
            GuiSlot slot = this.getSlot(i);
            if (!useEmptySlot && !slot.slot.m_6657_() || !(toAdd = slot.insert(toAdd)).m_41619_()) continue;
            return;
        }
    }

    default public void extract(ItemStack toDrain) {
        Player player = ((GuiControl)((Object)this)).getPlayer();
        for (int i = 0; i < this.inventorySize(); ++i) {
            int transfer;
            GuiSlot slot = this.getSlot(i);
            if (!slot.slot.m_8010_(player) || !ItemStack.m_150942_((ItemStack)toDrain, (ItemStack)slot.getStack()) || (transfer = Math.min(toDrain.m_41613_(), slot.getStack().m_41613_())) <= 0) continue;
            ItemStack drained = slot.slot.m_6201_(transfer);
            slot.slot.m_142406_(player, drained);
            toDrain.m_41774_(transfer);
            if (!toDrain.m_41619_()) continue;
            return;
        }
    }

    default public void sync(Iterable<Integer> ids) {
        GuiControl control = (GuiControl)((Object)this);
        if (control.isClient()) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        for (Integer id : ids) {
            nbt.m_128365_("" + id, (Tag)this.getSlot((int)id.intValue()).slot.m_7993_().m_41739_(new CompoundTag()));
        }
        SYNC.send(control, nbt);
    }

    default public void syncAll() {
        GuiControl control = (GuiControl)((Object)this);
        if (control.isClient()) {
            return;
        }
        ListTag list = new ListTag();
        for (int i = 0; i < this.inventorySize(); ++i) {
            list.add((Object)this.getSlot((int)i).slot.m_7993_().m_41739_(new CompoundTag()));
        }
        SYNC_ALL.send(control, list);
    }
}

