/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.mixin;

import com.hypherionmc.craterlib.api.blockentity.caps.CraterCapabilityHandler;
import com.hypherionmc.craterlib.api.blockentity.caps.ICraterCapProvider;
import com.hypherionmc.craterlib.common.blockentity.CraterBlockEntity;
import com.hypherionmc.craterlib.core.systems.energy.CustomEnergyStorage;
import com.hypherionmc.craterlib.core.systems.inventory.SimpleInventory;
import com.hypherionmc.craterlib.systems.energy.ForgeEnergyWrapper;
import com.hypherionmc.craterlib.systems.fluid.ForgeWrappedFluidTank;
import com.hypherionmc.craterlib.systems.inventory.ForgeInventoryWrapper;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={CraterBlockEntity.class})
public class BlockEntityMixin
implements ICapabilityProvider {
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Optional fluidTank;
        Optional inventory;
        Optional forgeCap;
        ICraterCapProvider capProvider = (ICraterCapProvider)((Object)this);
        if (cap == ForgeCapabilities.ENERGY && (forgeCap = capProvider.getCapability(CraterCapabilityHandler.ENERGY, side)).isPresent()) {
            return LazyOptional.of(() -> new ForgeEnergyWrapper((CustomEnergyStorage)forgeCap.get())).cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && (inventory = capProvider.getCapability(CraterCapabilityHandler.ITEM, side)).isPresent()) {
            return LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)new ForgeInventoryWrapper((SimpleInventory)inventory.get()), side)).cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && (fluidTank = capProvider.getCapability(CraterCapabilityHandler.FLUID, side)).isPresent()) {
            return LazyOptional.of(() -> (ForgeWrappedFluidTank)fluidTank.get()).cast();
        }
        return LazyOptional.empty();
    }
}

