/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.systems.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class SimpleInventory
implements Clearable {
    private final SimpleContainer itemHandler;
    private final int size;
    private final int stackSize;

    public SimpleInventory(int size, final int maxStackSize) {
        this.itemHandler = new SimpleContainer(size){

            public int m_6893_() {
                return maxStackSize;
            }
        };
        this.size = size;
        this.stackSize = maxStackSize;
    }

    private static void copyToInv(NonNullList<ItemStack> src, Container dest) {
        Preconditions.checkArgument((src.size() == dest.m_6643_() ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            dest.m_6836_(i, (ItemStack)src.get(i));
        }
    }

    private static NonNullList<ItemStack> copyFromInv(Container inv) {
        NonNullList ret = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ret.set(i, (Object)inv.m_8020_(i));
        }
        return ret;
    }

    public void readNBT(CompoundTag tag) {
        NonNullList tmp = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)tmp);
        SimpleInventory.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
    }

    public void writeNBT(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, SimpleInventory.copyFromInv((Container)this.itemHandler));
    }

    public final int inventorySize() {
        return this.getItemHandler().m_6643_();
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void m_6211_() {
        this.getItemHandler().m_6211_();
    }

    public final Container getItemHandler() {
        return this.itemHandler;
    }
}

