/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.config;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.core.config.ModuleConfig;
import java.io.Serializable;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import shadow.hypherionmc.moonconfig.core.file.FileWatcher;

public final class ConfigController
implements Serializable {
    private static final HashMap<Object, FileWatcher> monitoredConfigs = new HashMap();

    @ApiStatus.Internal
    public static void register_config(ModuleConfig config) {
        if (monitoredConfigs.containsKey(config)) {
            CraterConstants.LOG.error("Failed to register " + config.getConfigPath().getName() + ". Config already registered");
        } else {
            FileWatcher configWatcher = new FileWatcher();
            try {
                configWatcher.setWatch(config.getConfigPath(), () -> {
                    if (!config.isSaveCalled()) {
                        CraterConstants.LOG.info("Sending Reload Event for: " + config.getConfigPath().getName());
                        config.configReloaded();
                    }
                });
            }
            catch (Exception e) {
                CraterConstants.LOG.error("Failed to register " + config.getConfigPath().getName() + " for auto reloading. " + e.getMessage());
            }
            monitoredConfigs.put(config, configWatcher);
            CraterConstants.LOG.info("Registered " + config.getConfigPath().getName() + " successfully!");
        }
    }

    public static HashMap<Object, FileWatcher> getMonitoredConfigs() {
        return monitoredConfigs;
    }
}

