/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.common.blockentity;

import com.hypherionmc.craterlib.api.blockentity.caps.CraterCapabilityHandler;
import com.hypherionmc.craterlib.common.blockentity.CraterBlockEntity;
import com.hypherionmc.craterlib.core.platform.CraterFluidHelper;
import com.hypherionmc.craterlib.core.systems.fluid.CraterFluidTank;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidContainerBlockEntity
extends CraterBlockEntity {
    public final CraterFluidTank fluidTank;

    public FluidContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int capacity) {
        super(blockEntityType, pos, state);
        this.fluidTank = CraterFluidHelper.INSTANCE.createFluidTank(capacity);
    }

    public FluidContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int capacity, Fluid ... validFluids) {
        super(blockEntityType, pos, state);
        this.fluidTank = CraterFluidHelper.INSTANCE.createFluidTank(capacity, validFluids);
        this.fluidTank.setChangeListener(this::sendUpdates);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidTank.writeToNBT(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidTank.readFromNBT(tag);
    }

    @Override
    public <T> Optional<T> getCapability(CraterCapabilityHandler handler, @Nullable Direction side) {
        if (handler == CraterCapabilityHandler.FLUID) {
            return Optional.of(this.fluidTank);
        }
        return super.getCapability(handler, side);
    }

    public CraterFluidTank getFluidTank() {
        return this.fluidTank;
    }
}

